/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.idp.saml.rest.action;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.idp.action.SamlInitiateSingleSignOnAction;
import org.elasticsearch.xpack.idp.action.SamlInitiateSingleSignOnRequest;
import org.elasticsearch.xpack.idp.action.SamlInitiateSingleSignOnResponse;
import org.elasticsearch.xpack.idp.saml.rest.action.IdpBaseRestHandler;
import org.elasticsearch.xpack.idp.saml.support.SamlAuthenticationState;
import org.elasticsearch.xpack.idp.saml.support.SamlInitiateSingleSignOnAttributes;

public class RestSamlInitiateSingleSignOnAction
extends IdpBaseRestHandler {
    static final ObjectParser<SamlInitiateSingleSignOnRequest, Void> PARSER = new ObjectParser("idp_init_sso", SamlInitiateSingleSignOnRequest::new);

    public RestSamlInitiateSingleSignOnAction(XPackLicenseState licenseState) {
        super(licenseState);
    }

    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.POST, "/_idp/saml/init"));
    }

    public String getName() {
        return "saml_idp_init_sso_action";
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        try (XContentParser parser = request.contentParser();){
            SamlInitiateSingleSignOnRequest initRequest = (SamlInitiateSingleSignOnRequest)((Object)PARSER.parse(parser, null));
            BaseRestHandler.RestChannelConsumer restChannelConsumer = channel -> client.execute((ActionType)SamlInitiateSingleSignOnAction.INSTANCE, (ActionRequest)initRequest, (ActionListener)new RestBuilderListener<SamlInitiateSingleSignOnResponse>(this, channel){

                public RestResponse buildResponse(SamlInitiateSingleSignOnResponse response, XContentBuilder builder) throws Exception {
                    builder.startObject();
                    response.toXContent(builder);
                    builder.endObject();
                    return new RestResponse(RestStatus.OK, builder);
                }
            });
            return restChannelConsumer;
        }
    }

    static {
        PARSER.declareString(SamlInitiateSingleSignOnRequest::setSpEntityId, new ParseField("entity_id", new String[0]));
        PARSER.declareString(SamlInitiateSingleSignOnRequest::setAssertionConsumerService, new ParseField("acs", new String[0]));
        PARSER.declareObject(SamlInitiateSingleSignOnRequest::setSamlAuthenticationState, (p, c) -> SamlAuthenticationState.fromXContent(p), new ParseField("authn_state", new String[0]));
        PARSER.declareObject(SamlInitiateSingleSignOnRequest::setAttributes, (p, c) -> SamlInitiateSingleSignOnAttributes.fromXContent(p), new ParseField("attributes", new String[0]));
    }
}

