/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.querydsl.agg;

import java.util.List;
import java.util.function.Function;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.metrics.PercentilesConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.xpack.sql.querydsl.agg.AggSource;
import org.elasticsearch.xpack.sql.querydsl.agg.DefaultAggSourceLeafAgg;

public class PercentileRanksAgg
extends DefaultAggSourceLeafAgg {
    private final List<Double> values;
    private final PercentilesConfig percentilesConfig;

    public PercentileRanksAgg(String id, AggSource source, List<Double> values, PercentilesConfig percentilesConfig) {
        super(id, source);
        this.values = values;
        this.percentilesConfig = percentilesConfig;
    }

    @Override
    Function<String, ValuesSourceAggregationBuilder<?>> builder() {
        return s -> AggregationBuilders.percentileRanks((String)s, (double[])this.values.stream().mapToDouble(Double::doubleValue).toArray()).percentilesConfig(this.percentilesConfig);
    }
}

