/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plan.physical;

import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.sql.plan.physical.LeafExec;
import org.elasticsearch.xpack.sql.plan.physical.Unexecutable;
import org.elasticsearch.xpack.sql.planner.PlanningException;
import org.elasticsearch.xpack.sql.session.Cursor;
import org.elasticsearch.xpack.sql.session.SqlSession;

public class UnplannedExec
extends LeafExec
implements Unexecutable {
    private final LogicalPlan plan;

    public UnplannedExec(Source source, LogicalPlan plan) {
        super(source);
        this.plan = plan;
    }

    protected NodeInfo<UnplannedExec> info() {
        return NodeInfo.create((Node)this, UnplannedExec::new, (Object)this.plan);
    }

    public LogicalPlan plan() {
        return this.plan;
    }

    @Override
    public List<Attribute> output() {
        return this.plan.output();
    }

    @Override
    void execute(SqlSession session, ActionListener<Cursor.Page> listener) {
        throw new PlanningException("Current plan {} is not executable", this);
    }

    @Override
    public int hashCode() {
        return this.plan.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UnplannedExec other = (UnplannedExec)obj;
        return Objects.equals(this.plan, other.plan);
    }

    public String nodeString() {
        return this.nodeName() + "[" + this.plan.nodeString() + "]";
    }
}

