/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.gpu.codec;

import com.nvidia.cuvs.CuVSMatrix;
import com.nvidia.cuvs.CuVSResources;
import com.nvidia.cuvs.GPUInfoProvider;
import com.nvidia.cuvs.spi.CuVSProvider;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.elasticsearch.core.Strings;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.xpack.gpu.GPUSupport;

public interface CuVSResourceManager {
    public ManagedCuVSResources acquire(int var1, int var2, CuVSMatrix.DataType var3) throws InterruptedException;

    public void finishedComputation(ManagedCuVSResources var1);

    public void release(ManagedCuVSResources var1);

    public void shutdown();

    public static CuVSResourceManager pooling() {
        return PoolingCuVSResourceManager.Holder.INSTANCE;
    }

    public static class PoolingCuVSResourceManager
    implements CuVSResourceManager {
        static final Logger logger = LogManager.getLogger(CuVSResourceManager.class);
        static final double GPU_COMPUTATION_MEMORY_FACTOR = 2.0;
        static final int MAX_RESOURCES = 4;
        private final ManagedCuVSResources[] pool;
        private final int capacity;
        private final GPUInfoProvider gpuInfoProvider;
        private int createdCount;
        ReentrantLock lock = new ReentrantLock();
        Condition enoughResourcesCondition = this.lock.newCondition();

        public PoolingCuVSResourceManager(int capacity, GPUInfoProvider gpuInfoProvider) {
            if (capacity < 1 || capacity > 4) {
                throw new IllegalArgumentException("Resource count must be between 1 and 4");
            }
            this.capacity = capacity;
            this.gpuInfoProvider = gpuInfoProvider;
            this.pool = new ManagedCuVSResources[4];
        }

        private ManagedCuVSResources getResourceFromPool() {
            for (int i = 0; i < this.createdCount; ++i) {
                ManagedCuVSResources res = this.pool[i];
                if (res.locked) continue;
                return res;
            }
            if (this.createdCount < this.capacity) {
                ManagedCuVSResources res = new ManagedCuVSResources(Objects.requireNonNull(this.createNew()));
                this.pool[this.createdCount++] = res;
                return res;
            }
            return null;
        }

        private int numLockedResources() {
            int lockedResources = 0;
            for (int i = 0; i < this.createdCount; ++i) {
                ManagedCuVSResources res = this.pool[i];
                if (!res.locked) continue;
                ++lockedResources;
            }
            return lockedResources;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ManagedCuVSResources acquire(int numVectors, int dims, CuVSMatrix.DataType dataType) throws InterruptedException {
            try {
                long started = System.nanoTime();
                this.lock.lock();
                boolean allConditionsMet = false;
                ManagedCuVSResources res = null;
                while (!allConditionsMet) {
                    boolean enoughMemory;
                    res = this.getResourceFromPool();
                    if (res != null) {
                        long requiredMemoryInBytes = this.estimateRequiredMemory(numVectors, dims, dataType);
                        logger.debug("Estimated memory for [{}] vectors, [{}] dims of type [{}] is [{} B]", new Object[]{numVectors, dims, dataType.name(), requiredMemoryInBytes});
                        long totalDeviceMemoryInBytes = this.gpuInfoProvider.getCurrentInfo((CuVSResources)res).totalDeviceMemoryInBytes();
                        if (requiredMemoryInBytes > totalDeviceMemoryInBytes) {
                            String message = Strings.format((String)"Requested GPU memory for [%d] vectors, [%d] dims is greater than the GPU total memory [%d B]", (Object[])new Object[]{numVectors, dims, totalDeviceMemoryInBytes});
                            logger.error(message);
                            throw new IllegalArgumentException(message);
                        }
                        if (this.numLockedResources() == 0) {
                            logger.debug("No resources currently locked, proceeding");
                            break;
                        }
                        long freeDeviceMemoryInBytes = this.gpuInfoProvider.getCurrentInfo((CuVSResources)res).freeDeviceMemoryInBytes();
                        enoughMemory = requiredMemoryInBytes <= freeDeviceMemoryInBytes;
                        logger.debug("Free device memory [{} B], enoughMemory[{}]", new Object[]{freeDeviceMemoryInBytes, enoughMemory});
                    } else {
                        logger.debug("No resources available in pool");
                        enoughMemory = false;
                    }
                    if (allConditionsMet = enoughMemory) continue;
                    this.enoughResourcesCondition.await();
                }
                long elapsed = started - System.nanoTime();
                logger.debug("Resource acquired in [{}ms]", new Object[]{(double)elapsed / 1000000.0});
                res.locked = true;
                ManagedCuVSResources managedCuVSResources = res;
                return managedCuVSResources;
            }
            finally {
                this.lock.unlock();
            }
        }

        private long estimateRequiredMemory(int numVectors, int dims, CuVSMatrix.DataType dataType) {
            int elementTypeBytes = switch (dataType) {
                default -> throw new MatchException(null, null);
                case CuVSMatrix.DataType.FLOAT -> 4;
                case CuVSMatrix.DataType.INT, CuVSMatrix.DataType.UINT -> 4;
                case CuVSMatrix.DataType.BYTE -> 1;
            };
            return (long)(2.0 * (double)numVectors * (double)dims * (double)elementTypeBytes);
        }

        protected CuVSResources createNew() {
            return GPUSupport.cuVSResourcesOrNull(true);
        }

        @Override
        public void finishedComputation(ManagedCuVSResources resources) {
            logger.debug("Computation finished");
        }

        @Override
        public void release(ManagedCuVSResources resources) {
            logger.debug("Releasing resources to pool");
            try {
                this.lock.lock();
                assert (resources.locked);
                resources.locked = false;
                this.enoughResourcesCondition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public void shutdown() {
            for (int i = 0; i < this.createdCount; ++i) {
                ManagedCuVSResources res = this.pool[i];
                assert (res != null);
                res.delegate.close();
            }
        }

        static class Holder {
            static final PoolingCuVSResourceManager INSTANCE = new PoolingCuVSResourceManager(4, CuVSProvider.provider().gpuInfoProvider());

            Holder() {
            }
        }
    }

    public static final class ManagedCuVSResources
    implements CuVSResources {
        final CuVSResources delegate;
        boolean locked = false;

        ManagedCuVSResources(CuVSResources resources) {
            this.delegate = resources;
        }

        public CuVSResources.ScopedAccess access() {
            return this.delegate.access();
        }

        public int deviceId() {
            return this.delegate.deviceId();
        }

        public void close() {
            throw new UnsupportedOperationException("this resource is managed, cannot be closed by clients");
        }

        public Path tempDirectory() {
            return null;
        }

        public String toString() {
            return "ManagedCuVSResources[delegate=" + String.valueOf(this.delegate) + "]";
        }
    }
}

