/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.gpu;

import java.util.List;
import org.apache.lucene.codecs.KnnVectorsFormat;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.util.FeatureFlag;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;
import org.elasticsearch.index.mapper.vectors.VectorsFormatProvider;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.internal.InternalVectorFormatProviderPlugin;
import org.elasticsearch.xpack.gpu.GPUSupport;
import org.elasticsearch.xpack.gpu.codec.ES92GpuHnswSQVectorsFormat;
import org.elasticsearch.xpack.gpu.codec.ES92GpuHnswVectorsFormat;

public class GPUPlugin
extends Plugin
implements InternalVectorFormatProviderPlugin {
    public static final FeatureFlag GPU_FORMAT = new FeatureFlag("gpu_vectors_indexing");
    public static final Setting<GpuMode> VECTORS_INDEXING_USE_GPU_SETTING = Setting.enumSetting(GpuMode.class, (String)"index.vectors.indexing.use_gpu", (Enum)GpuMode.AUTO, (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope, Setting.Property.Dynamic});

    public List<Setting<?>> getSettings() {
        if (GPU_FORMAT.isEnabled()) {
            return List.of(VECTORS_INDEXING_USE_GPU_SETTING);
        }
        return List.of();
    }

    public VectorsFormatProvider getVectorsFormatProvider() {
        return (indexSettings, indexOptions) -> {
            if (GPU_FORMAT.isEnabled()) {
                GpuMode gpuMode = (GpuMode)((Object)((Object)indexSettings.getValue(VECTORS_INDEXING_USE_GPU_SETTING)));
                if (gpuMode == GpuMode.TRUE) {
                    if (!this.vectorIndexTypeSupported(indexOptions.getType())) {
                        throw new IllegalArgumentException("[index.vectors.indexing.use_gpu] doesn't support [index_options.type] of [" + String.valueOf(indexOptions.getType()) + "].");
                    }
                    if (!GPUSupport.isSupported(true)) {
                        throw new IllegalArgumentException("[index.vectors.indexing.use_gpu] was set to [true], but GPU resources are not accessible on the node.");
                    }
                    return GPUPlugin.getVectorsFormat(indexOptions);
                }
                if (gpuMode == GpuMode.AUTO && this.vectorIndexTypeSupported(indexOptions.getType()) && GPUSupport.isSupported(false)) {
                    return GPUPlugin.getVectorsFormat(indexOptions);
                }
            }
            return null;
        };
    }

    private boolean vectorIndexTypeSupported(DenseVectorFieldMapper.VectorIndexType type) {
        return type == DenseVectorFieldMapper.VectorIndexType.HNSW || type == DenseVectorFieldMapper.VectorIndexType.INT8_HNSW;
    }

    private static KnnVectorsFormat getVectorsFormat(DenseVectorFieldMapper.DenseVectorIndexOptions indexOptions) {
        if (indexOptions.getType() == DenseVectorFieldMapper.VectorIndexType.HNSW) {
            DenseVectorFieldMapper.HnswIndexOptions hnswIndexOptions = (DenseVectorFieldMapper.HnswIndexOptions)indexOptions;
            int efConstruction = hnswIndexOptions.efConstruction();
            if (efConstruction == 100) {
                efConstruction = 128;
            }
            return new ES92GpuHnswVectorsFormat(hnswIndexOptions.m(), efConstruction);
        }
        if (indexOptions.getType() == DenseVectorFieldMapper.VectorIndexType.INT8_HNSW) {
            DenseVectorFieldMapper.Int8HnswIndexOptions int8HnswIndexOptions = (DenseVectorFieldMapper.Int8HnswIndexOptions)indexOptions;
            int efConstruction = int8HnswIndexOptions.efConstruction();
            if (efConstruction == 100) {
                efConstruction = 128;
            }
            return new ES92GpuHnswSQVectorsFormat(int8HnswIndexOptions.m(), efConstruction, int8HnswIndexOptions.confidenceInterval(), 7, false);
        }
        throw new IllegalArgumentException("GPU vector indexing is not supported on this vector type: [" + String.valueOf(indexOptions.getType()) + "]");
    }

    public static enum GpuMode {
        TRUE,
        FALSE,
        AUTO;

    }
}

