/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation.spatial;

import java.nio.ByteOrder;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.IntArray;
import org.elasticsearch.compute.aggregation.AbstractArrayState;
import org.elasticsearch.compute.aggregation.GroupingAggregatorState;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.aggregation.spatial.PointType;
import org.elasticsearch.compute.aggregation.spatial.SpatialAggregationUtils;
import org.elasticsearch.compute.aggregation.spatial.SpatialExtentStateWrappedLongitudeState;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.GeometryVisitor;
import org.elasticsearch.geometry.utils.SpatialEnvelopeVisitor;
import org.elasticsearch.geometry.utils.WellKnownBinary;

final class SpatialExtentGroupingStateWrappedLongitudeState
extends AbstractArrayState
implements GroupingAggregatorState {
    private static final PointType POINT_TYPE = PointType.GEO;
    private IntArray tops;
    private IntArray bottoms;
    private IntArray negLefts;
    private IntArray negRights;
    private IntArray posLefts;
    private IntArray posRights;
    private final SpatialEnvelopeVisitor.GeoPointVisitor geoPointVisitor;

    SpatialExtentGroupingStateWrappedLongitudeState() {
        this(BigArrays.NON_RECYCLING_INSTANCE);
    }

    SpatialExtentGroupingStateWrappedLongitudeState(BigArrays bigArrays) {
        super(bigArrays);
        this.tops = bigArrays.newIntArray(0L, false);
        this.bottoms = bigArrays.newIntArray(0L, false);
        this.negLefts = bigArrays.newIntArray(0L, false);
        this.negRights = bigArrays.newIntArray(0L, false);
        this.posLefts = bigArrays.newIntArray(0L, false);
        this.posRights = bigArrays.newIntArray(0L, false);
        this.enableGroupIdTracking(new SeenGroupIds.Empty());
        this.geoPointVisitor = new SpatialEnvelopeVisitor.GeoPointVisitor(SpatialEnvelopeVisitor.WrapLongitude.WRAP);
    }

    @Override
    public void toIntermediate(Block[] blocks, int offset, IntVector selected, DriverContext driverContext) {
        assert (blocks.length >= offset);
        try (IntBlock.Builder topsBuilder = driverContext.blockFactory().newIntBlockBuilder(selected.getPositionCount());
             IntBlock.Builder bottomsBuilder = driverContext.blockFactory().newIntBlockBuilder(selected.getPositionCount());
             IntBlock.Builder negLeftsBuilder = driverContext.blockFactory().newIntBlockBuilder(selected.getPositionCount());
             IntBlock.Builder negRightsBuilder = driverContext.blockFactory().newIntBlockBuilder(selected.getPositionCount());
             IntBlock.Builder posLeftsBuilder = driverContext.blockFactory().newIntBlockBuilder(selected.getPositionCount());
             IntBlock.Builder posRightsBuilder = driverContext.blockFactory().newIntBlockBuilder(selected.getPositionCount());){
            for (int i = 0; i < selected.getPositionCount(); ++i) {
                int group = selected.getInt(i);
                if (this.hasValue(group)) {
                    topsBuilder.appendInt(this.tops.get((long)group));
                    bottomsBuilder.appendInt(this.bottoms.get((long)group));
                    negLeftsBuilder.appendInt(this.negLefts.get((long)group));
                    negRightsBuilder.appendInt(this.negRights.get((long)group));
                    posLeftsBuilder.appendInt(this.posLefts.get((long)group));
                    posRightsBuilder.appendInt(this.posRights.get((long)group));
                    continue;
                }
                topsBuilder.appendInt(Integer.MIN_VALUE);
                bottomsBuilder.appendInt(Integer.MAX_VALUE);
                negLeftsBuilder.appendInt(Integer.MAX_VALUE);
                negRightsBuilder.appendInt(Integer.MIN_VALUE);
                posLeftsBuilder.appendInt(Integer.MAX_VALUE);
                posRightsBuilder.appendInt(Integer.MIN_VALUE);
            }
            blocks[offset + 0] = topsBuilder.build();
            blocks[offset + 1] = bottomsBuilder.build();
            blocks[offset + 2] = negLeftsBuilder.build();
            blocks[offset + 3] = negRightsBuilder.build();
            blocks[offset + 4] = posLeftsBuilder.build();
            blocks[offset + 5] = posRightsBuilder.build();
        }
    }

    public void add(int groupId, Geometry geo) {
        this.ensureCapacity(groupId);
        this.geoPointVisitor.reset();
        if (((Boolean)geo.visit((GeometryVisitor)new SpatialEnvelopeVisitor((SpatialEnvelopeVisitor.PointVisitor)this.geoPointVisitor))).booleanValue()) {
            this.add(groupId, POINT_TYPE.encoder().encodeY(this.geoPointVisitor.getTop()), POINT_TYPE.encoder().encodeY(this.geoPointVisitor.getBottom()), SpatialAggregationUtils.encodeLongitude(this.geoPointVisitor.getNegLeft()), SpatialAggregationUtils.encodeLongitude(this.geoPointVisitor.getNegRight()), SpatialAggregationUtils.encodeLongitude(this.geoPointVisitor.getPosLeft()), SpatialAggregationUtils.encodeLongitude(this.geoPointVisitor.getPosRight()));
        }
    }

    public void add(int groupId, long encoded) {
        int x = POINT_TYPE.extractX(encoded);
        int y = POINT_TYPE.extractY(encoded);
        this.add(groupId, y, y, x, x, x, x);
    }

    public void add(int groupId, int p, IntBlock values) {
        if (values.getValueCount(p) != 6) {
            throw new IllegalArgumentException("Expected 6 values, got " + values.getValueCount(p));
        }
        int i = values.getFirstValueIndex(p);
        int top = values.getInt(i++);
        int bottom = values.getInt(i++);
        int negLeft = values.getInt(i++);
        int negRight = values.getInt(i++);
        int posLeft = values.getInt(i++);
        int posRight = values.getInt(i);
        this.add(groupId, top, bottom, negLeft, negRight, posLeft, posRight);
    }

    public void add(int groupId, int top, int bottom, int negLeft, int negRight, int posLeft, int posRight) {
        this.ensureCapacity(groupId);
        if (this.hasValue(groupId)) {
            this.tops.set((long)groupId, Math.max(this.tops.get((long)groupId), top));
            this.bottoms.set((long)groupId, Math.min(this.bottoms.get((long)groupId), bottom));
            this.negLefts.set((long)groupId, Math.min(this.negLefts.get((long)groupId), negLeft));
            this.negRights.set((long)groupId, SpatialAggregationUtils.maxNeg(this.negRights.get((long)groupId), negRight));
            this.posLefts.set((long)groupId, SpatialAggregationUtils.minPos(this.posLefts.get((long)groupId), posLeft));
            this.posRights.set((long)groupId, Math.max(this.posRights.get((long)groupId), posRight));
        } else {
            this.tops.set((long)groupId, top);
            this.bottoms.set((long)groupId, bottom);
            this.negLefts.set((long)groupId, negLeft);
            this.negRights.set((long)groupId, negRight);
            this.posLefts.set((long)groupId, posLeft);
            this.posRights.set((long)groupId, posRight);
        }
        this.trackGroupId(groupId);
    }

    private void ensureCapacity(int groupId) {
        long requiredSize = groupId + 1;
        if (this.negLefts.size() < requiredSize) {
            this.tops = this.bigArrays.grow(this.tops, requiredSize);
            this.bottoms = this.bigArrays.grow(this.bottoms, requiredSize);
            this.negLefts = this.bigArrays.grow(this.negLefts, requiredSize);
            this.negRights = this.bigArrays.grow(this.negRights, requiredSize);
            this.posLefts = this.bigArrays.grow(this.posLefts, requiredSize);
            this.posRights = this.bigArrays.grow(this.posRights, requiredSize);
        }
    }

    public Block toBlock(IntVector selected, DriverContext driverContext) {
        try (BytesRefBlock.Builder builder = driverContext.blockFactory().newBytesRefBlockBuilder(selected.getPositionCount());){
            for (int i = 0; i < selected.getPositionCount(); ++i) {
                int si = selected.getInt(i);
                if (this.hasValue(si)) {
                    builder.appendBytesRef(new BytesRef(WellKnownBinary.toWKB((Geometry)SpatialExtentStateWrappedLongitudeState.asRectangle(this.tops.get((long)si), this.bottoms.get((long)si), this.negLefts.get((long)si), this.negRights.get((long)si), this.posLefts.get((long)si), this.posRights.get((long)si)), (ByteOrder)ByteOrder.LITTLE_ENDIAN)));
                    continue;
                }
                builder.appendNull();
            }
            BytesRefBlock bytesRefBlock = builder.build();
            return bytesRefBlock;
        }
    }
}

