/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.DoubleArrayState;
import org.elasticsearch.compute.aggregation.GroupingAggregatorEvaluationContext;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.MaxDoubleAggregator;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntArrayBlock;
import org.elasticsearch.compute.data.IntBigArrayBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public final class MaxDoubleGroupingAggregatorFunction
implements GroupingAggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("max", ElementType.DOUBLE), new IntermediateStateDesc("seen", ElementType.BOOLEAN));
    private final DoubleArrayState state;
    private final List<Integer> channels;
    private final DriverContext driverContext;

    public MaxDoubleGroupingAggregatorFunction(List<Integer> channels, DoubleArrayState state, DriverContext driverContext) {
        this.channels = channels;
        this.state = state;
        this.driverContext = driverContext;
    }

    public static MaxDoubleGroupingAggregatorFunction create(List<Integer> channels, DriverContext driverContext) {
        return new MaxDoubleGroupingAggregatorFunction(channels, new DoubleArrayState(driverContext.bigArrays(), MaxDoubleAggregator.init()), driverContext);
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public GroupingAggregatorFunction.AddInput prepareProcessRawInputPage(SeenGroupIds seenGroupIds, Page page) {
        final DoubleBlock vBlock = (DoubleBlock)page.getBlock(this.channels.get(0));
        final DoubleVector vVector = vBlock.asVector();
        if (vVector == null) {
            this.maybeEnableGroupIdTracking(seenGroupIds, vBlock);
            return new GroupingAggregatorFunction.AddInput(){

                @Override
                public void add(int positionOffset, IntArrayBlock groupIds) {
                    MaxDoubleGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, vBlock);
                }

                @Override
                public void add(int positionOffset, IntBigArrayBlock groupIds) {
                    MaxDoubleGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, vBlock);
                }

                @Override
                public void add(int positionOffset, IntVector groupIds) {
                    MaxDoubleGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, vBlock);
                }

                public void close() {
                }
            };
        }
        return new GroupingAggregatorFunction.AddInput(){

            @Override
            public void add(int positionOffset, IntArrayBlock groupIds) {
                MaxDoubleGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, vVector);
            }

            @Override
            public void add(int positionOffset, IntBigArrayBlock groupIds) {
                MaxDoubleGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, vVector);
            }

            @Override
            public void add(int positionOffset, IntVector groupIds) {
                MaxDoubleGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, vVector);
            }

            public void close() {
            }
        };
    }

    private void addRawInput(int positionOffset, IntArrayBlock groups, DoubleBlock vBlock) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int valuesPosition;
            if (groups.isNull(groupPosition) || vBlock.isNull(valuesPosition = groupPosition + positionOffset)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int vStart = vBlock.getFirstValueIndex(valuesPosition);
                int vEnd = vStart + vBlock.getValueCount(valuesPosition);
                for (int vOffset = vStart; vOffset < vEnd; ++vOffset) {
                    double vValue = vBlock.getDouble(vOffset);
                    this.state.set(groupId, MaxDoubleAggregator.combine(this.state.getOrDefault(groupId), vValue));
                }
            }
        }
    }

    private void addRawInput(int positionOffset, IntArrayBlock groups, DoubleVector vVector) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int valuesPosition = groupPosition + positionOffset;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                double vValue = vVector.getDouble(valuesPosition);
                this.state.set(groupId, MaxDoubleAggregator.combine(this.state.getOrDefault(groupId), vValue));
            }
        }
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntArrayBlock groups, Page page) {
        this.state.enableGroupIdTracking(new SeenGroupIds.Empty());
        assert (this.channels.size() == this.intermediateBlockCount());
        Object maxUncast = page.getBlock(this.channels.get(0));
        if (maxUncast.areAllValuesNull()) {
            return;
        }
        DoubleVector max = ((DoubleBlock)maxUncast).asVector();
        Object seenUncast = page.getBlock(this.channels.get(1));
        if (seenUncast.areAllValuesNull()) {
            return;
        }
        BooleanVector seen = ((BooleanBlock)seenUncast).asVector();
        assert (max.getPositionCount() == seen.getPositionCount());
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int valuesPosition = groupPosition + positionOffset;
                if (!seen.getBoolean(valuesPosition)) continue;
                this.state.set(groupId, MaxDoubleAggregator.combine(this.state.getOrDefault(groupId), max.getDouble(valuesPosition)));
            }
        }
    }

    private void addRawInput(int positionOffset, IntBigArrayBlock groups, DoubleBlock vBlock) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int valuesPosition;
            if (groups.isNull(groupPosition) || vBlock.isNull(valuesPosition = groupPosition + positionOffset)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int vStart = vBlock.getFirstValueIndex(valuesPosition);
                int vEnd = vStart + vBlock.getValueCount(valuesPosition);
                for (int vOffset = vStart; vOffset < vEnd; ++vOffset) {
                    double vValue = vBlock.getDouble(vOffset);
                    this.state.set(groupId, MaxDoubleAggregator.combine(this.state.getOrDefault(groupId), vValue));
                }
            }
        }
    }

    private void addRawInput(int positionOffset, IntBigArrayBlock groups, DoubleVector vVector) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int valuesPosition = groupPosition + positionOffset;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                double vValue = vVector.getDouble(valuesPosition);
                this.state.set(groupId, MaxDoubleAggregator.combine(this.state.getOrDefault(groupId), vValue));
            }
        }
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntBigArrayBlock groups, Page page) {
        this.state.enableGroupIdTracking(new SeenGroupIds.Empty());
        assert (this.channels.size() == this.intermediateBlockCount());
        Object maxUncast = page.getBlock(this.channels.get(0));
        if (maxUncast.areAllValuesNull()) {
            return;
        }
        DoubleVector max = ((DoubleBlock)maxUncast).asVector();
        Object seenUncast = page.getBlock(this.channels.get(1));
        if (seenUncast.areAllValuesNull()) {
            return;
        }
        BooleanVector seen = ((BooleanBlock)seenUncast).asVector();
        assert (max.getPositionCount() == seen.getPositionCount());
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int valuesPosition = groupPosition + positionOffset;
                if (!seen.getBoolean(valuesPosition)) continue;
                this.state.set(groupId, MaxDoubleAggregator.combine(this.state.getOrDefault(groupId), max.getDouble(valuesPosition)));
            }
        }
    }

    private void addRawInput(int positionOffset, IntVector groups, DoubleBlock vBlock) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int valuesPosition = groupPosition + positionOffset;
            if (vBlock.isNull(valuesPosition)) continue;
            int groupId = groups.getInt(groupPosition);
            int vStart = vBlock.getFirstValueIndex(valuesPosition);
            int vEnd = vStart + vBlock.getValueCount(valuesPosition);
            for (int vOffset = vStart; vOffset < vEnd; ++vOffset) {
                double vValue = vBlock.getDouble(vOffset);
                this.state.set(groupId, MaxDoubleAggregator.combine(this.state.getOrDefault(groupId), vValue));
            }
        }
    }

    private void addRawInput(int positionOffset, IntVector groups, DoubleVector vVector) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int valuesPosition = groupPosition + positionOffset;
            int groupId = groups.getInt(groupPosition);
            double vValue = vVector.getDouble(valuesPosition);
            this.state.set(groupId, MaxDoubleAggregator.combine(this.state.getOrDefault(groupId), vValue));
        }
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntVector groups, Page page) {
        this.state.enableGroupIdTracking(new SeenGroupIds.Empty());
        assert (this.channels.size() == this.intermediateBlockCount());
        Object maxUncast = page.getBlock(this.channels.get(0));
        if (maxUncast.areAllValuesNull()) {
            return;
        }
        DoubleVector max = ((DoubleBlock)maxUncast).asVector();
        Object seenUncast = page.getBlock(this.channels.get(1));
        if (seenUncast.areAllValuesNull()) {
            return;
        }
        BooleanVector seen = ((BooleanBlock)seenUncast).asVector();
        assert (max.getPositionCount() == seen.getPositionCount());
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int groupId = groups.getInt(groupPosition);
            int valuesPosition = groupPosition + positionOffset;
            if (!seen.getBoolean(valuesPosition)) continue;
            this.state.set(groupId, MaxDoubleAggregator.combine(this.state.getOrDefault(groupId), max.getDouble(valuesPosition)));
        }
    }

    private void maybeEnableGroupIdTracking(SeenGroupIds seenGroupIds, DoubleBlock vBlock) {
        if (vBlock.mayHaveNulls()) {
            this.state.enableGroupIdTracking(seenGroupIds);
        }
    }

    @Override
    public void selectedMayContainUnseenGroups(SeenGroupIds seenGroupIds) {
        this.state.enableGroupIdTracking(seenGroupIds);
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, IntVector selected) {
        this.state.toIntermediate(blocks, offset, selected, this.driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, IntVector selected, GroupingAggregatorEvaluationContext ctx) {
        blocks[offset] = this.state.toValuesBlock(selected, ctx.driverContext());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

