/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.TransportMessage;
import org.elasticsearch.transport.TransportRequest;

public abstract class AbstractTransportRequest
extends TransportMessage
implements TransportRequest {
    @Nullable
    private InetSocketAddress remoteAddress;
    private TaskId parentTaskId = TaskId.EMPTY_TASK_ID;
    private volatile long requestId = -1L;

    public AbstractTransportRequest() {
    }

    public AbstractTransportRequest(StreamInput in) throws IOException {
        this.parentTaskId = TaskId.readFromStream(in);
    }

    @Override
    public void remoteAddress(InetSocketAddress remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    @Override
    @Nullable
    public InetSocketAddress remoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public void setParentTask(TaskId taskId) {
        this.parentTaskId = taskId;
    }

    @Override
    public TaskId getParentTask() {
        return this.parentTaskId;
    }

    @Override
    public void setRequestId(long requestId) {
        this.requestId = requestId;
    }

    @Override
    public long getRequestId() {
        return this.requestId;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.parentTaskId.writeTo(out);
    }

    public String toString() {
        return this.getClass().getName() + "/" + String.valueOf(this.getParentTask());
    }
}

