/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.index.fieldvisitor.LeafStoredFieldLoader;
import org.elasticsearch.index.fieldvisitor.StoredFieldLoader;
import org.elasticsearch.search.fetch.FetchPhase;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.fetch.FetchSubPhaseProcessor;
import org.elasticsearch.search.fetch.StoredFieldsSpec;
import org.elasticsearch.search.profile.AbstractProfileBreakdown;
import org.elasticsearch.search.profile.ProfileResult;
import org.elasticsearch.search.profile.Timer;

public class FetchProfiler
implements FetchPhase.Profiler {
    private final FetchProfileBreakdown current;

    public FetchProfiler() {
        this(System.nanoTime());
    }

    public FetchProfiler(long nanoTime) {
        this.current = new FetchProfileBreakdown(nanoTime);
    }

    @Override
    public ProfileResult finish() {
        return this.finish(System.nanoTime());
    }

    public ProfileResult finish(long nanoTime) {
        return this.current.result(nanoTime);
    }

    @Override
    public StoredFieldLoader storedFields(final StoredFieldLoader storedFieldLoader) {
        this.current.debug.put("stored_fields", storedFieldLoader.fieldsToLoad());
        return new StoredFieldLoader(){

            @Override
            public LeafStoredFieldLoader getLoader(LeafReaderContext ctx, int[] docs) throws IOException {
                final LeafStoredFieldLoader in = storedFieldLoader.getLoader(ctx, docs);
                return new LeafStoredFieldLoader(){

                    @Override
                    public void advanceTo(int doc) throws IOException {
                        Timer timer = FetchProfiler.this.current.getNewTimer(FetchPhaseTiming.LOAD_STORED_FIELDS);
                        timer.start();
                        try {
                            in.advanceTo(doc);
                        }
                        finally {
                            timer.stop();
                        }
                    }

                    @Override
                    public BytesReference source() {
                        return in.source();
                    }

                    @Override
                    public String id() {
                        return in.id();
                    }

                    @Override
                    public String routing() {
                        return in.routing();
                    }

                    @Override
                    public Map<String, List<Object>> storedFields() {
                        return in.storedFields();
                    }
                };
            }

            @Override
            public List<String> fieldsToLoad() {
                return storedFieldLoader.fieldsToLoad();
            }
        };
    }

    @Override
    public FetchSubPhaseProcessor profile(String type, String description, final FetchSubPhaseProcessor delegate) {
        final FetchSubPhaseProfileBreakdown breakdown = new FetchSubPhaseProfileBreakdown(type, description, delegate);
        this.current.subPhases.add(breakdown);
        return new FetchSubPhaseProcessor(){

            @Override
            public void setNextReader(LeafReaderContext readerContext) throws IOException {
                Timer timer = breakdown.getNewTimer(FetchSubPhaseTiming.NEXT_READER);
                timer.start();
                try {
                    delegate.setNextReader(readerContext);
                }
                finally {
                    timer.stop();
                }
            }

            @Override
            public StoredFieldsSpec storedFieldsSpec() {
                return delegate.storedFieldsSpec();
            }

            @Override
            public void process(FetchSubPhase.HitContext hitContext) throws IOException {
                Timer timer = breakdown.getNewTimer(FetchSubPhaseTiming.PROCESS);
                timer.start();
                try {
                    delegate.process(hitContext);
                }
                finally {
                    timer.stop();
                }
            }
        };
    }

    @Override
    public Timer startLoadingSource() {
        Timer timer = this.current.getNewTimer(FetchPhaseTiming.LOAD_SOURCE);
        timer.start();
        return timer;
    }

    @Override
    public Timer startNextReader() {
        Timer timer = this.current.getNewTimer(FetchPhaseTiming.NEXT_READER);
        timer.start();
        return timer;
    }

    static class FetchProfileBreakdown
    extends AbstractProfileBreakdown<FetchPhaseTiming> {
        private final long start;
        private final Map<String, Object> debug = new HashMap<String, Object>();
        private final List<FetchSubPhaseProfileBreakdown> subPhases = new ArrayList<FetchSubPhaseProfileBreakdown>();

        FetchProfileBreakdown(long start) {
            super(FetchPhaseTiming.class);
            this.start = start;
        }

        @Override
        protected Map<String, Object> toDebugMap() {
            return Map.copyOf(this.debug);
        }

        ProfileResult result(long stop) {
            List<ProfileResult> children = this.subPhases.stream().sorted(Comparator.comparing(b -> b.type)).map(FetchSubPhaseProfileBreakdown::result).collect(Collectors.toList());
            return new ProfileResult("fetch", "", this.toBreakdownMap(), this.toDebugMap(), stop - this.start, children);
        }
    }

    static class FetchSubPhaseProfileBreakdown
    extends AbstractProfileBreakdown<FetchSubPhaseTiming> {
        private final String type;
        private final String description;
        private final FetchSubPhaseProcessor processor;

        FetchSubPhaseProfileBreakdown(String type, String description, FetchSubPhaseProcessor processor) {
            super(FetchSubPhaseTiming.class);
            this.type = type;
            this.description = description;
            this.processor = processor;
        }

        @Override
        protected Map<String, Object> toDebugMap() {
            return this.processor.getDebugInfo();
        }

        ProfileResult result() {
            return new ProfileResult(this.type, this.description, this.toBreakdownMap(), this.toDebugMap(), this.toNodeTime(), List.of());
        }
    }

    static enum FetchPhaseTiming {
        NEXT_READER,
        LOAD_STORED_FIELDS,
        LOAD_SOURCE;


        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    static enum FetchSubPhaseTiming {
        NEXT_READER,
        PROCESS;


        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

