/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.lucene.search.Explanation;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.RefCounted;
import org.elasticsearch.core.SimpleRefCounted;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.SearchSortValues;
import org.elasticsearch.search.fetch.subphase.LookupField;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.elasticsearch.search.lookup.Source;
import org.elasticsearch.transport.LeakTracker;
import org.elasticsearch.transport.RemoteClusterAware;
import org.elasticsearch.xcontent.Text;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public final class SearchHit
implements Writeable,
ToXContentObject,
RefCounted {
    private static final TransportVersion DOC_FIELDS_AS_LIST = TransportVersion.fromName("doc_fields_as_list");
    private final transient int docId;
    static final float DEFAULT_SCORE = Float.NaN;
    private float score;
    static final int NO_RANK = -1;
    private int rank;
    private final Text id;
    private final NestedIdentity nestedIdentity;
    private long version;
    private long seqNo;
    private long primaryTerm;
    private BytesReference source;
    private final Map<String, DocumentField> documentFields;
    private final Map<String, DocumentField> metaFields;
    private Map<String, HighlightField> highlightFields;
    private SearchSortValues sortValues;
    private Map<String, Float> matchedQueries;
    private Explanation explanation;
    @Nullable
    private SearchShardTarget shard;
    private transient String index;
    private transient String clusterAlias;
    private boolean sourceAsMapCalled = false;
    private Map<String, SearchHits> innerHits;
    private final RefCounted refCounted;
    private static final Text SINGLE_MAPPING_TYPE = new Text("_doc");
    static final String DOCUMENT_FIELDS = "document_fields";
    static final String METADATA_FIELDS = "metadata_fields";

    public SearchHit(int docId) {
        this(docId, null);
    }

    public SearchHit(int docId, String id) {
        this(docId, id, null);
    }

    public SearchHit(int nestedTopDocId, String id, NestedIdentity nestedIdentity) {
        this(nestedTopDocId, id, nestedIdentity, null);
    }

    private SearchHit(int nestedTopDocId, String id, NestedIdentity nestedIdentity, @Nullable RefCounted refCounted) {
        this(nestedTopDocId, Float.NaN, -1, id == null ? null : new Text(id), nestedIdentity, -1L, -2L, 0L, null, null, SearchSortValues.EMPTY, Collections.emptyMap(), null, null, null, null, null, new HashMap<String, DocumentField>(), new HashMap<String, DocumentField>(), refCounted);
    }

    public SearchHit(int docId, float score, int rank, Text id, NestedIdentity nestedIdentity, long version, long seqNo, long primaryTerm, BytesReference source, Map<String, HighlightField> highlightFields, SearchSortValues sortValues, Map<String, Float> matchedQueries, Explanation explanation, SearchShardTarget shard, String index, String clusterAlias, Map<String, SearchHits> innerHits, Map<String, DocumentField> documentFields, Map<String, DocumentField> metaFields, @Nullable RefCounted refCounted) {
        this.docId = docId;
        this.score = score;
        this.rank = rank;
        this.id = id;
        this.nestedIdentity = nestedIdentity;
        this.version = version;
        this.seqNo = seqNo;
        this.primaryTerm = primaryTerm;
        this.source = source;
        this.highlightFields = highlightFields;
        this.sortValues = sortValues;
        this.matchedQueries = matchedQueries;
        this.explanation = explanation;
        this.shard = shard;
        this.index = index;
        this.clusterAlias = clusterAlias;
        this.innerHits = innerHits;
        this.documentFields = documentFields;
        this.metaFields = metaFields;
        this.refCounted = refCounted == null ? LeakTracker.wrap((RefCounted)new SimpleRefCounted()) : refCounted;
    }

    public static SearchHit readFrom(StreamInput in, boolean pooled) throws IOException {
        Map<String, SearchHits> innerHits;
        String clusterAlias;
        String index;
        Map<String, Float> matchedQueries;
        Map<String, DocumentField> metaFields;
        Map<String, DocumentField> documentFields;
        BytesReference source;
        float score = in.readFloat();
        int rank = in.getTransportVersion().onOrAfter(TransportVersions.V_8_8_0) ? in.readVInt() : -1;
        Text id = in.readOptionalText();
        if (in.getTransportVersion().before(TransportVersions.V_8_0_0)) {
            in.readOptionalText();
        }
        NestedIdentity nestedIdentity = in.readOptionalWriteable(NestedIdentity::new);
        long version = in.readLong();
        long seqNo = in.readZLong();
        long primaryTerm = in.readVLong();
        BytesReference bytesReference = source = pooled ? in.readReleasableBytesReference() : in.readBytesReference();
        if (source.length() == 0) {
            source = null;
        }
        Explanation explanation = null;
        if (in.readBoolean()) {
            explanation = Lucene.readExplanation(in);
        }
        if (in.getTransportVersion().supports(DOC_FIELDS_AS_LIST)) {
            documentFields = DocumentField.readFieldsFromMapValues(in);
            metaFields = DocumentField.readFieldsFromMapValues(in);
        } else {
            documentFields = in.readMap(DocumentField::new);
            metaFields = in.readMap(DocumentField::new);
        }
        Map<String, HighlightField> highlightFields = in.readMapValues(HighlightField::new, HighlightField::name);
        highlightFields = highlightFields.isEmpty() ? null : Collections.unmodifiableMap(highlightFields);
        SearchSortValues sortValues = SearchSortValues.readFrom(in);
        if (in.getTransportVersion().onOrAfter(TransportVersions.V_8_8_0)) {
            matchedQueries = in.readOrderedMap(StreamInput::readString, StreamInput::readFloat);
        } else {
            int size = in.readVInt();
            matchedQueries = Maps.newLinkedHashMapWithExpectedSize(size);
            for (int i = 0; i < size; ++i) {
                matchedQueries.put(in.readString(), Float.valueOf(Float.NaN));
            }
        }
        SearchShardTarget shardTarget = in.readOptionalWriteable(SearchShardTarget::new);
        if (shardTarget == null) {
            index = null;
            clusterAlias = null;
        } else {
            index = shardTarget.getIndex();
            clusterAlias = shardTarget.getClusterAlias();
        }
        boolean isPooled = pooled && source != null;
        int size = in.readVInt();
        if (size > 0) {
            innerHits = Maps.newMapWithExpectedSize(size);
            for (int i = 0; i < size; ++i) {
                String key = in.readString();
                SearchHits nestedHits = SearchHits.readFrom(in, pooled);
                innerHits.put(key, nestedHits);
                isPooled = isPooled || nestedHits.isPooled();
            }
        } else {
            innerHits = null;
        }
        return new SearchHit(-1, score, rank, id, nestedIdentity, version, seqNo, primaryTerm, source, highlightFields, sortValues, matchedQueries, explanation, shardTarget, index, clusterAlias, innerHits, documentFields, metaFields, isPooled ? null : ALWAYS_REFERENCED);
    }

    public static SearchHit unpooled(int docId) {
        return SearchHit.unpooled(docId, null);
    }

    public static SearchHit unpooled(int docId, String id) {
        return SearchHit.unpooled(docId, id, null);
    }

    public static SearchHit unpooled(int nestedTopDocId, String id, NestedIdentity nestedIdentity) {
        return new SearchHit(nestedTopDocId, id, nestedIdentity, ALWAYS_REFERENCED);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        assert (this.hasReferences());
        out.writeFloat(this.score);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_8_0)) {
            out.writeVInt(this.rank);
        } else if (this.rank != -1) {
            throw new IllegalArgumentException("cannot serialize [rank] to version [" + out.getTransportVersion().toReleaseVersion() + "]");
        }
        out.writeOptionalText(this.id);
        if (out.getTransportVersion().before(TransportVersions.V_8_0_0)) {
            out.writeOptionalText(SINGLE_MAPPING_TYPE);
        }
        out.writeOptionalWriteable(this.nestedIdentity);
        out.writeLong(this.version);
        out.writeZLong(this.seqNo);
        out.writeVLong(this.primaryTerm);
        out.writeBytesReference(this.source);
        if (this.explanation == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            Lucene.writeExplanation(out, this.explanation);
        }
        if (out.getTransportVersion().supports(DOC_FIELDS_AS_LIST)) {
            out.writeMapValues(this.documentFields);
            out.writeMapValues(this.metaFields);
        } else {
            out.writeMap(this.documentFields, StreamOutput::writeWriteable);
            out.writeMap(this.metaFields, StreamOutput::writeWriteable);
        }
        if (this.highlightFields == null) {
            out.writeVInt(0);
        } else {
            out.writeCollection(this.highlightFields.values());
        }
        this.sortValues.writeTo(out);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_8_0)) {
            out.writeMap(this.matchedQueries, StreamOutput::writeFloat);
        } else {
            out.writeStringCollection(this.matchedQueries.keySet());
        }
        out.writeOptionalWriteable(this.shard);
        if (this.innerHits == null) {
            out.writeVInt(0);
        } else {
            out.writeMap(this.innerHits, StreamOutput::writeWriteable);
        }
    }

    public int docId() {
        return this.docId;
    }

    public void score(float score) {
        this.score = score;
    }

    public float getScore() {
        return this.score;
    }

    public void setRank(int rank) {
        this.rank = rank;
    }

    public int getRank() {
        return this.rank;
    }

    public void version(long version) {
        this.version = version;
    }

    public long getVersion() {
        return this.version;
    }

    public void setSeqNo(long seqNo) {
        this.seqNo = seqNo;
    }

    public void setPrimaryTerm(long primaryTerm) {
        this.primaryTerm = primaryTerm;
    }

    public long getSeqNo() {
        return this.seqNo;
    }

    public long getPrimaryTerm() {
        return this.primaryTerm;
    }

    public String getIndex() {
        return this.index;
    }

    public String getId() {
        return this.id != null ? this.id.string() : null;
    }

    public NestedIdentity getNestedIdentity() {
        return this.nestedIdentity;
    }

    public BytesReference getSourceRef() {
        assert (this.hasReferences());
        if (this.source == null) {
            return null;
        }
        try {
            this.source = CompressorFactory.uncompressIfNeeded(this.source);
            return this.source;
        }
        catch (IOException e) {
            throw new ElasticsearchParseException("failed to decompress source", (Throwable)e, new Object[0]);
        }
    }

    public SearchHit sourceRef(BytesReference source) {
        this.source = source;
        return this;
    }

    public boolean hasSource() {
        assert (this.hasReferences());
        return this.source != null;
    }

    public String getSourceAsString() {
        assert (this.hasReferences());
        if (this.source == null) {
            return null;
        }
        try {
            return XContentHelper.convertToJson(this.getSourceRef(), false);
        }
        catch (IOException e) {
            throw new ElasticsearchParseException("failed to convert source to a json string", new Object[0]);
        }
    }

    public Map<String, Object> getSourceAsMap() {
        assert (this.hasReferences());
        assert (!this.sourceAsMapCalled) : "getSourceAsMap() called twice";
        this.sourceAsMapCalled = true;
        if (this.source == null) {
            return null;
        }
        return Source.fromBytes(this.source).source();
    }

    public DocumentField field(String fieldName) {
        assert (this.hasReferences());
        DocumentField result = this.documentFields.get(fieldName);
        if (result != null) {
            return result;
        }
        return this.metaFields.get(fieldName);
    }

    public void setDocumentField(DocumentField field) {
        if (field == null) {
            return;
        }
        this.documentFields.put(field.getName(), field);
    }

    public void addDocumentFields(Map<String, DocumentField> docFields, Map<String, DocumentField> metaFields) {
        this.documentFields.putAll(docFields);
        this.metaFields.putAll(metaFields);
    }

    public DocumentField removeDocumentField(String field) {
        return this.documentFields.remove(field);
    }

    public Map<String, DocumentField> getMetadataFields() {
        assert (this.hasReferences());
        return Collections.unmodifiableMap(this.metaFields);
    }

    public Map<String, DocumentField> getDocumentFields() {
        assert (this.hasReferences());
        return Collections.unmodifiableMap(this.documentFields);
    }

    public Map<String, DocumentField> getFields() {
        assert (this.hasReferences());
        if (this.metaFields.size() > 0 || this.documentFields.size() > 0) {
            HashMap<String, DocumentField> fields = new HashMap<String, DocumentField>();
            fields.putAll(this.metaFields);
            fields.putAll(this.documentFields);
            return fields;
        }
        return Collections.emptyMap();
    }

    public boolean hasLookupFields() {
        return this.getDocumentFields().values().stream().anyMatch(doc -> !doc.getLookupFields().isEmpty());
    }

    public void resolveLookupFields(Map<LookupField, List<Object>> lookupResults) {
        assert (this.hasReferences());
        if (lookupResults.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<String, DocumentField>> iterator = this.documentFields.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, DocumentField> entry = iterator.next();
            DocumentField docField = entry.getValue();
            if (docField.getLookupFields().isEmpty()) continue;
            ArrayList<Object> newValues = new ArrayList<Object>(docField.getValues());
            for (LookupField lookupField : docField.getLookupFields()) {
                List<Object> resolvedValues = lookupResults.get(lookupField);
                if (resolvedValues == null) continue;
                newValues.addAll(resolvedValues);
            }
            if (newValues.isEmpty() && docField.getIgnoredValues().isEmpty()) {
                iterator.remove();
                continue;
            }
            entry.setValue(new DocumentField(docField.getName(), newValues, docField.getIgnoredValues()));
        }
        assert (!this.hasLookupFields()) : "Some lookup fields are not resolved";
    }

    public Map<String, HighlightField> getHighlightFields() {
        assert (this.hasReferences());
        return this.highlightFields == null ? Collections.emptyMap() : this.highlightFields;
    }

    public void highlightFields(Map<String, HighlightField> highlightFields) {
        this.highlightFields = highlightFields;
    }

    public void sortValues(Object[] sortValues, DocValueFormat[] sortValueFormats) {
        this.sortValues(new SearchSortValues(sortValues, sortValueFormats));
    }

    public void sortValues(SearchSortValues sortValues) {
        this.sortValues = sortValues;
    }

    public Object[] getSortValues() {
        return this.sortValues.getFormattedSortValues();
    }

    public Object[] getRawSortValues() {
        return this.sortValues.getRawSortValues();
    }

    public Explanation getExplanation() {
        return this.explanation;
    }

    public void explanation(Explanation explanation) {
        this.explanation = explanation;
    }

    public SearchShardTarget getShard() {
        return this.shard;
    }

    public void shard(SearchShardTarget target) {
        if (this.innerHits != null) {
            for (SearchHits innerHits : this.innerHits.values()) {
                for (SearchHit innerHit : innerHits) {
                    innerHit.shard(target);
                }
            }
        }
        this.shard = target;
        if (target != null) {
            this.index = target.getIndex();
            this.clusterAlias = target.getClusterAlias();
        }
    }

    public String getClusterAlias() {
        return this.clusterAlias;
    }

    public void matchedQueries(Map<String, Float> matchedQueries) {
        this.matchedQueries = matchedQueries;
    }

    public String[] getMatchedQueries() {
        return this.matchedQueries == null ? new String[]{} : this.matchedQueries.keySet().toArray(new String[0]);
    }

    public Float getMatchedQueryScore(String name) {
        return this.getMatchedQueriesAndScores().get(name);
    }

    public Map<String, Float> getMatchedQueriesAndScores() {
        return this.matchedQueries == null ? Collections.emptyMap() : this.matchedQueries;
    }

    public Map<String, SearchHits> getInnerHits() {
        assert (this.hasReferences());
        return this.innerHits;
    }

    public void setInnerHits(Map<String, SearchHits> innerHits) {
        assert (innerHits == null || innerHits.values().stream().noneMatch(h -> !h.hasReferences()));
        assert (this.innerHits == null);
        this.innerHits = innerHits;
    }

    public void incRef() {
        this.refCounted.incRef();
    }

    public boolean tryIncRef() {
        return this.refCounted.tryIncRef();
    }

    public boolean decRef() {
        if (this.refCounted.decRef()) {
            this.deallocate();
            return true;
        }
        return false;
    }

    private void deallocate() {
        BytesReference bytesReference;
        if (this.innerHits != null) {
            for (SearchHits h : this.innerHits.values()) {
                h.decRef();
            }
            this.innerHits = null;
        }
        if ((bytesReference = this.source) instanceof RefCounted) {
            RefCounted r = (RefCounted)bytesReference;
            r.decRef();
        }
        this.source = null;
        SearchHit.clearIfMutable(this.documentFields);
        SearchHit.clearIfMutable(this.metaFields);
        this.highlightFields = null;
    }

    private static void clearIfMutable(Map<String, DocumentField> fields) {
        assert (fields instanceof HashMap || fields.isEmpty()) : fields;
        if (fields instanceof HashMap) {
            HashMap hm = (HashMap)fields;
            hm.clear();
        }
    }

    public boolean hasReferences() {
        return this.refCounted.hasReferences();
    }

    public SearchHit asUnpooled() {
        assert (this.hasReferences());
        if (!this.isPooled()) {
            return this;
        }
        return new SearchHit(this.docId, this.score, this.rank, this.id, this.nestedIdentity, this.version, this.seqNo, this.primaryTerm, this.source instanceof RefCounted ? new BytesArray(this.source.toBytesRef(), true) : this.source, this.highlightFields, this.sortValues, this.matchedQueries, this.explanation, this.shard, this.index, this.clusterAlias, this.innerHits == null ? null : this.innerHits.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((SearchHits)e.getValue()).asUnpooled())), this.cloneIfHashMap(this.documentFields), this.cloneIfHashMap(this.metaFields), ALWAYS_REFERENCED);
    }

    private Map<String, DocumentField> cloneIfHashMap(Map<String, DocumentField> map) {
        HashMap hashMap;
        if (map instanceof HashMap) {
            HashMap hashMap2 = map;
            hashMap = new HashMap(hashMap2);
        } else {
            hashMap = map;
        }
        return hashMap;
    }

    public boolean isPooled() {
        return this.refCounted != ALWAYS_REFERENCED;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        assert (this.hasReferences());
        builder.startObject();
        this.toInnerXContent(builder, params);
        builder.endObject();
        return builder;
    }

    public XContentBuilder toInnerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.getExplanation() != null && this.shard != null) {
            builder.field("_shard", (ToXContent)this.shard.getShardId());
            builder.field("_node", (ToXContent)this.shard.getNodeIdText());
        }
        if (this.index != null) {
            builder.field("_index", RemoteClusterAware.buildRemoteIndexName(this.clusterAlias, this.index));
        }
        if (this.id != null) {
            builder.field("_id", (ToXContent)this.id);
        }
        if (this.nestedIdentity != null) {
            this.nestedIdentity.toXContent(builder, params);
        }
        if (this.version != -1L) {
            builder.field("_version", this.version);
        }
        if (this.seqNo != -2L) {
            builder.field("_seq_no", this.seqNo);
            builder.field("_primary_term", this.primaryTerm);
        }
        if (Float.isNaN(this.score)) {
            builder.nullField("_score");
        } else {
            builder.field("_score", this.score);
        }
        if (this.rank != -1) {
            builder.field("_rank", this.rank);
        }
        for (DocumentField documentField : this.metaFields.values()) {
            if (documentField.getValues().size() == 0) continue;
            if ("_ignored".equals(documentField.getName()) || documentField.getName().equals("_ignored_source")) {
                builder.field(documentField.getName(), documentField.getValues());
                continue;
            }
            builder.field(documentField.getName(), documentField.getValue());
        }
        if (this.source != null) {
            XContentHelper.writeRawField("_source", this.source, builder, params);
        }
        if (!this.documentFields.isEmpty() && this.documentFields.values().stream().anyMatch(df -> df.getValues().size() > 0)) {
            builder.startObject("fields");
            for (DocumentField documentField : this.documentFields.values()) {
                if (documentField.getValues().size() <= 0) continue;
                documentField.getValidValuesWriter().toXContent(builder, params);
            }
            builder.endObject();
        }
        if (!this.documentFields.isEmpty() && this.documentFields.values().stream().anyMatch(df -> df.getIgnoredValues().size() > 0)) {
            builder.startObject("ignored_field_values");
            for (DocumentField documentField : this.documentFields.values()) {
                if (documentField.getIgnoredValues().size() <= 0) continue;
                documentField.getIgnoredValuesWriter().toXContent(builder, params);
            }
            builder.endObject();
        }
        if (this.highlightFields != null && !this.highlightFields.isEmpty()) {
            builder.startObject("highlight");
            for (HighlightField highlightField : this.highlightFields.values()) {
                highlightField.toXContent(builder, params);
            }
            builder.endObject();
        }
        this.sortValues.toXContent(builder, params);
        if (this.matchedQueries != null && this.matchedQueries.size() > 0) {
            boolean includeMatchedQueriesScore = params.paramAsBoolean("include_named_queries_score", false);
            if (includeMatchedQueriesScore) {
                builder.startObject("matched_queries");
                for (Map.Entry<String, Float> entry : this.matchedQueries.entrySet()) {
                    builder.field(entry.getKey(), entry.getValue());
                }
                builder.endObject();
            } else {
                builder.startArray("matched_queries");
                for (String string : this.matchedQueries.keySet()) {
                    builder.value(string);
                }
                builder.endArray();
            }
        }
        if (this.getExplanation() != null) {
            builder.field("_explanation");
            SearchHit.buildExplanation(builder, this.getExplanation());
        }
        if (this.innerHits != null) {
            builder.startObject("inner_hits");
            for (Map.Entry<String, SearchHits> entry : this.innerHits.entrySet()) {
                builder.startObject(entry.getKey());
                ChunkedToXContent.wrapAsToXContent(entry.getValue()).toXContent(builder, params);
                builder.endObject();
            }
            builder.endObject();
        }
        return builder;
    }

    private static void buildExplanation(XContentBuilder builder, Explanation explanation) throws IOException {
        builder.startObject();
        builder.field("value", explanation.getValue());
        builder.field("description", explanation.getDescription());
        Explanation[] innerExps = explanation.getDetails();
        if (innerExps != null) {
            builder.startArray("details");
            for (Explanation exp : innerExps) {
                SearchHit.buildExplanation(builder, exp);
            }
            builder.endArray();
        }
        builder.endObject();
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SearchHit other = (SearchHit)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.nestedIdentity, other.nestedIdentity) && Objects.equals(this.version, other.version) && Objects.equals(this.seqNo, other.seqNo) && Objects.equals(this.primaryTerm, other.primaryTerm) && Objects.equals(this.source, other.source) && Objects.equals(this.documentFields, other.documentFields) && Objects.equals(this.metaFields, other.metaFields) && Objects.equals(this.getHighlightFields(), other.getHighlightFields()) && Objects.equals(this.getMatchedQueriesAndScores(), other.getMatchedQueriesAndScores()) && Objects.equals(this.explanation, other.explanation) && Objects.equals(this.shard, other.shard) && Objects.equals(this.innerHits, other.innerHits) && Objects.equals(this.index, other.index) && Objects.equals(this.clusterAlias, other.clusterAlias);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.nestedIdentity, this.version, this.seqNo, this.primaryTerm, this.source, this.documentFields, this.metaFields, this.getHighlightFields(), this.getMatchedQueriesAndScores(), this.explanation, this.shard, this.innerHits, this.index, this.clusterAlias);
    }

    public String toString() {
        return Strings.toString((ToXContent)this, true, true);
    }

    public static final class NestedIdentity
    implements Writeable,
    ToXContentFragment {
        static final String _NESTED = "_nested";
        static final String FIELD = "field";
        static final String OFFSET = "offset";
        private final Text field;
        private final int offset;
        private final NestedIdentity child;

        public NestedIdentity(String field, int offset, NestedIdentity child) {
            this.field = new Text(field);
            this.offset = offset;
            this.child = child;
        }

        NestedIdentity(StreamInput in) throws IOException {
            this.field = in.readOptionalText();
            this.offset = in.readInt();
            this.child = in.readOptionalWriteable(NestedIdentity::new);
        }

        public Text getField() {
            return this.field;
        }

        public int getOffset() {
            return this.offset;
        }

        public NestedIdentity getChild() {
            return this.child;
        }

        public Source extractSource(Source root) {
            HashMap<String, Object> nestedSourceAsMap;
            Map<String, Object> rootSourceAsMap = root.source();
            HashMap<String, Object> current = nestedSourceAsMap = new HashMap<String, Object>();
            for (NestedIdentity nested = this; nested != null; nested = nested.getChild()) {
                String nestedPath = nested.getField().string();
                current.put(nestedPath, new HashMap());
                List<Map<?, ?>> nestedParsedSource = XContentMapValues.extractNestedSources(nestedPath, rootSourceAsMap);
                if (nestedParsedSource == null) {
                    return Source.empty(root.sourceContentType());
                }
                if (nested.getOffset() > nestedParsedSource.size() - 1) {
                    throw new IllegalStateException("Error retrieving path " + String.valueOf(this.field));
                }
                rootSourceAsMap = nestedParsedSource.get(nested.getOffset());
                if (nested.getChild() == null) {
                    current.put(nestedPath, rootSourceAsMap);
                    continue;
                }
                HashMap next = new HashMap();
                current.put(nestedPath, next);
                current = next;
            }
            return Source.fromMap(nestedSourceAsMap, root.sourceContentType());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalText(this.field);
            out.writeInt(this.offset);
            out.writeOptionalWriteable(this.child);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(_NESTED);
            return this.innerToXContent(builder, params);
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }

        XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.field != null) {
                builder.field(FIELD, (ToXContent)this.field);
            }
            if (this.offset != -1) {
                builder.field(OFFSET, this.offset);
            }
            if (this.child != null) {
                builder = this.child.toXContent(builder, params);
            }
            builder.endObject();
            return builder;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            NestedIdentity other = (NestedIdentity)obj;
            return Objects.equals(this.field, other.field) && Objects.equals(this.offset, other.offset) && Objects.equals(this.child, other.child);
        }

        public int hashCode() {
            return Objects.hash(this.field, this.offset, this.child);
        }
    }

    public static class Fields {
        static final String _INDEX = "_index";
        static final String _ID = "_id";
        static final String _VERSION = "_version";
        static final String _SEQ_NO = "_seq_no";
        static final String _PRIMARY_TERM = "_primary_term";
        static final String _SCORE = "_score";
        static final String _RANK = "_rank";
        static final String FIELDS = "fields";
        static final String IGNORED_FIELD_VALUES = "ignored_field_values";
        static final String HIGHLIGHT = "highlight";
        static final String SORT = "sort";
        static final String MATCHED_QUERIES = "matched_queries";
        static final String _EXPLANATION = "_explanation";
        static final String VALUE = "value";
        static final String DESCRIPTION = "description";
        static final String DETAILS = "details";
        static final String INNER_HITS = "inner_hits";
        static final String _SHARD = "_shard";
        static final String _NODE = "_node";
    }
}

