/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.bulk.stats;

import java.util.concurrent.TimeUnit;
import org.elasticsearch.common.ExponentiallyWeightedMovingAverage;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.metrics.MeanMetric;
import org.elasticsearch.index.bulk.stats.BulkOperationListener;
import org.elasticsearch.index.bulk.stats.BulkStats;

public class ShardBulkStats
implements BulkOperationListener {
    private final StatsHolder totalStats = new StatsHolder();
    private static final double ALPHA = 0.1;

    public BulkStats stats() {
        return this.totalStats.stats();
    }

    @Override
    public void afterBulk(long shardBulkSizeInBytes, long tookInNanos) {
        this.totalStats.totalSizeInBytes.inc(shardBulkSizeInBytes);
        this.totalStats.shardBulkMetric.inc(tookInNanos);
        this.totalStats.timeInMillis.addValue(tookInNanos);
        this.totalStats.sizeInBytes.addValue(shardBulkSizeInBytes);
    }

    static final class StatsHolder {
        final MeanMetric shardBulkMetric = new MeanMetric();
        final CounterMetric totalSizeInBytes = new CounterMetric();
        ExponentiallyWeightedMovingAverage timeInMillis = new ExponentiallyWeightedMovingAverage(0.1, 0.0);
        ExponentiallyWeightedMovingAverage sizeInBytes = new ExponentiallyWeightedMovingAverage(0.1, 0.0);

        StatsHolder() {
        }

        BulkStats stats() {
            return new BulkStats(this.shardBulkMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.shardBulkMetric.sum()), this.totalSizeInBytes.count(), TimeUnit.NANOSECONDS.toMillis((long)this.timeInMillis.getAverage()), (long)this.sizeInBytes.getAverage());
        }
    }
}

