/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import com.carrotsearch.hppc.ObjectDoubleHashMap;
import com.carrotsearch.hppc.ObjectDoubleMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.cluster.NodeUsageStatsForThreadPools;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.index.shard.ShardId;

public class ShardMovementWriteLoadSimulator {
    private final Map<String, NodeUsageStatsForThreadPools> originalNodeUsageStatsForThreadPools;
    private final ObjectDoubleMap<String> simulatedNodeWriteLoadDeltas;
    private final Map<ShardId, Double> writeLoadsPerShard;
    private final Set<String> nodesWithMovedAwayShard;

    public ShardMovementWriteLoadSimulator(RoutingAllocation routingAllocation) {
        this.originalNodeUsageStatsForThreadPools = routingAllocation.clusterInfo().getNodeUsageStatsForThreadPools();
        this.writeLoadsPerShard = routingAllocation.clusterInfo().getShardWriteLoads();
        this.simulatedNodeWriteLoadDeltas = new ObjectDoubleHashMap();
        this.nodesWithMovedAwayShard = new HashSet<String>();
    }

    public void simulateShardStarted(ShardRouting shardRouting) {
        Double writeLoadForShard = this.writeLoadsPerShard.get(shardRouting.shardId());
        if (writeLoadForShard != null) {
            if (shardRouting.relocatingNodeId() != null) {
                assert (shardRouting.state() == ShardRoutingState.INITIALIZING) : "This should only be happening on the destination node (the source node will have status RELOCATING)";
                this.simulatedNodeWriteLoadDeltas.addTo((Object)shardRouting.relocatingNodeId(), -1.0 * writeLoadForShard);
                this.simulatedNodeWriteLoadDeltas.addTo((Object)shardRouting.currentNodeId(), writeLoadForShard.doubleValue());
                this.nodesWithMovedAwayShard.add(shardRouting.relocatingNodeId());
            } else {
                this.simulatedNodeWriteLoadDeltas.addTo((Object)shardRouting.currentNodeId(), writeLoadForShard.doubleValue());
            }
        }
    }

    public Map<String, NodeUsageStatsForThreadPools> simulatedNodeUsageStatsForThreadPools() {
        Map<String, NodeUsageStatsForThreadPools> adjustedNodeUsageStatsForThreadPools = Maps.newMapWithExpectedSize(this.originalNodeUsageStatsForThreadPools.size());
        for (Map.Entry<String, NodeUsageStatsForThreadPools> entry : this.originalNodeUsageStatsForThreadPools.entrySet()) {
            if (this.simulatedNodeWriteLoadDeltas.containsKey((Object)entry.getKey())) {
                NodeUsageStatsForThreadPools adjustedValue = new NodeUsageStatsForThreadPools(entry.getKey(), Maps.copyMapWithAddedOrReplacedEntry(entry.getValue().threadPoolUsageStatsMap(), "write", ShardMovementWriteLoadSimulator.replaceWritePoolStats(entry.getValue(), this.simulatedNodeWriteLoadDeltas.get((Object)entry.getKey()), this.nodesWithMovedAwayShard.contains(entry.getKey()))));
                adjustedNodeUsageStatsForThreadPools.put(entry.getKey(), adjustedValue);
                continue;
            }
            adjustedNodeUsageStatsForThreadPools.put(entry.getKey(), entry.getValue());
        }
        return Collections.unmodifiableMap(adjustedNodeUsageStatsForThreadPools);
    }

    private static NodeUsageStatsForThreadPools.ThreadPoolUsageStats replaceWritePoolStats(NodeUsageStatsForThreadPools value, double writeLoadDelta, boolean hasSeenMovedAwayShard) {
        NodeUsageStatsForThreadPools.ThreadPoolUsageStats writeThreadPoolStats = value.threadPoolUsageStatsMap().get("write");
        return new NodeUsageStatsForThreadPools.ThreadPoolUsageStats(writeThreadPoolStats.totalThreadPoolThreads(), ShardMovementWriteLoadSimulator.updateNodeUtilizationWithShardMovements(writeThreadPoolStats.averageThreadPoolUtilization(), (float)writeLoadDelta, writeThreadPoolStats.totalThreadPoolThreads()), ShardMovementWriteLoadSimulator.adjustThreadPoolQueueLatencyWithShardMovements(writeThreadPoolStats.maxThreadPoolQueueLatencyMillis(), hasSeenMovedAwayShard));
    }

    public static float updateNodeUtilizationWithShardMovements(float nodeUtilization, float shardWriteLoadDelta, int numberOfWriteThreads) {
        float newNodeUtilization = nodeUtilization + ShardMovementWriteLoadSimulator.calculateUtilizationForWriteLoad(shardWriteLoadDelta, numberOfWriteThreads);
        return (float)Math.max((double)newNodeUtilization, 0.0);
    }

    public static float calculateUtilizationForWriteLoad(float totalShardWriteLoad, int numberOfThreads) {
        return totalShardWriteLoad / (float)numberOfThreads;
    }

    public static long adjustThreadPoolQueueLatencyWithShardMovements(long maxThreadPoolQueueLatencyMillis, boolean hasSeenMovedAwayShard) {
        return hasSeenMovedAwayShard ? 0L : maxThreadPoolQueueLatencyMillis;
    }
}

