/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.RemoteClusterActionType;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.search.ParsedScrollId;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollAsyncAction;
import org.elasticsearch.action.search.SearchScrollQueryAndFetchAsyncAction;
import org.elasticsearch.action.search.SearchScrollQueryThenFetchAsyncAction;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.search.SearchTask;
import org.elasticsearch.action.search.SearchTransportService;
import org.elasticsearch.action.search.TransportSearchHelper;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.rest.action.search.SearchResponseMetrics;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;

public class TransportSearchScrollAction
extends HandledTransportAction<SearchScrollRequest, SearchResponse> {
    public static final ActionType<SearchResponse> TYPE = new ActionType("indices:data/read/scroll");
    public static final RemoteClusterActionType<SearchResponse> REMOTE_TYPE = new RemoteClusterActionType<SearchResponse>(TYPE.name(), SearchResponse::new);
    private static final Logger logger = LogManager.getLogger(TransportSearchScrollAction.class);
    private final ClusterService clusterService;
    private final SearchTransportService searchTransportService;
    private final SearchResponseMetrics searchResponseMetrics;

    @Inject
    public TransportSearchScrollAction(TransportService transportService, ClusterService clusterService, ActionFilters actionFilters, SearchTransportService searchTransportService, SearchResponseMetrics searchResponseMetrics) {
        super(TYPE.name(), transportService, actionFilters, SearchScrollRequest::new, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.clusterService = clusterService;
        this.searchTransportService = searchTransportService;
        this.searchResponseMetrics = searchResponseMetrics;
    }

    @Override
    protected void doExecute(Task task, SearchScrollRequest request, final ActionListener<SearchResponse> listener) {
        ActionListener<SearchResponse> loggingAndMetrics = new ActionListener<SearchResponse>(){

            @Override
            public void onResponse(SearchResponse searchResponse) {
                try {
                    TransportSearchScrollAction.this.searchResponseMetrics.recordTookTimeForSearchScroll(searchResponse.getTookInMillis());
                    SearchResponseMetrics.ResponseCountTotalStatus responseCountTotalStatus = SearchResponseMetrics.ResponseCountTotalStatus.SUCCESS;
                    if (searchResponse.getShardFailures() != null && searchResponse.getShardFailures().length > 0) {
                        ShardOperationFailedException[] groupedFailures;
                        for (ShardOperationFailedException f : groupedFailures = ExceptionsHelper.groupBy(searchResponse.getShardFailures())) {
                            Throwable cause;
                            Throwable throwable = cause = f.getCause() == null ? f : f.getCause();
                            if (ExceptionsHelper.status(cause).getStatus() < 500 || ExceptionsHelper.isNodeOrShardUnavailableTypeException(cause)) continue;
                            logger.warn("TransportSearchScrollAction shard failure (partial results response)", (Throwable)f);
                            responseCountTotalStatus = SearchResponseMetrics.ResponseCountTotalStatus.PARTIAL_FAILURE;
                        }
                    }
                    listener.onResponse(searchResponse);
                    TransportSearchScrollAction.this.searchResponseMetrics.incrementResponseCount(responseCountTotalStatus);
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Exception e) {
                TransportSearchScrollAction.this.searchResponseMetrics.incrementResponseCount(SearchResponseMetrics.ResponseCountTotalStatus.FAILURE);
                listener.onFailure(e);
            }
        };
        try {
            ParsedScrollId scrollId = TransportSearchHelper.parseScrollId(request.scrollId());
            SearchScrollAsyncAction action = switch (scrollId.getType()) {
                case "queryThenFetch" -> new SearchScrollQueryThenFetchAsyncAction(logger, this.clusterService, this.searchTransportService, request, (SearchTask)task, scrollId, loggingAndMetrics);
                case "queryAndFetch" -> new SearchScrollQueryAndFetchAsyncAction(logger, this.clusterService, this.searchTransportService, request, (SearchTask)task, scrollId, loggingAndMetrics);
                default -> throw new IllegalArgumentException("Scroll id type [" + scrollId.getType() + "] unrecognized");
            };
            action.run();
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }
}

