/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.ingest;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.bulk.IndexDocFailureStoreStatus;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentType;

public class SimulateIndexResponse
extends IndexResponse {
    private static final TransportVersion SIMULATE_INGEST_EFFECTIVE_MAPPING = TransportVersion.fromName("simulate_ingest_effective_mapping");
    private final BytesReference source;
    private final XContentType sourceXContentType;
    private final Collection<String> ignoredFields;
    private final Exception exception;
    private final CompressedXContent effectiveMapping;

    public SimulateIndexResponse(StreamInput in) throws IOException {
        super(in);
        this.source = in.readBytesReference();
        this.sourceXContentType = XContentType.valueOf((String)in.readString());
        this.setShardInfo(ReplicationResponse.ShardInfo.EMPTY);
        this.exception = in.getTransportVersion().onOrAfter(TransportVersions.V_8_15_0) ? in.readException() : null;
        this.ignoredFields = in.getTransportVersion().supports(TransportVersions.V_8_18_0) ? in.readStringCollectionAsList() : List.of();
        this.effectiveMapping = in.getTransportVersion().supports(SIMULATE_INGEST_EFFECTIVE_MAPPING) ? (in.readBoolean() ? CompressedXContent.readCompressedString(in) : null) : null;
    }

    public SimulateIndexResponse(String id, String index, long version, BytesReference source, XContentType sourceXContentType, List<String> pipelines, Collection<String> ignoredFields, @Nullable Exception exception, @Nullable CompressedXContent effectiveMapping) {
        super(new ShardId(index, "", 0), id == null ? "<n/a>" : id, 0L, 0L, version, true, pipelines, IndexDocFailureStoreStatus.NOT_APPLICABLE_OR_UNKNOWN);
        this.source = source;
        this.sourceXContentType = sourceXContentType;
        this.setShardInfo(ReplicationResponse.ShardInfo.EMPTY);
        this.ignoredFields = ignoredFields;
        this.exception = exception;
        this.effectiveMapping = effectiveMapping;
    }

    @Override
    public XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("_id", this.getId());
        builder.field("_index", this.getShardId().getIndexName());
        builder.field("_version", this.getVersion());
        builder.field("_source", (Map)XContentHelper.convertToMap(this.source, false, this.sourceXContentType).v2());
        assert (this.executedPipelines != null) : "executedPipelines is null when it shouldn't be - we always list pipelines in simulate mode";
        builder.array("executed_pipelines", this.executedPipelines.toArray());
        if (!this.ignoredFields.isEmpty()) {
            builder.startArray("ignored_fields");
            for (String ignoredField : this.ignoredFields) {
                builder.startObject();
                builder.field("field", ignoredField);
                builder.endObject();
            }
            builder.endArray();
        }
        if (this.exception != null) {
            builder.startObject("error");
            ElasticsearchException.generateThrowableXContent(builder, params, this.exception);
            builder.endObject();
        }
        if (this.effectiveMapping == null) {
            builder.field("effective_mapping", Map.of());
        } else {
            builder.field("effective_mapping", (Map)XContentHelper.convertToMap(this.effectiveMapping.uncompressed(), true, builder.contentType()).v2());
        }
        return builder;
    }

    @Override
    public RestStatus status() {
        return RestStatus.CREATED;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBytesReference(this.source);
        out.writeString(this.sourceXContentType.name());
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_15_0)) {
            out.writeException(this.exception);
        }
        if (out.getTransportVersion().supports(TransportVersions.V_8_18_0)) {
            out.writeStringCollection(this.ignoredFields);
        }
        if (out.getTransportVersion().supports(SIMULATE_INGEST_EFFECTIVE_MAPPING)) {
            out.writeBoolean(this.effectiveMapping != null);
            if (this.effectiveMapping != null) {
                this.effectiveMapping.writeTo(out);
            }
        }
    }

    public Exception getException() {
        return this.exception;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SimulateIndexResponse[");
        builder.append("index=").append(this.getIndex());
        try {
            builder.append(",source=").append(XContentHelper.convertToJson(this.source, false, this.sourceXContentType));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        builder.append(",pipelines=[").append(String.join((CharSequence)", ", this.executedPipelines));
        return builder.append("]]").toString();
    }
}

