/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.fieldcaps;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.automaton.TooComplexToDeterminizeException;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.RemoteClusterActionType;
import org.elasticsearch.action.fieldcaps.FieldCapabilities;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesFailure;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesFetcher;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesIndexResponse;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesNodeRequest;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesNodeResponse;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesRequest;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesResponse;
import org.elasticsearch.action.fieldcaps.IndexFieldCapabilities;
import org.elasticsearch.action.fieldcaps.RequestDispatcher;
import org.elasticsearch.action.fieldcaps.ResponseRewriter;
import org.elasticsearch.action.search.TransportSearchHelper;
import org.elasticsearch.action.support.AbstractThreadedActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ChannelActionListener;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.RefCountingRunnable;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.ThrottledTaskRunner;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.RemoteClusterAware;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportService;

public class TransportFieldCapabilitiesAction
extends HandledTransportAction<FieldCapabilitiesRequest, FieldCapabilitiesResponse> {
    public static final String NAME = "indices:data/read/field_caps";
    public static final ActionType<FieldCapabilitiesResponse> TYPE = new ActionType("indices:data/read/field_caps");
    public static final RemoteClusterActionType<FieldCapabilitiesResponse> REMOTE_TYPE = new RemoteClusterActionType<FieldCapabilitiesResponse>("indices:data/read/field_caps", FieldCapabilitiesResponse::new);
    public static final String ACTION_NODE_NAME = "indices:data/read/field_caps[n]";
    public static final Logger LOGGER = LogManager.getLogger(TransportFieldCapabilitiesAction.class);
    private final Executor searchCoordinationExecutor;
    private final TransportService transportService;
    private final ClusterService clusterService;
    private final ProjectResolver projectResolver;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final IndicesService indicesService;
    private final boolean ccsCheckCompatibility;
    private final ThreadPool threadPool;
    private final TimeValue forceConnectTimeoutSecs;

    @Inject
    public TransportFieldCapabilitiesAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndicesService indicesService, ProjectResolver projectResolver, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(NAME, transportService, actionFilters, FieldCapabilitiesRequest::new, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.searchCoordinationExecutor = threadPool.executor("search_coordination");
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.projectResolver = projectResolver;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.indicesService = indicesService;
        transportService.registerRequestHandler(ACTION_NODE_NAME, this.searchCoordinationExecutor, FieldCapabilitiesNodeRequest::new, new NodeTransportHandler());
        this.ccsCheckCompatibility = SearchService.CCS_VERSION_CHECK_SETTING.get(clusterService.getSettings());
        this.threadPool = threadPool;
        this.forceConnectTimeoutSecs = clusterService.getSettings().getAsTime("search.ccs.force_connect_timeout", null);
    }

    @Override
    protected void doExecute(Task task, FieldCapabilitiesRequest request, ActionListener<FieldCapabilitiesResponse> listener) {
        this.executeRequest(task, request, listener);
    }

    public void executeRequest(Task task, FieldCapabilitiesRequest request, ActionListener<FieldCapabilitiesResponse> listener) {
        this.searchCoordinationExecutor.execute(ActionRunnable.wrap(listener, l -> this.doExecuteForked(task, request, (ActionListener<FieldCapabilitiesResponse>)l)));
    }

    private void doExecuteForked(Task task, FieldCapabilitiesRequest request, ActionListener<FieldCapabilitiesResponse> listener) {
        if (this.ccsCheckCompatibility) {
            TransportSearchHelper.checkCCSVersionCompatibility(request);
        }
        Executor singleThreadedExecutor = TransportFieldCapabilitiesAction.buildSingleThreadedExecutor(this.searchCoordinationExecutor, LOGGER);
        assert (task instanceof CancellableTask);
        CancellableTask fieldCapTask = (CancellableTask)task;
        long nowInMillis = request.nowInMillis() == null ? System.currentTimeMillis() : request.nowInMillis();
        ProjectState projectState = this.projectResolver.getProjectState(this.clusterService.state());
        Map<String, OriginalIndices> remoteClusterIndices = this.transportService.getRemoteClusterService().groupIndices(request.indicesOptions(), request.indices(), request.returnLocalAll());
        OriginalIndices localIndices = remoteClusterIndices.remove("");
        String[] concreteIndices = localIndices == null ? Strings.EMPTY_ARRAY : this.indexNameExpressionResolver.concreteIndexNames(projectState.metadata(), (IndicesRequest)localIndices);
        if (concreteIndices.length == 0 && remoteClusterIndices.isEmpty()) {
            listener.onResponse(new FieldCapabilitiesResponse(new String[0], Collections.emptyMap()));
            return;
        }
        TransportFieldCapabilitiesAction.checkIndexBlocks(projectState, concreteIndices);
        FailureCollector indexFailures = new FailureCollector();
        HashMap indexResponses = new HashMap();
        HashMap indexMappingHashToResponses = new HashMap();
        Runnable releaseResourcesOnCancel = () -> {
            LOGGER.trace("clear index responses on cancellation");
            indexFailures.clear();
            indexResponses.clear();
            indexMappingHashToResponses.clear();
        };
        Consumer<FieldCapabilitiesIndexResponse> handleIndexResponse = resp -> {
            FieldCapabilitiesIndexResponse curr;
            if (fieldCapTask.isCancelled()) {
                releaseResourcesOnCancel.run();
                return;
            }
            if (resp.canMatch() && resp.getIndexMappingHash() != null && (curr = indexMappingHashToResponses.putIfAbsent(resp.getIndexMappingHash(), resp)) != null) {
                resp = new FieldCapabilitiesIndexResponse(resp.getIndexName(), curr.getIndexMappingHash(), curr.get(), true, curr.getIndexMode());
            }
            if (request.includeEmptyFields()) {
                indexResponses.putIfAbsent(resp.getIndexName(), resp);
            } else {
                indexResponses.merge(resp.getIndexName(), resp, (a, b) -> {
                    if (a.get().equals(b.get())) {
                        return a;
                    }
                    HashMap<String, IndexFieldCapabilities> mergedCaps = new HashMap<String, IndexFieldCapabilities>(a.get());
                    mergedCaps.putAll(b.get());
                    return new FieldCapabilitiesIndexResponse(a.getIndexName(), a.getIndexMappingHash(), mergedCaps, true, a.getIndexMode());
                });
            }
            if (fieldCapTask.isCancelled()) {
                releaseResourcesOnCancel.run();
            }
        };
        BiConsumer<String, Exception> handleIndexFailure = (index, error) -> {
            if (fieldCapTask.isCancelled()) {
                releaseResourcesOnCancel.run();
                return;
            }
            indexFailures.collect((String)index, (Exception)error);
            if (fieldCapTask.isCancelled()) {
                releaseResourcesOnCancel.run();
            }
        };
        AtomicBoolean finishedOrCancelled = new AtomicBoolean();
        fieldCapTask.addListener(() -> {
            if (finishedOrCancelled.compareAndSet(false, true)) {
                singleThreadedExecutor.execute(releaseResourcesOnCancel);
                LOGGER.trace("clear index responses on cancellation submitted");
            }
        });
        try (RefCountingRunnable refs = new RefCountingRunnable(() -> {
            finishedOrCancelled.set(true);
            if (fieldCapTask.notifyIfCancelled(listener)) {
                releaseResourcesOnCancel.run();
            } else {
                TransportFieldCapabilitiesAction.mergeIndexResponses(request, fieldCapTask, indexResponses, indexFailures, listener);
            }
        });){
            RequestDispatcher requestDispatcher = new RequestDispatcher(this.clusterService, this.transportService, this.projectResolver, this.indicesService.getCoordinatorRewriteContextProvider(() -> nowInMillis), task, request, localIndices, nowInMillis, concreteIndices, singleThreadedExecutor, handleIndexResponse, handleIndexFailure, () -> ((Releasable)refs.acquire()).close());
            requestDispatcher.execute();
            for (Map.Entry<String, OriginalIndices> remoteIndices : remoteClusterIndices.entrySet()) {
                String clusterAlias = remoteIndices.getKey();
                OriginalIndices originalIndices = remoteIndices.getValue();
                FieldCapabilitiesRequest remoteRequest = TransportFieldCapabilitiesAction.prepareRemoteRequest(clusterAlias, request, originalIndices, nowInMillis);
                ActionListener remoteListener = ActionListener.wrap(response -> {
                    for (FieldCapabilitiesIndexResponse resp : response.getIndexResponses()) {
                        String indexName = RemoteClusterAware.buildRemoteIndexName(clusterAlias, resp.getIndexName());
                        handleIndexResponse.accept(new FieldCapabilitiesIndexResponse(indexName, resp.getIndexMappingHash(), resp.get(), resp.canMatch(), resp.getIndexMode()));
                    }
                    for (FieldCapabilitiesFailure failure : response.getFailures()) {
                        Exception ex = failure.getException();
                        for (String index : failure.getIndices()) {
                            handleIndexFailure.accept(RemoteClusterAware.buildRemoteIndexName(clusterAlias, index), ex);
                        }
                    }
                }, ex -> {
                    for (String index : originalIndices.indices()) {
                        handleIndexFailure.accept(RemoteClusterAware.buildRemoteIndexName(clusterAlias, index), (Exception)ex);
                    }
                });
                SubscribableListener<Transport.Connection> connectionListener = new SubscribableListener<Transport.Connection>();
                if (this.forceConnectTimeoutSecs != null) {
                    connectionListener.addTimeout(this.forceConnectTimeoutSecs, this.threadPool, singleThreadedExecutor);
                }
                connectionListener.addListener(new ForkingOnFailureActionListener(singleThreadedExecutor, true, ActionListener.releaseAfter(remoteListener, refs.acquire())).delegateFailure((responseListener, conn) -> this.transportService.sendRequest((Transport.Connection)conn, REMOTE_TYPE.name(), (TransportRequest)remoteRequest, TransportRequestOptions.EMPTY, new ActionListenerResponseHandler<FieldCapabilitiesResponse>((ActionListener<FieldCapabilitiesResponse>)responseListener, FieldCapabilitiesResponse::new, singleThreadedExecutor))));
                boolean ensureConnected = this.forceConnectTimeoutSecs != null || this.transportService.getRemoteClusterService().isSkipUnavailable(clusterAlias).orElse(true) == false;
                this.transportService.getRemoteClusterService().maybeEnsureConnectedAndGetConnection(clusterAlias, ensureConnected, connectionListener);
            }
        }
    }

    public static Executor buildSingleThreadedExecutor(Executor searchCoordinationExecutor, final Logger logger) {
        ThrottledTaskRunner throttledTaskRunner = new ThrottledTaskRunner("field_caps", 1, searchCoordinationExecutor);
        return r -> throttledTaskRunner.enqueueTask(new ActionListener<Releasable>(){

            @Override
            public void onResponse(Releasable releasable) {
                try (Releasable releasable2 = releasable;){
                    r.run();
                }
            }

            @Override
            public void onFailure(Exception e) {
                if (r instanceof AbstractRunnable) {
                    AbstractRunnable abstractRunnable = (AbstractRunnable)r;
                    abstractRunnable.onFailure(e);
                } else {
                    logger.error("unexpected failure running " + String.valueOf(r), (Throwable)e);
                    assert (false) : new AssertionError("unexpected failure running " + String.valueOf(r), e);
                }
            }
        });
    }

    public static void checkIndexBlocks(ProjectState projectState, String[] concreteIndices) {
        ProjectId projectId;
        ClusterBlocks blocks = projectState.blocks();
        if (blocks.global(projectId = projectState.projectId()).isEmpty() && blocks.indices(projectId).isEmpty()) {
            return;
        }
        blocks.globalBlockedRaiseException(projectId, ClusterBlockLevel.READ);
        for (String index : concreteIndices) {
            blocks.indexBlockedRaiseException(projectState.projectId(), ClusterBlockLevel.READ, index);
        }
    }

    private static void mergeIndexResponses(FieldCapabilitiesRequest request, CancellableTask task, Map<String, FieldCapabilitiesIndexResponse> indexResponses, FailureCollector indexFailures, ActionListener<FieldCapabilitiesResponse> listener) {
        List<FieldCapabilitiesFailure> failures = indexFailures.build(indexResponses.keySet());
        if (indexResponses.size() > 0) {
            if (request.isMergeResults()) {
                ActionListener.completeWith(listener, () -> TransportFieldCapabilitiesAction.merge(indexResponses, task, request, failures));
            } else {
                listener.onResponse(new FieldCapabilitiesResponse(new ArrayList<FieldCapabilitiesIndexResponse>(indexResponses.values()), failures));
            }
        } else if (!indexFailures.isEmpty()) {
            if (failures.stream().anyMatch(failure -> {
                IllegalStateException ise;
                Exception patt0$temp = failure.getException();
                return patt0$temp instanceof IllegalStateException && (ise = (IllegalStateException)patt0$temp).getCause() instanceof ElasticsearchTimeoutException;
            })) {
                listener.onResponse(new FieldCapabilitiesResponse(Collections.emptyList(), failures));
            } else {
                listener.onFailure(failures.get(0).getException());
            }
        } else {
            listener.onResponse(new FieldCapabilitiesResponse(Collections.emptyList(), Collections.emptyList()));
        }
    }

    public static FieldCapabilitiesRequest prepareRemoteRequest(String clusterAlias, FieldCapabilitiesRequest request, OriginalIndices originalIndices, long nowInMillis) {
        FieldCapabilitiesRequest remoteRequest = new FieldCapabilitiesRequest();
        remoteRequest.clusterAlias(clusterAlias);
        remoteRequest.setMergeResults(false);
        remoteRequest.indicesOptions(originalIndices.indicesOptions());
        remoteRequest.indices(originalIndices.indices());
        remoteRequest.fields(request.fields());
        remoteRequest.filters(request.filters());
        remoteRequest.types(request.types());
        remoteRequest.runtimeFields(request.runtimeFields());
        remoteRequest.indexFilter(request.indexFilter());
        remoteRequest.nowInMillis(nowInMillis);
        remoteRequest.includeEmptyFields(request.includeEmptyFields());
        return remoteRequest;
    }

    private static boolean hasSameMappingHash(FieldCapabilitiesIndexResponse r1, FieldCapabilitiesIndexResponse r2) {
        return r1.getIndexMappingHash() != null && r2.getIndexMappingHash() != null && r1.getIndexMappingHash().equals(r2.getIndexMappingHash());
    }

    private static FieldCapabilitiesResponse merge(Map<String, FieldCapabilitiesIndexResponse> indexResponsesMap, CancellableTask task, FieldCapabilitiesRequest request, List<FieldCapabilitiesFailure> failures) {
        assert (ThreadPool.assertCurrentThreadPool("search_coordination"));
        task.ensureNotCancelled();
        FieldCapabilitiesIndexResponse[] indexResponses = indexResponsesMap.values().toArray(new FieldCapabilitiesIndexResponse[0]);
        Arrays.sort(indexResponses, Comparator.comparing(FieldCapabilitiesIndexResponse::getIndexName));
        Object[] indices = (String[])Arrays.stream(indexResponses).map(FieldCapabilitiesIndexResponse::getIndexName).toArray(String[]::new);
        HashMap<String, Map<String, FieldCapabilities.Builder>> fieldsBuilder = new HashMap<String, Map<String, FieldCapabilities.Builder>>();
        int lastPendingIndex = 0;
        for (int i = 1; i <= indexResponses.length; ++i) {
            if (i != indexResponses.length && TransportFieldCapabilitiesAction.hasSameMappingHash(indexResponses[lastPendingIndex], indexResponses[i])) continue;
            Object[] subIndices = lastPendingIndex == 0 && i == indexResponses.length ? indices : (String[])ArrayUtil.copyOfSubArray((Object[])indices, (int)lastPendingIndex, (int)i);
            TransportFieldCapabilitiesAction.innerMerge((String[])subIndices, fieldsBuilder, request, indexResponses[lastPendingIndex]);
            lastPendingIndex = i;
        }
        task.ensureNotCancelled();
        Map<String, Map<String, FieldCapabilities>> fields = Maps.newMapWithExpectedSize(fieldsBuilder.size());
        if (request.includeUnmapped()) {
            TransportFieldCapabilitiesAction.collectFieldsIncludingUnmapped((String[])indices, fieldsBuilder, fields, request.includeIndices());
        } else {
            TransportFieldCapabilitiesAction.collectFields(fieldsBuilder, fields, request.includeIndices());
        }
        for (FieldCapabilitiesFailure failure : failures) {
            if (!TransportFieldCapabilitiesAction.shouldLogException(failure.getException())) continue;
            LOGGER.warn("Field caps partial-results Exception for indices " + Arrays.toString(failure.getIndices()), (Throwable)failure.getException());
        }
        return new FieldCapabilitiesResponse((String[])indices, Collections.unmodifiableMap(fields), failures);
    }

    private static boolean shouldLogException(Exception e) {
        return !(e instanceof ConnectTransportException) && ExceptionsHelper.status(e).getStatus() >= 500 && !ExceptionsHelper.isNodeOrShardUnavailableTypeException(e);
    }

    private static void collectFieldsIncludingUnmapped(String[] indices, Map<String, Map<String, FieldCapabilities.Builder>> fieldsBuilder, Map<String, Map<String, FieldCapabilities>> fieldsMap, boolean includeIndices) {
        HashSet<String> mappedScratch = new HashSet<String>();
        for (Map.Entry<String, Map<String, FieldCapabilities.Builder>> entry : fieldsBuilder.entrySet()) {
            Set<Map.Entry<String, FieldCapabilities.Builder>> typeMapBuilder = entry.getValue().entrySet();
            mappedScratch.clear();
            for (Map.Entry<String, FieldCapabilities.Builder> b : typeMapBuilder) {
                b.getValue().getIndices(mappedScratch);
            }
            Function<Boolean, FieldCapabilities> unmapped = TransportFieldCapabilitiesAction.getUnmappedFields(indices, entry.getKey(), mappedScratch);
            int resSize = typeMapBuilder.size() + (unmapped == null ? 0 : 1);
            Map<String, FieldCapabilities> res = TransportFieldCapabilitiesAction.capabilities(resSize, typeMapBuilder, includeIndices);
            if (unmapped != null) {
                res.put("unmapped", unmapped.apply(resSize > 1));
            }
            fieldsMap.put(entry.getKey(), Collections.unmodifiableMap(res));
        }
    }

    private static void collectFields(Map<String, Map<String, FieldCapabilities.Builder>> fieldsBuilder, Map<String, Map<String, FieldCapabilities>> fields, boolean includeIndices) {
        for (Map.Entry<String, Map<String, FieldCapabilities.Builder>> entry : fieldsBuilder.entrySet()) {
            Set<Map.Entry<String, FieldCapabilities.Builder>> typeMapBuilder = entry.getValue().entrySet();
            fields.put(entry.getKey(), Collections.unmodifiableMap(TransportFieldCapabilitiesAction.capabilities(typeMapBuilder.size(), typeMapBuilder, includeIndices)));
        }
    }

    private static Map<String, FieldCapabilities> capabilities(int resSize, Set<Map.Entry<String, FieldCapabilities.Builder>> builders, boolean includeIndices) {
        boolean multiTypes = resSize > 1;
        boolean withIndices = multiTypes || includeIndices;
        Map<String, FieldCapabilities> res = Maps.newHashMapWithExpectedSize(resSize);
        for (Map.Entry<String, FieldCapabilities.Builder> e : builders) {
            res.put(e.getKey(), e.getValue().build(withIndices));
        }
        return res;
    }

    @Nullable
    private static Function<Boolean, FieldCapabilities> getUnmappedFields(String[] indices, String field, Set<String> mappedIndices) {
        if (mappedIndices.size() != indices.length) {
            return mt -> {
                String[] diff;
                if (mt.booleanValue()) {
                    diff = new String[indices.length - mappedIndices.size()];
                    Iterator<String> indicesIter = Iterators.forArray(indices);
                    for (int i = 0; i < diff.length; ++i) {
                        diff[i] = TransportFieldCapabilitiesAction.nextIndex(indicesIter, mappedIndices);
                    }
                } else {
                    diff = null;
                }
                return new FieldCapabilities(field, "unmapped", false, false, false, false, null, diff, null, null, null, null, Map.of());
            };
        }
        return null;
    }

    private static String nextIndex(Iterator<String> iter, Set<String> filtered) {
        String index;
        while (filtered.contains(index = iter.next())) {
        }
        return index;
    }

    private static void innerMerge(String[] indices, Map<String, Map<String, FieldCapabilities.Builder>> responseMapBuilder, FieldCapabilitiesRequest request, FieldCapabilitiesIndexResponse response) {
        Map<String, IndexFieldCapabilities> fields = ResponseRewriter.rewriteOldResponses(response.getOriginVersion(), response.get(), request.filters(), request.types());
        for (Map.Entry<String, IndexFieldCapabilities> entry : fields.entrySet()) {
            String field = entry.getKey();
            IndexFieldCapabilities fieldCap = entry.getValue();
            Map typeMap = responseMapBuilder.computeIfAbsent(field, f -> new HashMap());
            FieldCapabilities.Builder builder = typeMap.computeIfAbsent(fieldCap.type(), key -> new FieldCapabilities.Builder(field, (String)key));
            builder.add(indices, fieldCap.isMetadatafield(), fieldCap.isSearchable(), fieldCap.isAggregatable(), fieldCap.isDimension(), fieldCap.metricType(), fieldCap.meta());
        }
    }

    private class NodeTransportHandler
    implements TransportRequestHandler<FieldCapabilitiesNodeRequest> {
        private NodeTransportHandler() {
        }

        @Override
        public void messageReceived(FieldCapabilitiesNodeRequest request, TransportChannel channel, Task task) {
            assert (task instanceof CancellableTask);
            ChannelActionListener listener = new ChannelActionListener(channel);
            ActionListener.completeWith(listener, () -> {
                Predicate<String> fieldNameFilter;
                ArrayList<FieldCapabilitiesIndexResponse> allResponses = new ArrayList<FieldCapabilitiesIndexResponse>();
                HashMap<ShardId, Exception> allFailures = new HashMap<ShardId, Exception>();
                HashSet<ShardId> allUnmatchedShardIds = new HashSet<ShardId>();
                Map<String, List<ShardId>> groupedShardIds = request.shardIds().stream().collect(Collectors.groupingBy(ShardId::getIndexName));
                FieldCapabilitiesFetcher fetcher = new FieldCapabilitiesFetcher(TransportFieldCapabilitiesAction.this.indicesService, request.includeEmptyFields());
                try {
                    fieldNameFilter = Regex.simpleMatcher(request.fields());
                }
                catch (TooComplexToDeterminizeException e) {
                    throw new IllegalArgumentException("The field names are too complex to process. " + e.getMessage());
                }
                for (List<ShardId> shardIds : groupedShardIds.values()) {
                    HashMap<ShardId, Exception> failures = new HashMap<ShardId, Exception>();
                    HashSet<ShardId> unmatched = new HashSet<ShardId>();
                    for (ShardId shardId : shardIds) {
                        try {
                            FieldCapabilitiesIndexResponse response = fetcher.fetch((CancellableTask)task, shardId, fieldNameFilter, request.filters(), request.allowedTypes(), request.indexFilter(), request.nowInMillis(), request.runtimeFields());
                            if (response.canMatch()) {
                                allResponses.add(response);
                                if (!request.includeEmptyFields()) continue;
                                unmatched.clear();
                                failures.clear();
                                break;
                            }
                            unmatched.add(shardId);
                        }
                        catch (Exception e) {
                            failures.put(shardId, e);
                        }
                    }
                    allUnmatchedShardIds.addAll(unmatched);
                    allFailures.putAll(failures);
                }
                return new FieldCapabilitiesNodeResponse(allResponses, allFailures, allUnmatchedShardIds);
            });
        }
    }

    public static final class FailureCollector {
        private final Map<String, Exception> failuresByIndex = new HashMap<String, Exception>();

        public List<FieldCapabilitiesFailure> build(Set<String> successfulIndices) {
            HashMap<Tuple, FieldCapabilitiesFailure> indexFailures = new HashMap<Tuple, FieldCapabilitiesFailure>();
            for (Map.Entry<String, Exception> failure : this.failuresByIndex.entrySet()) {
                String index = failure.getKey();
                Exception e = failure.getValue();
                if (e instanceof ElasticsearchTimeoutException) {
                    ElasticsearchTimeoutException ete = (ElasticsearchTimeoutException)e;
                    e = new IllegalStateException("Unable to open any connections", ete);
                }
                if (successfulIndices.contains(index)) continue;
                Throwable cause = ExceptionsHelper.unwrapCause(e);
                Tuple groupingKey = new Tuple((Object)cause.getMessage(), (Object)cause.getClass().getName());
                Exception ex = e;
                indexFailures.compute(groupingKey, (k, v) -> v == null ? new FieldCapabilitiesFailure(new String[]{index}, ex) : v.addIndex(index));
            }
            return new ArrayList<FieldCapabilitiesFailure>(indexFailures.values());
        }

        public void collect(String index, Exception e) {
            this.failuresByIndex.putIfAbsent(index, e);
        }

        public void clear() {
            this.failuresByIndex.clear();
        }

        public boolean isEmpty() {
            return this.failuresByIndex.isEmpty();
        }
    }

    public static class ForkingOnFailureActionListener<Response>
    extends AbstractThreadedActionListener<Response> {
        public ForkingOnFailureActionListener(Executor executor, boolean forceExecution, ActionListener<Response> delegate) {
            super(executor, forceExecution, delegate);
        }

        @Override
        public void onResponse(Response response) {
            this.delegate.onResponse(response);
        }
    }
}

