/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.create;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class CreateSnapshotResponse
extends ActionResponse
implements ToXContentObject {
    @Nullable
    private final SnapshotInfo snapshotInfo;

    public CreateSnapshotResponse(@Nullable SnapshotInfo snapshotInfo) {
        this.snapshotInfo = snapshotInfo;
    }

    public CreateSnapshotResponse(StreamInput in) throws IOException {
        this.snapshotInfo = in.readOptionalWriteable(SnapshotInfo::readFrom);
    }

    public SnapshotInfo getSnapshotInfo() {
        return this.snapshotInfo;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable(this.snapshotInfo);
    }

    public RestStatus status() {
        if (this.snapshotInfo == null) {
            return RestStatus.ACCEPTED;
        }
        return this.snapshotInfo.status();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.snapshotInfo != null) {
            builder.field("snapshot");
            this.snapshotInfo.toXContentExternal(builder, params);
        } else {
            builder.field("accepted", true);
        }
        builder.endObject();
        return builder;
    }

    public String toString() {
        return "CreateSnapshotResponse{snapshotInfo=" + String.valueOf(this.snapshotInfo) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateSnapshotResponse that = (CreateSnapshotResponse)o;
        return Objects.equals(this.snapshotInfo, that.snapshotInfo);
    }

    public int hashCode() {
        return Objects.hash(this.snapshotInfo);
    }
}

