/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plugin;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamOutput;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;

record RemoteClusterPlan(PhysicalPlan plan, String[] targetIndices, OriginalIndices originalIndices) {
    static RemoteClusterPlan from(PlanStreamInput planIn) throws IOException {
        PhysicalPlan plan = (PhysicalPlan)planIn.readNamedWriteable(PhysicalPlan.class);
        String[] targetIndices = planIn.readStringArray();
        OriginalIndices originalIndices = OriginalIndices.readOriginalIndices((StreamInput)planIn);
        return new RemoteClusterPlan(plan, targetIndices, originalIndices);
    }

    public void writeTo(PlanStreamOutput out) throws IOException {
        out.writeNamedWriteable((NamedWriteable)this.plan);
        out.writeStringArray(this.targetIndices);
        OriginalIndices.writeOriginalIndices((OriginalIndices)this.originalIndices, (StreamOutput)out);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteClusterPlan that = (RemoteClusterPlan)o;
        return Objects.equals((Object)this.plan, (Object)that.plan) && Objects.deepEquals(this.targetIndices, that.targetIndices) && Objects.equals(this.originalIndices, that.originalIndices);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.plan, Arrays.hashCode(this.targetIndices), this.originalIndices});
    }
}

