/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.logical;

import java.util.function.Predicate;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.predicate.regex.RegexMatch;
import org.elasticsearch.xpack.esql.core.expression.predicate.regex.StringPattern;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.ChangeCase;
import org.elasticsearch.xpack.esql.optimizer.LogicalOptimizerContext;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.OptimizerRules;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.ReplaceStringCasingWithInsensitiveEquals;

public class ReplaceStringCasingWithInsensitiveRegexMatch
extends OptimizerRules.OptimizerExpressionRule<RegexMatch<? extends StringPattern>> {
    public ReplaceStringCasingWithInsensitiveRegexMatch() {
        super(OptimizerRules.TransformDirection.DOWN);
    }

    @Override
    protected Expression rule(RegexMatch<? extends StringPattern> regexMatch, LogicalOptimizerContext unused) {
        Expression expression = regexMatch.field();
        if (expression instanceof ChangeCase) {
            ChangeCase changeCase = (ChangeCase)expression;
            Predicate<String> matchesCase = changeCase.caseType()::matchesCase;
            Expression unwrappedField = ReplaceStringCasingWithInsensitiveEquals.unwrapCase(regexMatch.field());
            return regexMatch.optimizeStringCasingWithInsensitiveRegexMatch(unwrappedField, matchesCase);
        }
        return regexMatch;
    }
}

