/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.logical;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.xpack.esql.optimizer.LogicalOptimizerContext;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.OptimizerRules;
import org.elasticsearch.xpack.esql.plan.logical.Aggregate;
import org.elasticsearch.xpack.esql.plan.logical.Enrich;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.Limit;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.MvExpand;
import org.elasticsearch.xpack.esql.plan.logical.Project;
import org.elasticsearch.xpack.esql.plan.logical.RegexExtract;
import org.elasticsearch.xpack.esql.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.esql.plan.logical.inference.InferencePlan;
import org.elasticsearch.xpack.esql.plan.logical.join.InlineJoin;
import org.elasticsearch.xpack.esql.plan.logical.join.Join;
import org.elasticsearch.xpack.esql.plan.logical.join.JoinTypes;

public final class PushDownAndCombineLimits
extends OptimizerRules.ParameterizedOptimizerRule<Limit, LogicalOptimizerContext> {
    public PushDownAndCombineLimits() {
        super(OptimizerRules.TransformDirection.DOWN);
    }

    @Override
    public LogicalPlan rule(Limit limit, LogicalOptimizerContext ctx) {
        LogicalPlan limitSource;
        LogicalPlan logicalPlan = limit.child();
        if (logicalPlan instanceof Limit) {
            int childLimitValue;
            Limit childLimit = (Limit)logicalPlan;
            limitSource = limit.limit();
            int parentLimitValue = (Integer)limitSource.fold(ctx.foldCtx());
            return parentLimitValue < (childLimitValue = ((Integer)childLimit.limit().fold(ctx.foldCtx())).intValue()) ? limit.replaceChild(childLimit.child()) : childLimit;
        }
        limitSource = limit.child();
        if (limitSource instanceof UnaryPlan) {
            UnaryPlan unary = (UnaryPlan)limitSource;
            if (unary instanceof Eval || unary instanceof Project || unary instanceof RegexExtract || unary instanceof Enrich || unary instanceof InferencePlan) {
                return unary.replaceChild(limit.replaceChild(unary.child()));
            }
            if (unary instanceof MvExpand) {
                return PushDownAndCombineLimits.duplicateLimitAsFirstGrandchild(limit);
            }
            Limit descendantLimit = PushDownAndCombineLimits.descendantLimit(unary);
            if (descendantLimit != null) {
                int l1 = (Integer)limit.limit().fold(ctx.foldCtx());
                int l2 = (Integer)descendantLimit.limit().fold(ctx.foldCtx());
                if (l2 <= l1) {
                    return limit.withLimit(descendantLimit.limit());
                }
            }
        } else {
            Join join;
            logicalPlan = limit.child();
            if (logicalPlan instanceof Join && (join = (Join)logicalPlan).config().type() == JoinTypes.LEFT && !(join instanceof InlineJoin)) {
                return PushDownAndCombineLimits.duplicateLimitAsFirstGrandchild(limit);
            }
        }
        return limit;
    }

    private static Limit descendantLimit(UnaryPlan unary) {
        UnaryPlan plan = unary;
        while (!(plan instanceof Aggregate)) {
            UnaryPlan unaryPlan;
            if (plan instanceof Limit) {
                Limit limit = (Limit)plan;
                return limit;
            }
            if (plan instanceof MvExpand) {
                return null;
            }
            LogicalPlan logicalPlan = plan.child();
            if (!(logicalPlan instanceof UnaryPlan)) break;
            plan = unaryPlan = (UnaryPlan)logicalPlan;
        }
        return null;
    }

    private static Limit duplicateLimitAsFirstGrandchild(Limit limit) {
        if (limit.duplicated()) {
            return limit;
        }
        List grandChildren = limit.child().children();
        LogicalPlan firstGrandChild = (LogicalPlan)((Object)grandChildren.getFirst());
        Limit newFirstGrandChild = limit.replaceChild(firstGrandChild);
        ArrayList<LogicalPlan> newGrandChildren = new ArrayList<LogicalPlan>();
        newGrandChildren.add(newFirstGrandChild);
        for (int i = 1; i < grandChildren.size(); ++i) {
            newGrandChildren.add((LogicalPlan)((Object)grandChildren.get(i)));
        }
        LogicalPlan newChild = (LogicalPlan)limit.child().replaceChildren(newGrandChildren);
        return limit.replaceChild(newChild).withDuplicated(true);
    }
}

