/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.io.stream;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.LongFunction;
import org.apache.lucene.util.ArrayUtil;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.breaker.NoopCircuitBreaker;
import org.elasticsearch.common.io.stream.NamedWriteableAwareStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BlockStreamInput;
import org.elasticsearch.compute.data.BlockUtils;
import org.elasticsearch.compute.data.BooleanBigArrayBlock;
import org.elasticsearch.compute.data.DoubleBigArrayBlock;
import org.elasticsearch.compute.data.IntBigArrayBlock;
import org.elasticsearch.compute.data.LongBigArrayBlock;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.Column;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.NameId;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.EsField;
import org.elasticsearch.xpack.esql.session.Configuration;

public final class PlanStreamInput
extends NamedWriteableAwareStreamInput
implements org.elasticsearch.xpack.esql.core.util.PlanStreamInput {
    private final Map<Integer, Block> cachedBlocks = new HashMap<Integer, Block>();
    private Attribute[] attributesCache = new Attribute[1024];
    private EsField[] esFieldsCache = new EsField[1024];
    private String[] stringCache = new String[1024];
    private final LongFunction<NameId> nameIdFunction;
    private final Configuration configuration;

    public PlanStreamInput(StreamInput streamInput, NamedWriteableRegistry namedWriteableRegistry, Configuration configuration) {
        super(streamInput, namedWriteableRegistry);
        this.configuration = configuration;
        this.nameIdFunction = new NameIdMapper();
    }

    public Configuration configuration() throws IOException {
        return this.configuration;
    }

    public Block readCachedBlock() throws IOException {
        byte key = this.readByte();
        Block block = switch (key) {
            case 0 -> {
                int id = this.readVInt();
                BlockStreamInput in = new BlockStreamInput((StreamInput)this, new BlockFactory((CircuitBreaker)new NoopCircuitBreaker("request"), BigArrays.NON_RECYCLING_INSTANCE));
                Block b = Block.readTypedBlock((BlockStreamInput)in);
                this.cachedBlocks.put(id, b);
                yield b;
            }
            case 1 -> this.cachedBlocks.get(this.readVInt());
            case 2 -> {
                String tableName = this.readString();
                Map<String, Column> table = this.configuration.tables().get(tableName);
                if (table == null) {
                    throw new IOException("can't find table [" + tableName + "]");
                }
                String columnName = this.readString();
                Column column = table.get(columnName);
                if (column == null) {
                    throw new IOException("can't find column[" + columnName + "]");
                }
                yield column.values();
            }
            default -> throw new IOException("invalid encoding for Block");
        };
        assert (!(block instanceof LongBigArrayBlock)) : "BigArrays not supported because we don't close";
        assert (!(block instanceof IntBigArrayBlock)) : "BigArrays not supported because we don't close";
        assert (!(block instanceof DoubleBigArrayBlock)) : "BigArrays not supported because we don't close";
        assert (!(block instanceof BooleanBigArrayBlock)) : "BigArrays not supported because we don't close";
        return block;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Block[] readCachedBlockArray() throws IOException {
        int len = this.readArraySize();
        if (len == 0) {
            return BlockUtils.NO_BLOCKS;
        }
        Block[] blocks = new Block[len];
        try {
            for (int i = 0; i < blocks.length; ++i) {
                blocks[i] = this.readCachedBlock();
            }
            Block[] blockArray = blocks;
            return blockArray;
        }
        finally {
            if (blocks[blocks.length - 1] == null) {
                Releasables.closeExpectNoException((Releasable[])blocks);
            }
        }
    }

    public String sourceText() {
        return this.configuration == null ? Source.EMPTY.text() : this.configuration.query();
    }

    static void throwOnNullOptionalRead(Class<?> type) throws IOException {
        IOException e = new IOException("read optional named returned null which is not allowed, type:" + String.valueOf(type));
        assert (false) : e;
        throw e;
    }

    public NameId mapNameId(long l) {
        return this.nameIdFunction.apply(l);
    }

    public <A extends Attribute> A readAttributeWithCache(CheckedFunction<StreamInput, A, IOException> constructor) throws IOException {
        int cacheId = Math.toIntExact(this.readZLong());
        if (cacheId < 0) {
            cacheId = -1 - cacheId;
            Attribute result = (Attribute)constructor.apply((Object)this);
            this.cacheAttribute(cacheId, result);
            return (A)result;
        }
        return (A)this.attributeFromCache(cacheId);
    }

    private Attribute attributeFromCache(int id) throws IOException {
        Attribute attribute = this.attributesCache[id];
        if (attribute == null) {
            throw new IOException("Attribute ID not found in serialization cache [" + id + "]");
        }
        return attribute;
    }

    private void cacheAttribute(int id, Attribute attr) {
        assert (id >= 0);
        if (id >= this.attributesCache.length) {
            this.attributesCache = (Attribute[])ArrayUtil.grow((Object[])this.attributesCache, (int)(id + 1));
        }
        this.attributesCache[id] = attr;
    }

    public <A extends EsField> A readEsFieldWithCache() throws IOException {
        int cacheId = Math.toIntExact(this.readZLong());
        if (cacheId < 0) {
            String className = this.readCachedString();
            Writeable.Reader reader = EsField.getReader((String)className);
            cacheId = -1 - cacheId;
            EsField result = (EsField)reader.read((StreamInput)this);
            this.cacheEsField(cacheId, result);
            return (A)result;
        }
        return (A)this.esFieldFromCache(cacheId);
    }

    public String readCachedString() throws IOException {
        int cacheId = Math.toIntExact(this.readZLong());
        if (cacheId < 0) {
            String string = this.readString();
            cacheId = -1 - cacheId;
            this.cacheString(cacheId, string);
            return string;
        }
        return this.stringFromCache(cacheId);
    }

    public String readOptionalCachedString() throws IOException {
        return this.readBoolean() ? this.readCachedString() : null;
    }

    private EsField esFieldFromCache(int id) throws IOException {
        EsField field = this.esFieldsCache[id];
        if (field == null) {
            throw new IOException("Attribute ID not found in serialization cache [" + id + "]");
        }
        return field;
    }

    private void cacheEsField(int id, EsField field) {
        assert (id >= 0);
        if (id >= this.esFieldsCache.length) {
            this.esFieldsCache = (EsField[])ArrayUtil.grow((Object[])this.esFieldsCache, (int)(id + 1));
        }
        this.esFieldsCache[id] = field;
    }

    private String stringFromCache(int id) throws IOException {
        String value = this.stringCache[id];
        if (value == null) {
            throw new IOException("String not found in serialization cache [" + id + "]");
        }
        return value;
    }

    private void cacheString(int id, String string) {
        assert (id >= 0);
        if (id >= this.stringCache.length) {
            this.stringCache = (String[])ArrayUtil.grow((Object[])this.stringCache, (int)(id + 1));
        }
        this.stringCache[id] = string;
    }

    public void close() throws IOException {
        super.close();
        this.stringCache = null;
        this.attributesCache = null;
        this.esFieldsCache = null;
    }

    static final class NameIdMapper
    implements LongFunction<NameId> {
        final Map<Long, NameId> seen = new HashMap<Long, NameId>();

        NameIdMapper() {
        }

        @Override
        public NameId apply(long streamNameId) {
            return this.seen.computeIfAbsent(streamNameId, k -> new NameId());
        }
    }
}

