/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.inference.textembedding;

import java.util.List;
import java.util.NoSuchElementException;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xpack.core.inference.action.InferenceAction;
import org.elasticsearch.xpack.esql.inference.InputTextReader;
import org.elasticsearch.xpack.esql.inference.bulk.BulkInferenceRequestIterator;

class TextEmbeddingOperatorRequestIterator
implements BulkInferenceRequestIterator {
    private final InputTextReader textReader;
    private final String inferenceId;
    private final int size;
    private int currentPos = 0;

    TextEmbeddingOperatorRequestIterator(BytesRefBlock textBlock, String inferenceId) {
        this.textReader = new InputTextReader(textBlock);
        this.size = textBlock.getPositionCount();
        this.inferenceId = inferenceId;
    }

    @Override
    public boolean hasNext() {
        return this.currentPos < this.size;
    }

    @Override
    public InferenceAction.Request next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.inferenceRequest(this.textReader.readText(this.currentPos++, 1));
    }

    private InferenceAction.Request inferenceRequest(String text) {
        if (text == null) {
            return null;
        }
        return InferenceAction.Request.builder((String)this.inferenceId, (TaskType)TaskType.TEXT_EMBEDDING).setInput(List.of(text)).build();
    }

    @Override
    public int estimatedSize() {
        return this.textReader.estimatedSize();
    }

    public void close() {
        Releasables.close((Releasable)this.textReader);
    }
}

