/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.predicate.operator.comparison;

import java.time.ZoneId;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.time.DateUtils;
import org.elasticsearch.xpack.esql.capabilities.TranslationAware;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.predicate.Negatable;
import org.elasticsearch.xpack.esql.core.querydsl.query.Query;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.EsqlArithmeticOperation;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.EqualsBoolsEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.EqualsDoublesEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.EqualsGeometriesEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.EqualsIntsEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.EqualsKeywordsEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.EqualsLongsEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.EqualsMillisNanosEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.EqualsNanosMillisEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.EsqlBinaryComparison;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.NotEquals;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.LucenePushdownPredicates;
import org.elasticsearch.xpack.esql.planner.TranslatorHandler;
import org.elasticsearch.xpack.esql.querydsl.query.EqualsSyntheticSourceDelegate;
import org.elasticsearch.xpack.esql.querydsl.query.SingleValueQuery;

public class Equals
extends EsqlBinaryComparison
implements Negatable<EsqlBinaryComparison> {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Equals", EsqlBinaryComparison::readFrom);
    private static final Map<DataType, EsqlArithmeticOperation.BinaryEvaluator> evaluatorMap = Map.ofEntries(Map.entry(DataType.BOOLEAN, EqualsBoolsEvaluator.Factory::new), Map.entry(DataType.INTEGER, EqualsIntsEvaluator.Factory::new), Map.entry(DataType.DOUBLE, EqualsDoublesEvaluator.Factory::new), Map.entry(DataType.LONG, EqualsLongsEvaluator.Factory::new), Map.entry(DataType.UNSIGNED_LONG, EqualsLongsEvaluator.Factory::new), Map.entry(DataType.DATETIME, EqualsLongsEvaluator.Factory::new), Map.entry(DataType.DATE_NANOS, EqualsLongsEvaluator.Factory::new), Map.entry(DataType.GEO_POINT, EqualsGeometriesEvaluator.Factory::new), Map.entry(DataType.CARTESIAN_POINT, EqualsGeometriesEvaluator.Factory::new), Map.entry(DataType.GEO_SHAPE, EqualsGeometriesEvaluator.Factory::new), Map.entry(DataType.CARTESIAN_SHAPE, EqualsGeometriesEvaluator.Factory::new), Map.entry(DataType.GEOHASH, EqualsLongsEvaluator.Factory::new), Map.entry(DataType.GEOTILE, EqualsLongsEvaluator.Factory::new), Map.entry(DataType.GEOHEX, EqualsLongsEvaluator.Factory::new), Map.entry(DataType.KEYWORD, EqualsKeywordsEvaluator.Factory::new), Map.entry(DataType.TEXT, EqualsKeywordsEvaluator.Factory::new), Map.entry(DataType.VERSION, EqualsKeywordsEvaluator.Factory::new), Map.entry(DataType.IP, EqualsKeywordsEvaluator.Factory::new));

    @FunctionInfo(operator="==", returnType={"boolean"}, description="Check if two fields are equal. If either field is <<esql-multivalued-fields,multivalued>> then the result is `null`.", note="This is pushed to the underlying search index if one side of the comparison is constant and the other side is a field in the index that has both an <<mapping-index>> and <<doc-values>>.")
    public Equals(Source source, @Param(name="lhs", type={"boolean", "cartesian_point", "cartesian_shape", "date", "double", "geo_point", "geo_shape", "geohash", "geotile", "geohex", "integer", "ip", "keyword", "long", "text", "unsigned_long", "version"}, description="An expression.") Expression left, @Param(name="rhs", type={"boolean", "cartesian_point", "cartesian_shape", "date", "double", "geo_point", "geo_shape", "geohash", "geotile", "geohex", "integer", "ip", "keyword", "long", "text", "unsigned_long", "version"}, description="An expression.") Expression right) {
        super(source, left, right, EsqlBinaryComparison.BinaryComparisonOperation.EQ, evaluatorMap, EqualsNanosMillisEvaluator.Factory::new, EqualsMillisNanosEvaluator.Factory::new);
    }

    public Equals(Source source, Expression left, Expression right, ZoneId zoneId) {
        super(source, left, right, EsqlBinaryComparison.BinaryComparisonOperation.EQ, zoneId, evaluatorMap, EqualsNanosMillisEvaluator.Factory::new, EqualsMillisNanosEvaluator.Factory::new);
    }

    @Override
    public TranslationAware.Translatable translatable(LucenePushdownPredicates pushdownPredicates) {
        Expression expression = this.right();
        if (expression instanceof Literal) {
            FieldAttribute fa;
            Expression expression2;
            Literal lit = (Literal)expression;
            if (this.left().dataType() == DataType.TEXT && (expression2 = this.left()) instanceof FieldAttribute && pushdownPredicates.canUseEqualityOnSyntheticSourceDelegate(fa = (FieldAttribute)expression2, ((BytesRef)lit.value()).utf8ToString())) {
                return TranslationAware.Translatable.YES_BUT_RECHECK_NEGATED;
            }
        }
        return super.translatable(pushdownPredicates);
    }

    @Override
    public Query asQuery(LucenePushdownPredicates pushdownPredicates, TranslatorHandler handler) {
        Expression expression = this.right();
        if (expression instanceof Literal) {
            String value;
            FieldAttribute fa;
            Expression expression2;
            Literal lit = (Literal)expression;
            if (this.left().dataType() == DataType.TEXT && (expression2 = this.left()) instanceof FieldAttribute && pushdownPredicates.canUseEqualityOnSyntheticSourceDelegate(fa = (FieldAttribute)expression2, value = ((BytesRef)lit.value()).utf8ToString())) {
                String name = handler.nameOf((Expression)fa);
                return new SingleValueQuery((Query)new EqualsSyntheticSourceDelegate(this.source(), name, value), name, true);
            }
        }
        return super.asQuery(pushdownPredicates, handler);
    }

    public String getWriteableName() {
        return Equals.ENTRY.name;
    }

    protected NodeInfo<Equals> info() {
        return NodeInfo.create((Node)this, Equals::new, (Object)this.left(), (Object)this.right(), (Object)this.zoneId());
    }

    protected Equals replaceChildren(Expression newLeft, Expression newRight) {
        return new Equals(this.source(), newLeft, newRight, this.zoneId());
    }

    public Equals swapLeftAndRight() {
        return new Equals(this.source(), this.right(), this.left(), this.zoneId());
    }

    public EsqlBinaryComparison reverse() {
        return this;
    }

    public EsqlBinaryComparison negate() {
        return new NotEquals(this.source(), this.left(), this.right(), this.zoneId());
    }

    static boolean processInts(int lhs, int rhs) {
        return lhs == rhs;
    }

    static boolean processLongs(long lhs, long rhs) {
        return lhs == rhs;
    }

    static boolean processMillisNanos(long lhs, long rhs) {
        return DateUtils.compareNanosToMillis((long)rhs, (long)lhs) == 0;
    }

    static boolean processNanosMillis(long lhs, long rhs) {
        return DateUtils.compareNanosToMillis((long)lhs, (long)rhs) == 0;
    }

    static boolean processDoubles(double lhs, double rhs) {
        return lhs == rhs;
    }

    static boolean processKeywords(BytesRef lhs, BytesRef rhs) {
        return lhs.equals((Object)rhs);
    }

    static boolean processBools(boolean lhs, boolean rhs) {
        return lhs == rhs;
    }

    static boolean processGeometries(BytesRef lhs, BytesRef rhs) {
        return lhs.equals((Object)rhs);
    }
}

