/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.multivalue;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.AbstractMultivalueFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvSum;

public final class MvSumIntEvaluator
extends AbstractMultivalueFunction.AbstractNullableEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(MvSumIntEvaluator.class);
    private final Source source;
    private Warnings warnings;

    public MvSumIntEvaluator(Source source, EvalOperator.ExpressionEvaluator field, DriverContext driverContext) {
        super(driverContext, field);
        this.source = source;
    }

    @Override
    public String name() {
        return "MvSum";
    }

    @Override
    public Block evalNullable(Block fieldVal) {
        IntBlock v = (IntBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (IntBlock.Builder builder = this.driverContext.blockFactory().newIntBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                if (valueCount == 0) {
                    builder.appendNull();
                    continue;
                }
                try {
                    int first = v.getFirstValueIndex(p);
                    int end = first + valueCount;
                    int value = v.getInt(first);
                    for (int i = first + 1; i < end; ++i) {
                        int next = v.getInt(i);
                        value = MvSum.process(value, next);
                    }
                    int result = value;
                    builder.appendInt(result);
                    continue;
                }
                catch (ArithmeticException e) {
                    this.warnings().registerException((Exception)e);
                    builder.appendNull();
                }
            }
            IntBlock intBlock = builder.build();
            return intBlock;
        }
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    public long baseRamBytesUsed() {
        return BASE_RAM_BYTES_USED + this.field.baseRamBytesUsed();
    }

    public static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory field;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory field) {
            this.source = source;
            this.field = field;
        }

        public MvSumIntEvaluator get(DriverContext context) {
            return new MvSumIntEvaluator(this.source, this.field.get(context), context);
        }

        public String toString() {
            return "MvSum[field=" + String.valueOf(this.field) + "]";
        }
    }
}

