/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.AggregateMetricDoubleBlock;
import org.elasticsearch.compute.data.AggregateMetricDoubleBlockBuilder;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ConvertFunction;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;

public class FromAggregateMetricDouble
extends EsqlScalarFunction
implements ConvertFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "FromAggregateMetricDouble", FromAggregateMetricDouble::new);
    private final Expression field;
    private final Expression subfieldIndex;

    @FunctionInfo(returnType={"long", "double"}, description="Convert aggregate double metric to a block of a single subfield.")
    public FromAggregateMetricDouble(Source source, @Param(name="aggregate_metric_double", type={"aggregate_metric_double"}, description="Aggregate double metric to convert.") Expression field, @Param(name="subfieldIndex", type={"int"}, description="Index of subfield") Expression subfieldIndex) {
        super(source, List.of(field, subfieldIndex));
        this.field = field;
        this.subfieldIndex = subfieldIndex;
    }

    public static FromAggregateMetricDouble withMetric(Source source, Expression field, AggregateMetricDoubleBlockBuilder.Metric metric) {
        return new FromAggregateMetricDouble(source, field, (Expression)new Literal(source, (Object)metric.getIndex(), DataType.INTEGER));
    }

    private FromAggregateMetricDouble(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.field);
        out.writeNamedWriteable((NamedWriteable)this.subfieldIndex);
    }

    public String getWriteableName() {
        return FromAggregateMetricDouble.ENTRY.name;
    }

    public DataType dataType() {
        if (!this.subfieldIndex.foldable()) {
            throw new EsqlIllegalArgumentException("Received a non-foldable value for subfield index");
        }
        Object folded = this.subfieldIndex.fold(FoldContext.small());
        if (folded == null) {
            return DataType.NULL;
        }
        int subfield = ((Number)folded).intValue();
        if (subfield == AggregateMetricDoubleBlockBuilder.Metric.COUNT.getIndex()) {
            return DataType.INTEGER;
        }
        return DataType.DOUBLE;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new FromAggregateMetricDouble(this.source(), newChildren.get(0), newChildren.get(1));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, FromAggregateMetricDouble::new, (Object)this.field, (Object)this.subfieldIndex);
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        return TypeResolutions.isType((Expression)this.field, dt -> dt == DataType.AGGREGATE_METRIC_DOUBLE, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.DEFAULT, (String[])new String[]{"aggregate_metric_double only"});
    }

    public boolean foldable() {
        return Expressions.foldable((List)this.children());
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        final EvalOperator.ExpressionEvaluator.Factory fieldEvaluator = toEvaluator.apply(this.field);
        return new EvalOperator.ExpressionEvaluator.Factory(){

            public String toString() {
                return "FromAggregateMetricDoubleEvaluator[field=" + String.valueOf(fieldEvaluator) + ",subfieldIndex=" + String.valueOf(FromAggregateMetricDouble.this.subfieldIndex) + "]";
            }

            public EvalOperator.ExpressionEvaluator get(DriverContext context) {
                EvalOperator.ExpressionEvaluator eval = fieldEvaluator.get(context);
                int subFieldIndex = ((Number)FromAggregateMetricDouble.this.subfieldIndex.fold(FoldContext.small())).intValue();
                return new Evaluator(context.blockFactory(), eval, subFieldIndex);
            }
        };
    }

    @Override
    public Expression field() {
        return this.field;
    }

    @Override
    public Set<DataType> supportedTypes() {
        return Set.of(DataType.AGGREGATE_METRIC_DOUBLE);
    }

    private record Evaluator(BlockFactory blockFactory, EvalOperator.ExpressionEvaluator eval, int subFieldIndex) implements EvalOperator.ExpressionEvaluator
    {
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(Evaluator.class);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Block eval(Page page) {
            Block block = this.eval.eval(page);
            if (block.areAllValuesNull()) {
                return block;
            }
            try {
                Block resultBlock = ((AggregateMetricDoubleBlock)block).getMetricBlock(this.subFieldIndex);
                resultBlock.incRef();
                Block block2 = resultBlock;
                return block2;
            }
            finally {
                block.close();
            }
        }

        public long baseRamBytesUsed() {
            return BASE_RAM_BYTES_USED + this.eval.baseRamBytesUsed();
        }

        public void close() {
            Releasables.closeExpectNoException((Releasable)this.eval);
        }

        @Override
        public String toString() {
            return "FromAggregateMetricDoubleEvaluator[field=" + String.valueOf(this.eval) + ",subfieldIndex=" + this.subFieldIndex + "]";
        }
    }
}

