/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.fulltext;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.ScoreOperator;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.function.Function;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesTo;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesToLifecycle;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.score.ScoreMapper;

public class Score
extends Function
implements EvaluatorMapper {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "score", Score::readFrom);
    public static final String NAME = "score";

    @FunctionInfo(returnType={"double"}, preview=true, appliesTo={@FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.DEVELOPMENT)}, description="Scores an expression. Only full text functions will be scored. Returns scores for all the resulting docs.", examples={@Example(file="score-function", tag="score-function")})
    public Score(Source source, @Param(name="query", type={"boolean"}, description="Boolean expression that contains full text function(s) to be scored.") Expression scorableQuery) {
        this(source, List.of(scorableQuery));
    }

    protected Score(Source source, List<Expression> children) {
        super(source, children);
    }

    public DataType dataType() {
        return DataType.DOUBLE;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new Score(this.source(), newChildren);
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Score::new, (Object)((Expression)this.children().getFirst()));
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        ScoreOperator.ExpressionScorer.Factory scorerFactory = ScoreMapper.toScorer((Expression)this.children().getFirst(), toEvaluator.shardContexts());
        return driverContext -> new ScorerEvaluatorFactory(scorerFactory).get(driverContext);
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteableCollection((Collection)this.children());
    }

    private static Expression readFrom(StreamInput in) throws IOException {
        Source source = Source.readFrom((StreamInput)((PlanStreamInput)in));
        Expression query = (Expression)in.readOptionalNamedWriteable(Expression.class);
        return new Score(source, query);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Score score = (Score)o;
        return super.equals(o) && score.children().equals(this.children());
    }

    public int hashCode() {
        return Objects.hash(this.children());
    }

    private record ScorerEvaluatorFactory(ScoreOperator.ExpressionScorer.Factory scoreFactory) implements EvalOperator.ExpressionEvaluator.Factory
    {
        public EvalOperator.ExpressionEvaluator get(DriverContext context) {
            return new ScorerEvaluator(this.scoreFactory.get(context));
        }
    }

    private record ScorerEvaluator(ScoreOperator.ExpressionScorer scorer) implements EvalOperator.ExpressionEvaluator
    {
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(ScorerEvaluator.class);

        public Block eval(Page page) {
            return this.scorer.score(page);
        }

        public long baseRamBytesUsed() {
            return BASE_RAM_BYTES_USED;
        }

        public void close() {
            this.scorer.close();
        }
    }
}

