/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesTo;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesToLifecycle;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.FunctionType;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Min;
import org.elasticsearch.xpack.esql.expression.function.aggregate.TimeSeriesAggregateFunction;

public class MinOverTime
extends TimeSeriesAggregateFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "MinOverTime", MinOverTime::new);

    @FunctionInfo(returnType={"boolean", "double", "integer", "long", "date", "date_nanos", "ip", "keyword", "unsigned_long", "version"}, description="Calculates the minimum over time value of a field.", type=FunctionType.TIME_SERIES_AGGREGATE, appliesTo={@FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.PREVIEW, version="9.2.0")}, preview=true, examples={@Example(file="k8s-timeseries", tag="min_over_time")})
    public MinOverTime(Source source, @Param(name="field", type={"aggregate_metric_double", "boolean", "double", "integer", "long", "date", "date_nanos", "ip", "keyword", "text", "unsigned_long", "version"}) Expression field) {
        this(source, field, (Expression)Literal.TRUE);
    }

    public MinOverTime(Source source, Expression field, Expression filter) {
        super(source, field, filter, Collections.emptyList());
    }

    private MinOverTime(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return MinOverTime.ENTRY.name;
    }

    @Override
    public MinOverTime withFilter(Expression filter) {
        return new MinOverTime(this.source(), this.field(), filter);
    }

    protected NodeInfo<MinOverTime> info() {
        return NodeInfo.create((Node)this, MinOverTime::new, (Object)this.field(), (Object)this.filter());
    }

    public MinOverTime replaceChildren(List<Expression> newChildren) {
        return new MinOverTime(this.source(), newChildren.get(0), newChildren.get(1));
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return this.perTimeSeriesAggregation().resolveType();
    }

    public DataType dataType() {
        return this.perTimeSeriesAggregation().dataType();
    }

    @Override
    public Min perTimeSeriesAggregation() {
        return new Min(this.source(), this.field(), this.filter());
    }
}

