/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.FirstDoubleByTimestampAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.FirstFloatByTimestampAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.FirstIntByTimestampAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.FirstLongByTimestampAggregatorFunctionSupplier;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.expression.UnresolvedAttribute;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesTo;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesToLifecycle;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.FunctionType;
import org.elasticsearch.xpack.esql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.aggregate.TimeSeriesAggregateFunction;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.planner.ToAggregator;

public class FirstOverTime
extends TimeSeriesAggregateFunction
implements OptionalArgument,
ToAggregator {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "FirstOverTime", FirstOverTime::new);
    private final Expression timestamp;

    @FunctionInfo(type=FunctionType.TIME_SERIES_AGGREGATE, returnType={"long", "integer", "double"}, description="Calculates the earliest value of a field, where recency determined by the `@timestamp` field.", appliesTo={@FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.PREVIEW, version="9.2.0")}, preview=true, examples={@Example(file="k8s-timeseries", tag="first_over_time")})
    public FirstOverTime(Source source, @Param(name="field", type={"counter_long", "counter_integer", "counter_double", "long", "integer", "double"}) Expression field) {
        this(source, field, (Expression)new UnresolvedAttribute(source, "@timestamp"));
    }

    public FirstOverTime(Source source, Expression field, Expression timestamp) {
        this(source, field, (Expression)Literal.TRUE, timestamp);
    }

    private FirstOverTime(Source source, Expression field, Expression filter, List<Expression> children) {
        this(source, field, filter, children.getFirst());
    }

    private FirstOverTime(Source source, Expression field, Expression filter, Expression timestamp) {
        super(source, field, filter, List.of(timestamp));
        this.timestamp = timestamp;
    }

    public FirstOverTime(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class), in.readNamedWriteableCollectionAsList(Expression.class));
    }

    public String getWriteableName() {
        return FirstOverTime.ENTRY.name;
    }

    protected NodeInfo<FirstOverTime> info() {
        return NodeInfo.create((Node)this, FirstOverTime::new, (Object)this.field(), (Object)this.timestamp);
    }

    public FirstOverTime replaceChildren(List<Expression> newChildren) {
        if (newChildren.size() != 3) {
            assert (false) : "expected 3 children for field, filter, @timestamp; got " + String.valueOf(newChildren);
            throw new IllegalArgumentException("expected 3 children for field, filter, @timestamp; got " + String.valueOf(newChildren));
        }
        return new FirstOverTime(this.source(), newChildren.get(0), newChildren.get(1), newChildren.get(2));
    }

    @Override
    public FirstOverTime withFilter(Expression filter) {
        return new FirstOverTime(this.source(), this.field(), filter, this.timestamp);
    }

    public DataType dataType() {
        return this.field().dataType().noCounter();
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return TypeResolutions.isType((Expression)this.field(), dt -> dt.noCounter().isNumeric() && dt != DataType.UNSIGNED_LONG || dt == DataType.AGGREGATE_METRIC_DOUBLE, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.DEFAULT, (String[])new String[]{"numeric except unsigned_long"}).and(TypeResolutions.isType((Expression)this.timestamp, dt -> dt == DataType.DATETIME || dt == DataType.DATE_NANOS, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND, (String[])new String[]{"date_nanos or datetime"}));
    }

    @Override
    public AggregatorFunctionSupplier supplier() {
        DataType type = this.field().dataType();
        return switch (type) {
            case DataType.LONG, DataType.COUNTER_LONG -> new FirstLongByTimestampAggregatorFunctionSupplier();
            case DataType.INTEGER, DataType.COUNTER_INTEGER -> new FirstIntByTimestampAggregatorFunctionSupplier();
            case DataType.DOUBLE, DataType.COUNTER_DOUBLE -> new FirstDoubleByTimestampAggregatorFunctionSupplier();
            case DataType.FLOAT -> new FirstFloatByTimestampAggregatorFunctionSupplier();
            default -> throw EsqlIllegalArgumentException.illegalDataType(type);
        };
    }

    @Override
    public FirstOverTime perTimeSeriesAggregation() {
        return this;
    }

    public String toString() {
        return "first_over_time(" + String.valueOf(this.field()) + ")";
    }

    Expression timestamp() {
        return this.timestamp;
    }
}

