/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.streams.logs;

import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.local.TransportLocalProjectMetadataAction;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.StreamsMetadata;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.rest.streams.logs.StreamsStatusAction;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportStreamsStatusAction
extends TransportLocalProjectMetadataAction<StreamsStatusAction.Request, StreamsStatusAction.Response> {
    @Inject
    public TransportStreamsStatusAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, ProjectResolver projectResolver) {
        super(StreamsStatusAction.INSTANCE.name(), actionFilters, transportService.getTaskManager(), clusterService, (Executor)threadPool.executor("management"), projectResolver);
    }

    protected ClusterBlockException checkBlock(StreamsStatusAction.Request request, ProjectState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    protected void localClusterStateOperation(Task task, StreamsStatusAction.Request request, ProjectState state, ActionListener<StreamsStatusAction.Response> listener) {
        StreamsMetadata streamsState = (StreamsMetadata)state.metadata().custom("streams", (Metadata.ProjectCustom)StreamsMetadata.EMPTY);
        boolean logsEnabled = streamsState.isLogsEnabled();
        StreamsStatusAction.Response response = new StreamsStatusAction.Response(logsEnabled);
        listener.onResponse((Object)response);
    }
}

