/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.streams.logs;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestCancellableNodeClient;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.rest.streams.logs.StreamsStatusAction;

@ServerlessScope(value=Scope.PUBLIC)
public class RestStreamsStatusAction
extends BaseRestHandler {
    public static final Set<String> SUPPORTED_PARAMS = Collections.singleton("master_timeout");

    public String getName() {
        return "streams_status_action";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_streams/status"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) {
        StreamsStatusAction.Request statusRequest = new StreamsStatusAction.Request(RestUtils.getMasterNodeTimeout((RestRequest)request));
        return restChannel -> new RestCancellableNodeClient(client, request.getHttpChannel()).execute(StreamsStatusAction.INSTANCE, (ActionRequest)statusRequest, (ActionListener)new RestToXContentListener(restChannel));
    }

    public Set<String> supportedQueryParameters() {
        return SUPPORTED_PARAMS;
    }
}

