/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.transforms.latest;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.core.transform.transforms.TransformCheckpoint;
import org.elasticsearch.xpack.transform.transforms.Function;

class LatestChangeCollector
implements Function.ChangeCollector {
    private final String synchronizationField;

    LatestChangeCollector(String synchronizationField) {
        this.synchronizationField = Objects.requireNonNull(synchronizationField);
    }

    @Override
    public SearchSourceBuilder buildChangesQuery(SearchSourceBuilder searchSourceBuilder, Map<String, Object> position, int pageSize) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, Object> processSearchResponse(SearchResponse searchResponse) {
        throw new UnsupportedOperationException();
    }

    @Override
    public QueryBuilder buildFilterQuery(TransformCheckpoint lastCheckpoint, TransformCheckpoint nextCheckpoint) {
        return QueryBuilders.rangeQuery((String)this.synchronizationField).gte((Object)lastCheckpoint.getTimeUpperBound()).lt((Object)nextCheckpoint.getTimeUpperBound()).format("epoch_millis");
    }

    @Override
    public Collection<String> getIndicesToQuery(TransformCheckpoint lastCheckpoint, TransformCheckpoint nextCheckpoint) {
        return TransformCheckpoint.getChangedIndices((TransformCheckpoint)TransformCheckpoint.EMPTY, (TransformCheckpoint)nextCheckpoint);
    }

    @Override
    public void clear() {
    }

    @Override
    public boolean isOptimized() {
        return true;
    }

    @Override
    public boolean queryForChanges() {
        return false;
    }
}

