/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.checkpoint;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.transport.LinkedProjectConfig;
import org.elasticsearch.transport.LinkedProjectConfigService;
import org.elasticsearch.transport.RemoteClusterAware;

class RemoteClusterResolver
extends RemoteClusterAware {
    private final CopyOnWriteArraySet<String> clusters;

    RemoteClusterResolver(Settings settings, LinkedProjectConfigService linkedProjectConfigService) {
        super(settings);
        this.clusters = new CopyOnWriteArraySet<String>(linkedProjectConfigService.getInitialLinkedProjectConfigs().stream().map(LinkedProjectConfig::linkedProjectAlias).toList());
        linkedProjectConfigService.register((LinkedProjectConfigService.LinkedProjectConfigListener)this);
    }

    public void updateLinkedProject(LinkedProjectConfig config) {
        if (config.isConnectionEnabled()) {
            this.clusters.add(config.linkedProjectAlias());
        } else {
            this.clusters.remove(config.linkedProjectAlias());
        }
    }

    ResolvedIndices resolve(String ... indices) {
        Map resolvedClusterIndices = this.groupClusterIndices(this.clusters, indices);
        List<String> localIndices = resolvedClusterIndices.getOrDefault("", Collections.emptyList());
        resolvedClusterIndices.remove("");
        return new ResolvedIndices(resolvedClusterIndices, localIndices);
    }

    static class ResolvedIndices {
        private final Map<String, List<String>> remoteIndicesPerClusterAlias;
        private final List<String> localIndices;

        ResolvedIndices(Map<String, List<String>> remoteIndicesPerClusterAlias, List<String> localIndices) {
            this.localIndices = localIndices;
            this.remoteIndicesPerClusterAlias = remoteIndicesPerClusterAlias;
        }

        Map<String, List<String>> getRemoteIndicesPerClusterAlias() {
            return this.remoteIndicesPerClusterAlias;
        }

        List<String> getLocalIndices() {
            return this.localIndices;
        }

        int numClusters() {
            return this.remoteIndicesPerClusterAlias.size() + (this.localIndices.isEmpty() ? 0 : 1);
        }
    }
}

