/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform;

import java.util.Optional;
import java.util.function.Supplier;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNodes;

public class TransformNode {
    private final Supplier<Optional<ClusterState>> clusterState;

    public TransformNode(Supplier<Optional<ClusterState>> clusterState) {
        this.clusterState = clusterState;
    }

    public Optional<Boolean> isShuttingDown() {
        return this.clusterState.get().map(state -> {
            String localId = state.nodes().getLocalNodeId();
            if (localId != null) {
                return state.metadata().nodeShutdowns().contains(localId);
            }
            return null;
        });
    }

    public String nodeId() {
        return this.clusterState.get().map(ClusterState::nodes).map(DiscoveryNodes::getLocalNodeId).orElse("null");
    }
}

