/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform;

import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.transform.TransformField;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;
import org.elasticsearch.xpack.transform.notifications.TransformAuditor;
import org.elasticsearch.xpack.transform.persistence.SeqNoPrimaryTermAndIndex;
import org.elasticsearch.xpack.transform.persistence.TransformConfigManager;
import org.elasticsearch.xpack.transform.telemetry.TransformMeterRegistry;

public class TransformConfigAutoMigration {
    private static final Logger logger = LogManager.getLogger(TransformConfigAutoMigration.class);
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(TransformConfigAutoMigration.class);
    private final TransformConfigManager transformConfigManager;
    private final TransformAuditor auditor;
    private final TransformMeterRegistry transformMeterRegistry;
    private final ThreadPool threadPool;

    TransformConfigAutoMigration(TransformConfigManager transformConfigManager, TransformAuditor auditor, TransformMeterRegistry transformMeterRegistry, ThreadPool threadPool) {
        this.transformConfigManager = transformConfigManager;
        this.auditor = auditor;
        this.transformMeterRegistry = transformMeterRegistry;
        this.threadPool = threadPool;
    }

    public TransformConfig migrate(TransformConfig currentConfig) {
        if (!currentConfig.shouldAutoMigrateMaxPageSearchSize()) {
            return currentConfig;
        }
        TransformConfig updatedConfig = TransformConfig.migrateMaxPageSearchSize((TransformConfig.Builder)new TransformConfig.Builder(currentConfig)).build();
        ActionRequestValidationException validationException = updatedConfig.validate(null);
        if (validationException == null) {
            this.auditor.info(updatedConfig.getId(), "Automatically migrating [max_page_search_size] from the pivot to the transform setting.");
            this.transformMeterRegistry.autoMigrationCount().increment();
            deprecationLogger.warn(DeprecationCategory.API, TransformField.MAX_PAGE_SEARCH_SIZE.getPreferredName(), "Automatically migrating [max_page_search_size] from the pivot to the transform setting.", new Object[0]);
            return updatedConfig;
        }
        logger.atDebug().withThrowable((Throwable)validationException).log("Failed to validate auto-migrated Config. Please use the _update API to correct and update the Transform configuration. Continuing with old config.");
        return currentConfig;
    }

    public void migrateAndSave(TransformConfig currentConfig, ActionListener<TransformConfig> listener) {
        if (!currentConfig.shouldAutoMigrateMaxPageSearchSize()) {
            listener.onResponse((Object)currentConfig);
            return;
        }
        SubscribableListener.newForked(l -> this.transformConfigManager.getTransformConfigurationForUpdate(currentConfig.getId(), (ActionListener<Tuple<TransformConfig, SeqNoPrimaryTermAndIndex>>)l)).andThen((Executor)this.threadPool.generic(), this.threadPool.getThreadContext(), (l, configAndVersion) -> {
            TransformConfig updatedConfig = this.migrate((TransformConfig)configAndVersion.v1());
            if (configAndVersion.v1() == updatedConfig) {
                l.onResponse((Object)currentConfig);
            } else {
                this.transformConfigManager.updateTransformConfiguration(updatedConfig, (SeqNoPrimaryTermAndIndex)configAndVersion.v2(), (ActionListener<Boolean>)l.map(ignored -> updatedConfig));
            }
        }).addListener(listener.delegateResponse((l, e) -> {
            String errorMessage = "Failed to auto-migrate Config. Please see Elasticsearch logs. Continuing with old config.";
            logger.atWarn().withThrowable((Throwable)e).log(errorMessage);
            this.auditor.warning(currentConfig.getId(), errorMessage);
            l.onResponse((Object)currentConfig);
        }), (Executor)this.threadPool.generic(), this.threadPool.getThreadContext());
    }
}

