/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.inference.adaptiveallocations;

import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xpack.ml.inference.adaptiveallocations.AdaptiveAllocationsScalerService;
import org.elasticsearch.xpack.ml.inference.adaptiveallocations.KalmanFilter1d;

public class AdaptiveAllocationsScaler {
    static final double SCALE_UP_THRESHOLD = 0.9;
    private static final double SCALE_DOWN_THRESHOLD = 0.85;
    private static final int MAX_NUMBER_OF_ALLOCATIONS_SAFEGUARD = 32;
    private static final Logger logger = LogManager.getLogger(AdaptiveAllocationsScaler.class);
    private final String deploymentId;
    private final KalmanFilter1d requestRateEstimator;
    private final KalmanFilter1d inferenceTimeEstimator;
    private final Supplier<Long> scaleToZeroAfterNoRequestsSeconds;
    private double timeWithoutRequestsSeconds;
    private int numberOfAllocations;
    private int neededNumberOfAllocations;
    private Integer minNumberOfAllocations;
    private Integer maxNumberOfAllocations;
    private boolean dynamicsChanged;
    private Double lastMeasuredRequestRate;
    private Double lastMeasuredInferenceTime;
    private Long lastMeasuredQueueSize;

    AdaptiveAllocationsScaler(String deploymentId, int numberOfAllocations, Supplier<Long> scaleToZeroAfterNoRequestsSeconds) {
        this.deploymentId = deploymentId;
        this.scaleToZeroAfterNoRequestsSeconds = scaleToZeroAfterNoRequestsSeconds;
        this.requestRateEstimator = new KalmanFilter1d(deploymentId + ":rate", 100.0, true);
        this.inferenceTimeEstimator = new KalmanFilter1d(deploymentId + ":time", 100.0, false);
        this.timeWithoutRequestsSeconds = 0.0;
        this.numberOfAllocations = numberOfAllocations;
        this.neededNumberOfAllocations = numberOfAllocations;
        this.minNumberOfAllocations = null;
        this.maxNumberOfAllocations = null;
        this.dynamicsChanged = false;
        this.lastMeasuredRequestRate = null;
        this.lastMeasuredInferenceTime = null;
        this.lastMeasuredQueueSize = null;
    }

    void setMinMaxNumberOfAllocations(Integer minNumberOfAllocations, Integer maxNumberOfAllocations) {
        this.minNumberOfAllocations = minNumberOfAllocations;
        this.maxNumberOfAllocations = maxNumberOfAllocations;
    }

    void process(AdaptiveAllocationsScalerService.Stats stats, double timeIntervalSeconds, int numberOfAllocations) {
        this.lastMeasuredQueueSize = stats.pendingCount();
        this.timeWithoutRequestsSeconds = stats.requestCount() > 0L ? 0.0 : (this.timeWithoutRequestsSeconds += timeIntervalSeconds);
        double requestRate = (double)stats.requestCount() / timeIntervalSeconds;
        double requestRateEstimate = this.requestRateEstimator.hasValue() ? this.requestRateEstimator.estimate() : requestRate;
        double requestRateVariance = Math.max(1.0, requestRateEstimate * timeIntervalSeconds) / Math.pow(timeIntervalSeconds, 2.0);
        this.requestRateEstimator.add(requestRate, requestRateVariance, false);
        this.lastMeasuredRequestRate = requestRate;
        if (stats.requestCount() > 0L && !Double.isNaN(stats.inferenceTime())) {
            double inferenceTime = stats.inferenceTime();
            double inferenceTimeEstimate = this.inferenceTimeEstimator.hasValue() ? this.inferenceTimeEstimator.estimate() : inferenceTime;
            double inferenceTimeVariance = Math.pow(inferenceTimeEstimate, 2.0) / (double)stats.requestCount();
            this.inferenceTimeEstimator.add(inferenceTime, inferenceTimeVariance, this.dynamicsChanged);
            this.lastMeasuredInferenceTime = inferenceTime;
        } else {
            this.lastMeasuredInferenceTime = null;
        }
        this.numberOfAllocations = numberOfAllocations;
        this.dynamicsChanged = false;
    }

    void resetTimeWithoutRequests() {
        this.timeWithoutRequestsSeconds = 0.0;
    }

    double getLoadLower() {
        double requestRateLower = Math.max(0.0, this.requestRateEstimator.lower());
        double inferenceTimeLower = Math.max(0.0, this.inferenceTimeEstimator.hasValue() ? this.inferenceTimeEstimator.lower() : 1.0);
        return requestRateLower * inferenceTimeLower;
    }

    double getLoadUpper() {
        double requestRateUpper = this.requestRateEstimator.upper();
        double inferenceTimeUpper = this.inferenceTimeEstimator.hasValue() ? this.inferenceTimeEstimator.upper() : 1.0;
        return requestRateUpper * inferenceTimeUpper;
    }

    Double getRequestRateEstimate() {
        return this.requestRateEstimator.hasValue() ? Double.valueOf(this.requestRateEstimator.estimate()) : null;
    }

    Double getInferenceTimeEstimate() {
        return this.inferenceTimeEstimator.hasValue() ? Double.valueOf(this.inferenceTimeEstimator.estimate()) : null;
    }

    Integer scale() {
        if (!this.requestRateEstimator.hasValue()) {
            return null;
        }
        int oldNumberOfAllocations = this.numberOfAllocations;
        double loadLower = this.getLoadLower();
        while (loadLower / (double)this.numberOfAllocations > 0.9) {
            ++this.numberOfAllocations;
        }
        double loadUpper = this.getLoadUpper();
        while (this.numberOfAllocations > 1 && loadUpper / (double)(this.numberOfAllocations - 1) < 0.85) {
            --this.numberOfAllocations;
        }
        this.neededNumberOfAllocations = this.numberOfAllocations;
        if (this.maxNumberOfAllocations == null) {
            this.numberOfAllocations = Math.min(this.numberOfAllocations, 32);
        }
        if (this.minNumberOfAllocations != null) {
            this.numberOfAllocations = Math.max(this.numberOfAllocations, this.minNumberOfAllocations);
        }
        if (this.maxNumberOfAllocations != null) {
            this.numberOfAllocations = Math.min(this.numberOfAllocations, this.maxNumberOfAllocations);
        }
        if ((this.minNumberOfAllocations == null || this.minNumberOfAllocations == 0) && this.timeWithoutRequestsSeconds > (double)this.scaleToZeroAfterNoRequestsSeconds.get().longValue()) {
            if (oldNumberOfAllocations != 0) {
                logger.debug("[{}] adaptive allocations scaler: scaling down to zero, because of no requests.", (Object)this.deploymentId);
            }
            this.numberOfAllocations = 0;
            this.neededNumberOfAllocations = 0;
        }
        if (this.numberOfAllocations != oldNumberOfAllocations) {
            logger.debug(() -> Strings.format((String)"[%s] adaptive allocations scaler: load in [%.3f, %.3f], scaling from %d to %d allocations.", (Object[])new Object[]{this.deploymentId, loadLower, loadUpper, oldNumberOfAllocations, this.numberOfAllocations}));
        } else {
            logger.debug(() -> Strings.format((String)"[%s] adaptive allocations scaler: load in [%.3f, %.3f], keeping %d allocations.", (Object[])new Object[]{this.deploymentId, loadLower, loadUpper, this.numberOfAllocations}));
        }
        if (this.numberOfAllocations != oldNumberOfAllocations) {
            this.dynamicsChanged = true;
            return this.numberOfAllocations;
        }
        return null;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public long getNumberOfAllocations() {
        return this.numberOfAllocations;
    }

    public long getNeededNumberOfAllocations() {
        return this.neededNumberOfAllocations;
    }

    public Double getLastMeasuredRequestRate() {
        return this.lastMeasuredRequestRate;
    }

    public Double getLastMeasuredInferenceTime() {
        return this.lastMeasuredInferenceTime;
    }

    public Long getLastMeasuredQueueSize() {
        return this.lastMeasuredQueueSize;
    }

    public Integer getMinNumberOfAllocations() {
        return this.minNumberOfAllocations;
    }

    public Integer getMaxNumberOfAllocations() {
        return this.maxNumberOfAllocations;
    }
}

