/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.action.AbstractTransportSetResetModeAction;
import org.elasticsearch.xpack.core.action.SetResetModeActionRequest;
import org.elasticsearch.xpack.core.ml.MlMetadata;

public class TransportSetResetModeAction
extends AbstractTransportSetResetModeAction {
    @Inject
    public TransportSetResetModeAction(TransportService transportService, ThreadPool threadPool, ClusterService clusterService, ActionFilters actionFilters) {
        super("cluster:internal/xpack/ml/reset_mode", transportService, threadPool, clusterService, actionFilters);
    }

    protected boolean isResetMode(ClusterState clusterState) {
        return MlMetadata.getMlMetadata((ClusterState)clusterState).isResetMode();
    }

    protected String featureName() {
        return "ml";
    }

    protected ClusterState setState(ClusterState oldState, SetResetModeActionRequest request) {
        ProjectMetadata project = oldState.metadata().getDefaultProject();
        ProjectMetadata.Builder projectBuilder = ProjectMetadata.builder((ProjectMetadata)project);
        if (request.shouldDeleteMetadata()) {
            assert (!request.isEnabled());
            projectBuilder.removeCustom("ml").removeCustom("trained_model_alias");
        } else {
            MlMetadata.Builder builder = MlMetadata.Builder.from((MlMetadata)((MlMetadata)project.custom("ml"))).isResetMode(request.isEnabled());
            projectBuilder.putCustom("ml", (Metadata.ProjectCustom)builder.build());
        }
        return ClusterState.builder((ClusterState)oldState).putProjectMetadata(projectBuilder.build()).build();
    }
}

