/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.action.AbstractGetResourcesRequest;
import org.elasticsearch.xpack.core.action.AbstractTransportGetResourcesAction;
import org.elasticsearch.xpack.core.ml.MlConfigIndex;
import org.elasticsearch.xpack.core.ml.action.GetDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class TransportGetDataFrameAnalyticsAction
extends AbstractTransportGetResourcesAction<DataFrameAnalyticsConfig, GetDataFrameAnalyticsAction.Request, GetDataFrameAnalyticsAction.Response> {
    private final ClusterService clusterService;

    @Inject
    public TransportGetDataFrameAnalyticsAction(TransportService transportService, ActionFilters actionFilters, Client client, ClusterService clusterService, NamedXContentRegistry xContentRegistry) {
        super("cluster:monitor/xpack/ml/data_frame/analytics/get", transportService, actionFilters, GetDataFrameAnalyticsAction.Request::new, client, xContentRegistry);
        this.clusterService = clusterService;
    }

    protected ParseField getResultsField() {
        return GetDataFrameAnalyticsAction.Response.RESULTS_FIELD;
    }

    protected String[] getIndices() {
        return new String[]{MlConfigIndex.indexName()};
    }

    protected DataFrameAnalyticsConfig parse(XContentParser parser) {
        return ((DataFrameAnalyticsConfig.Builder)DataFrameAnalyticsConfig.LENIENT_PARSER.apply(parser, null)).build();
    }

    protected ResourceNotFoundException notFoundException(String resourceId) {
        return ExceptionsHelper.missingDataFrameAnalytics((String)resourceId);
    }

    protected void doExecute(Task task, GetDataFrameAnalyticsAction.Request request, ActionListener<GetDataFrameAnalyticsAction.Response> listener) {
        this.searchResources((AbstractGetResourcesRequest)request, new TaskId(this.clusterService.localNode().getId(), task.getId()), listener.delegateFailureAndWrap((l, queryPage) -> l.onResponse((Object)new GetDataFrameAnalyticsAction.Response(queryPage))));
    }

    @Nullable
    protected QueryBuilder additionalQuery() {
        return QueryBuilders.termQuery((String)DataFrameAnalyticsConfig.CONFIG_TYPE.getPreferredName(), (String)"data_frame_analytics_config");
    }

    protected String executionOrigin() {
        return "ml";
    }

    protected String extractIdFromResource(DataFrameAnalyticsConfig config) {
        return config.getId();
    }
}

