/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.reindex;

import java.util.Arrays;
import java.util.List;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.apache.lucene.util.automaton.Operations;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.AutoCreateIndex;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.reindex.ReindexRequest;
import org.elasticsearch.index.reindex.RemoteInfo;
import org.elasticsearch.reindex.TransportReindexAction;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.transport.RemoteClusterAware;

public class ReindexValidator {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(ReindexValidator.class);
    static final String SORT_DEPRECATED_MESSAGE = "The sort option in reindex is deprecated. Instead consider using query filtering to find the desired subset of data.";
    private final CharacterRunAutomaton remoteWhitelist;
    private final ClusterService clusterService;
    private final IndexNameExpressionResolver indexResolver;
    private final ProjectResolver projectResolver;
    private final AutoCreateIndex autoCreateIndex;

    ReindexValidator(Settings settings, ClusterService clusterService, IndexNameExpressionResolver indexResolver, ProjectResolver projectResolver, AutoCreateIndex autoCreateIndex) {
        this.remoteWhitelist = ReindexValidator.buildRemoteWhitelist((List)TransportReindexAction.REMOTE_CLUSTER_WHITELIST.get(settings));
        this.clusterService = clusterService;
        this.indexResolver = indexResolver;
        this.projectResolver = projectResolver;
        this.autoCreateIndex = autoCreateIndex;
    }

    public void initialValidation(ReindexRequest request) {
        ReindexValidator.checkRemoteWhitelist(this.remoteWhitelist, request.getRemoteInfo());
        ClusterState state = this.clusterService.state();
        ReindexValidator.validateAgainstAliases(request.getSearchRequest(), request.getDestination(), request.getRemoteInfo(), this.indexResolver, this.autoCreateIndex, this.projectResolver.getProjectMetadata(state));
        SearchSourceBuilder searchSource = request.getSearchRequest().source();
        if (searchSource != null && searchSource.sorts() != null && !searchSource.sorts().isEmpty()) {
            deprecationLogger.warn(DeprecationCategory.API, "reindex_sort", SORT_DEPRECATED_MESSAGE, new Object[0]);
        }
    }

    static void checkRemoteWhitelist(CharacterRunAutomaton whitelist, RemoteInfo remoteInfo) {
        if (remoteInfo == null) {
            return;
        }
        String check = remoteInfo.getHost() + ":" + remoteInfo.getPort();
        if (whitelist.run(check)) {
            return;
        }
        String whiteListKey = TransportReindexAction.REMOTE_CLUSTER_WHITELIST.getKey();
        throw new IllegalArgumentException("[" + check + "] not whitelisted in " + whiteListKey);
    }

    static CharacterRunAutomaton buildRemoteWhitelist(List<String> whitelist) {
        if (whitelist.isEmpty()) {
            return new CharacterRunAutomaton(Automata.makeEmpty());
        }
        Automaton automaton = Regex.simpleMatchToAutomaton((String[])whitelist.toArray(Strings.EMPTY_ARRAY));
        automaton = Operations.determinize((Automaton)automaton, (int)10000);
        return new CharacterRunAutomaton(automaton);
    }

    static void validateAgainstAliases(SearchRequest source, IndexRequest destination, RemoteInfo remoteInfo, IndexNameExpressionResolver indexNameExpressionResolver, AutoCreateIndex autoCreateIndex, ProjectMetadata project) {
        String[] sourceIndexNames;
        SearchRequest filteredSource;
        if (remoteInfo != null) {
            return;
        }
        String target = destination.index();
        if (destination.isRequireAlias() && !project.hasAlias(target)) {
            throw new IndexNotFoundException("[require_alias] request flag is [true] and [" + target + "] is not an alias", target);
        }
        if (!autoCreateIndex.shouldAutoCreate(target, project)) {
            target = indexNameExpressionResolver.concreteWriteIndex(project, (IndicesRequest)destination).getName();
        }
        if ((filteredSource = ReindexValidator.skipRemoteIndexNames(source)).indices().length == 0) {
            return;
        }
        for (String sourceIndex : sourceIndexNames = indexNameExpressionResolver.concreteIndexNames(project, (IndicesRequest)filteredSource)) {
            if (!sourceIndex.equals(target)) continue;
            ActionRequestValidationException e = new ActionRequestValidationException();
            e.addValidationError("reindex cannot write into an index its reading from [" + target + "]");
            throw e;
        }
    }

    private static SearchRequest skipRemoteIndexNames(SearchRequest source) {
        return new SearchRequest(source).indices((String[])Arrays.stream(source.indices()).filter(name -> !RemoteClusterAware.isRemoteIndexName((String)name)).toArray(String[]::new));
    }
}

