/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.type;

import org.elasticsearch.Build;
import org.elasticsearch.TransportVersion;

public interface SupportedVersion {
    public static final SupportedVersion SUPPORTED_ON_ALL_NODES = new SupportedVersion(){

        @Override
        public boolean supports(TransportVersion version) {
            return true;
        }

        public String toString() {
            return "SupportedOnAllVersions";
        }
    };
    public static final SupportedVersion UNDER_CONSTRUCTION = new SupportedVersion(){

        @Override
        public boolean supports(TransportVersion version) {
            return Build.current().isSnapshot();
        }

        public String toString() {
            return "UnderConstruction";
        }
    };

    public boolean supports(TransportVersion var1);

    default public boolean supportedLocally() {
        return this.supports(TransportVersion.current());
    }

    public static SupportedVersion supportedOn(final TransportVersion supportedVersion) {
        return new SupportedVersion(){

            @Override
            public boolean supports(TransportVersion version) {
                return version.supports(supportedVersion) || Build.current().isSnapshot();
            }

            public String toString() {
                return "SupportedOn[" + String.valueOf(supportedVersion) + "]";
            }
        };
    }
}

