/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.system_indices.task;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequestBuilder;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.readonly.AddIndexBlockRequest;
import org.elasticsearch.action.admin.indices.settings.put.TransportUpdateSettingsAction;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.ParentTaskAssigningClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.MetadataIndexTemplateService;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.ReindexAction;
import org.elasticsearch.index.reindex.ReindexRequest;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.persistent.AllocatedPersistentTask;
import org.elasticsearch.script.Script;
import org.elasticsearch.system_indices.task.MigrationResultsUpdateTask;
import org.elasticsearch.system_indices.task.SingleFeatureMigrationResult;
import org.elasticsearch.system_indices.task.SystemDataStreamMigrationInfo;
import org.elasticsearch.system_indices.task.SystemIndexMigrationInfo;
import org.elasticsearch.system_indices.task.SystemIndexMigrationTaskState;
import org.elasticsearch.system_indices.task.SystemResourceMigrationFactory;
import org.elasticsearch.system_indices.task.SystemResourceMigrationInfo;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xpack.migrate.action.CancelReindexDataStreamAction;
import org.elasticsearch.xpack.migrate.action.GetMigrationReindexStatusAction;
import org.elasticsearch.xpack.migrate.action.ReindexDataStreamAction;
import org.elasticsearch.xpack.migrate.task.ReindexDataStreamEnrichedStatus;

public class SystemIndexMigrator
extends AllocatedPersistentTask {
    private static final Logger logger = LogManager.getLogger(SystemIndexMigrator.class);
    private final ParentTaskAssigningClient baseClient;
    private final ClusterService clusterService;
    private final SystemIndices systemIndices;
    private final IndexScopedSettings indexScopedSettings;
    private final ThreadPool threadPool;
    private final ProjectId projectId;
    private final Queue<SystemResourceMigrationInfo> migrationQueue = new ArrayDeque<SystemResourceMigrationInfo>();
    private final AtomicReference<Map<String, Object>> currentFeatureCallbackMetadata = new AtomicReference();

    public SystemIndexMigrator(Client client, long id, String type, String action, TaskId parentTask, Map<String, String> headers, ClusterService clusterService, SystemIndices systemIndices, IndexScopedSettings indexScopedSettings, ThreadPool threadPool, ProjectId projectId) {
        super(id, type, action, "system-index-migrator", parentTask, headers);
        this.projectId = projectId;
        this.baseClient = new ParentTaskAssigningClient(client, parentTask);
        this.clusterService = clusterService;
        this.systemIndices = systemIndices;
        this.indexScopedSettings = indexScopedSettings;
        this.threadPool = threadPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(SystemIndexMigrationTaskState taskState) {
        String stateFeatureName;
        String stateIndexName;
        ProjectMetadata projectMetadata = this.clusterService.state().metadata().getProject(this.projectId);
        if (taskState != null) {
            this.currentFeatureCallbackMetadata.set(taskState.getFeatureCallbackMetadata());
            stateIndexName = taskState.getCurrentIndex();
            stateFeatureName = taskState.getCurrentFeature();
            SystemIndices.Feature feature2 = this.systemIndices.getFeature(stateFeatureName);
            if (feature2 == null) {
                this.markAsFailed(new IllegalStateException("cannot migrate feature [" + stateFeatureName + "] because that feature is not installed on this node"));
                return;
            }
            if (stateIndexName != null && !projectMetadata.hasIndexAbstraction(stateIndexName)) {
                this.markAsFailed((Exception)new IndexNotFoundException(stateIndexName, "cannot migrate because that index does not exist"));
                return;
            }
        } else {
            stateIndexName = null;
            stateFeatureName = null;
        }
        Queue<SystemResourceMigrationInfo> queue = this.migrationQueue;
        synchronized (queue) {
            if (!this.migrationQueue.isEmpty() && taskState == null) {
                this.markAsFailed(new IllegalStateException("migration is already in progress, cannot start new migration"));
                return;
            }
            this.systemIndices.getFeatures().stream().flatMap(feature -> SystemResourceMigrationFactory.fromFeature(feature, projectMetadata, this.indexScopedSettings)).filter(migrationInfo -> SystemIndexMigrator.needToBeMigrated(migrationInfo.getIndices(projectMetadata))).sorted().collect(Collectors.toCollection(() -> this.migrationQueue));
            List<String> closedIndices = this.migrationQueue.stream().filter(SystemResourceMigrationInfo::isCurrentIndexClosed).map(SystemResourceMigrationInfo::getCurrentResourceName).toList();
            if (!closedIndices.isEmpty()) {
                this.markAsFailed(new IllegalStateException("indices must be open to be migrated, but indices " + String.valueOf(closedIndices) + " are closed"));
                return;
            }
            if (stateIndexName != null && stateFeatureName != null && !this.migrationQueue.isEmpty()) {
                SystemResourceMigrationInfo nextMigrationInfo = this.migrationQueue.peek();
                assert (nextMigrationInfo.getFeatureName().equals(stateFeatureName) && nextMigrationInfo.getCurrentResourceName().equals(stateIndexName)) : "system index/data stream name [" + stateIndexName + "] or feature name [" + stateFeatureName + "] from task state did not match first index/data stream [" + nextMigrationInfo.getCurrentResourceName() + "] and feature [" + nextMigrationInfo.getFeatureName() + "] of locally computed queue, see logs";
                if (!nextMigrationInfo.getCurrentResourceName().equals(stateIndexName)) {
                    if (!projectMetadata.hasIndexAbstraction(stateIndexName)) {
                        this.markAsFailed(new IllegalStateException(Strings.format((String)"failed to resume system resource migration from resource [%s], that is not present in the cluster", (Object[])new Object[]{stateIndexName})));
                    }
                    logger.warn(() -> Strings.format((String)"resuming system resource migration with resource [%s], which does not match resource given in last task state [%s]", (Object[])new Object[]{nextMigrationInfo.getCurrentResourceName(), stateIndexName}));
                }
            }
        }
        logger.debug("cleaning up previous migration, task state: [{}]", (Object)(taskState == null ? "null" : org.elasticsearch.common.Strings.toString((ToXContent)taskState)));
        this.clearResults((ActionListener<ClusterState>)ActionListener.wrap(state -> this.startFeatureMigration(stateFeatureName), this::markAsFailed));
    }

    private void finishIndexAndLoop(SystemIndexMigrationInfo migrationInfo, BulkByScrollResponse bulkResponse) {
        assert (!(bulkResponse.isTimedOut() || bulkResponse.getBulkFailures() != null && !bulkResponse.getBulkFailures().isEmpty() || bulkResponse.getSearchFailures() != null && !bulkResponse.getSearchFailures().isEmpty())) : "If this assertion gets triggered it means the validation in migrateSingleIndex isn't working right";
        logger.info("finished migrating old index [{}] from feature [{}] to new index [{}]", (Object)migrationInfo.getCurrentIndexName(), (Object)migrationInfo.getFeatureName(), (Object)migrationInfo.getNextIndexName());
        this.finishResourceAndLoop(migrationInfo);
    }

    private void finishDataStreamAndLoop(SystemDataStreamMigrationInfo migrationInfo) {
        logger.info("finished migrating old indices from data stream [{}] from feature [{}] to new indices", (Object)migrationInfo.getCurrentResourceName(), (Object)migrationInfo.getFeatureName());
        this.finishResourceAndLoop(migrationInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishResourceAndLoop(SystemResourceMigrationInfo lastMigrationInfo) {
        assert (this.migrationQueue != null && !this.migrationQueue.isEmpty());
        Queue<SystemResourceMigrationInfo> queue = this.migrationQueue;
        synchronized (queue) {
            this.migrationQueue.remove();
        }
        SystemResourceMigrationInfo nextMigrationInfo = this.currentMigrationInfo();
        if (nextMigrationInfo == null || !nextMigrationInfo.getFeatureName().equals(lastMigrationInfo.getFeatureName())) {
            lastMigrationInfo.indicesMigrationComplete(this.currentFeatureCallbackMetadata.get(), (Client)this.baseClient, (ActionListener<Boolean>)ActionListener.wrap(successful -> {
                if (!successful.booleanValue()) {
                    logger.warn("post-migration hook for feature [{}] indicated failure; feature migration metadata prior to failure was [{}]", (Object)lastMigrationInfo.getFeatureName(), this.currentFeatureCallbackMetadata.get());
                }
                this.recordIndexMigrationSuccess(lastMigrationInfo);
            }, this::markAsFailed));
        } else {
            this.startFeatureMigration(lastMigrationInfo.getFeatureName());
        }
    }

    private void migrateResource(SystemResourceMigrationInfo migrationInfo, ProjectMetadata project) {
        if (migrationInfo instanceof SystemIndexMigrationInfo) {
            SystemIndexMigrationInfo systemIndexMigrationInfo = (SystemIndexMigrationInfo)migrationInfo;
            logger.info("preparing to migrate old index [{}] from feature [{}] to new index [{}]", (Object)systemIndexMigrationInfo.getCurrentIndexName(), (Object)migrationInfo.getFeatureName(), (Object)systemIndexMigrationInfo.getNextIndexName());
            this.migrateSingleIndex(systemIndexMigrationInfo, project, this::finishIndexAndLoop);
        } else if (migrationInfo instanceof SystemDataStreamMigrationInfo) {
            SystemDataStreamMigrationInfo systemDataStreamMigrationInfo = (SystemDataStreamMigrationInfo)migrationInfo;
            logger.info("preparing to migrate old indices from data stream [{}] from feature [{}] to new indices", (Object)systemDataStreamMigrationInfo.getCurrentResourceName(), (Object)migrationInfo.getFeatureName());
            this.migrateDataStream(systemDataStreamMigrationInfo, this::finishDataStreamAndLoop);
        } else {
            throw new IllegalStateException("Unknown type of migration: " + String.valueOf(migrationInfo.getClass()));
        }
    }

    private void recordIndexMigrationSuccess(SystemResourceMigrationInfo lastMigrationInfo) {
        MigrationResultsUpdateTask updateTask = MigrationResultsUpdateTask.upsert(lastMigrationInfo.getFeatureName(), this.projectId, SingleFeatureMigrationResult.success(), (ActionListener<ClusterState>)ActionListener.wrap(state -> this.startFeatureMigration(lastMigrationInfo.getFeatureName()), this::markAsFailed));
        updateTask.submit(this.clusterService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startFeatureMigration(String lastFeatureName) {
        Queue<SystemResourceMigrationInfo> queue = this.migrationQueue;
        synchronized (queue) {
            assert (this.migrationQueue != null);
            if (this.migrationQueue.isEmpty()) {
                logger.info("finished migrating feature indices");
                this.markAsCompleted();
                return;
            }
        }
        SystemResourceMigrationInfo migrationInfo = this.currentMigrationInfo();
        assert (migrationInfo != null) : "the queue of indices to migrate should have been checked for emptiness before calling this method";
        if (!migrationInfo.getFeatureName().equals(lastFeatureName)) {
            ProjectMetadata project = this.clusterService.state().metadata().getProject(this.projectId);
            migrationInfo.prepareForIndicesMigration(project, (Client)this.baseClient, (ActionListener<Map<String, Object>>)ActionListener.wrap(newMetadata -> {
                this.currentFeatureCallbackMetadata.set((Map<String, Object>)newMetadata);
                this.updateTaskState(migrationInfo, newProject -> this.migrateResource(migrationInfo, (ProjectMetadata)newProject), (Map<String, Object>)newMetadata);
            }, this::markAsFailed));
        } else {
            this.updateTaskState(migrationInfo, newProject -> this.migrateResource(migrationInfo, (ProjectMetadata)newProject), this.currentFeatureCallbackMetadata.get());
        }
    }

    private void updateTaskState(SystemResourceMigrationInfo migrationInfo, Consumer<ProjectMetadata> listener, Map<String, Object> metadata) {
        SystemIndexMigrationTaskState newTaskState = new SystemIndexMigrationTaskState(migrationInfo.getCurrentResourceName(), migrationInfo.getFeatureName(), metadata);
        logger.debug("updating task state to [{}]", (Object)org.elasticsearch.common.Strings.toString((ToXContent)newTaskState));
        this.currentFeatureCallbackMetadata.set(metadata);
        this.updateProjectPersistentTaskState(this.projectId, newTaskState, ActionListener.wrap(task -> {
            assert (newTaskState.equals(task.getState())) : "task state returned by update method did not match submitted task state";
            logger.debug("new task state [{}] accepted", (Object)org.elasticsearch.common.Strings.toString((ToXContent)newTaskState));
            listener.accept(this.clusterService.state().metadata().getProject(this.projectId));
        }, this::markAsFailed));
    }

    private static boolean needToBeMigrated(Stream<IndexMetadata> indicesMetadata) {
        return indicesMetadata.anyMatch(indexMetadata -> {
            assert (indexMetadata != null) : "null IndexMetadata should be impossible, we're not consistently using the same cluster state";
            if (indexMetadata == null) {
                return false;
            }
            return indexMetadata.isSystem() && indexMetadata.getCreationVersion().before((VersionId)SystemIndices.NO_UPGRADE_REQUIRED_INDEX_VERSION);
        });
    }

    private void migrateSingleIndex(SystemIndexMigrationInfo migrationInfo, ProjectMetadata projectMetadata, BiConsumer<SystemIndexMigrationInfo, BulkByScrollResponse> listener) {
        String oldIndexName = migrationInfo.getCurrentIndexName();
        IndexMetadata imd = projectMetadata.index(oldIndexName);
        if (imd.getState().equals((Object)IndexMetadata.State.CLOSE)) {
            logger.error("unable to migrate index [{}] from feature [{}] because it is closed", (Object)oldIndexName, (Object)migrationInfo.getFeatureName());
            this.markAsFailed(new IllegalStateException("unable to migrate index [" + oldIndexName + "] because it is closed"));
            return;
        }
        Index oldIndex = imd.getIndex();
        String newIndexName = migrationInfo.getNextIndexName();
        if (!migrationInfo.allowsTemplates()) {
            String v2template = MetadataIndexTemplateService.findV2Template((ProjectMetadata)projectMetadata, (String)newIndexName, (boolean)false);
            if (Objects.nonNull(v2template)) {
                logger.error("unable to create new index [{}] from feature [{}] because it would match composable template [{}]", (Object)newIndexName, (Object)migrationInfo.getFeatureName(), (Object)v2template);
                this.markAsFailed(new IllegalStateException("unable to create new index [" + newIndexName + "] because it would match composable template [" + v2template + "]"));
                return;
            }
            List v1templates = MetadataIndexTemplateService.findV1Templates((ProjectMetadata)projectMetadata, (String)newIndexName, (Boolean)false);
            if (!v1templates.isEmpty()) {
                logger.error("unable to create new index [{}] from feature [{}] because it would match legacy templates [{}]", (Object)newIndexName, (Object)migrationInfo.getFeatureName(), (Object)v1templates);
                this.markAsFailed(new IllegalStateException("unable to create new index [" + newIndexName + "] because it would match legacy templates [" + String.valueOf(v1templates) + "]"));
                return;
            }
        }
        logger.info("migrating index [{}] from feature [{}] to new index [{}]", (Object)oldIndexName, (Object)migrationInfo.getFeatureName(), (Object)newIndexName);
        ActionListener innerListener = ActionListener.wrap(response -> listener.accept(migrationInfo, (BulkByScrollResponse)response), this::markAsFailed);
        try {
            this.createIndexRetryOnFailure(migrationInfo, (ActionListener<CreateIndexResponse>)innerListener.delegateFailureAndWrap((delegate, shardsAcknowledgedResponse) -> {
                logger.debug("while migrating [{}] , got create index response: [{}]", (Object)oldIndexName, (Object)org.elasticsearch.common.Strings.toString((ToXContent)shardsAcknowledgedResponse));
                this.setWriteBlock(oldIndex, true, (ActionListener<AcknowledgedResponse>)delegate.delegateFailureAndWrap((delegate2, setReadOnlyResponse) -> this.reindex(migrationInfo, (ActionListener<BulkByScrollResponse>)ActionListener.wrap(bulkByScrollResponse -> {
                    logger.debug("while migrating [{}], got reindex response: [{}]", (Object)oldIndexName, (Object)org.elasticsearch.common.Strings.toString((ToXContent)bulkByScrollResponse));
                    if (bulkByScrollResponse.getBulkFailures() != null && !bulkByScrollResponse.getBulkFailures().isEmpty() || bulkByScrollResponse.getSearchFailures() != null && !bulkByScrollResponse.getSearchFailures().isEmpty()) {
                        this.removeReadOnlyBlockOnReindexFailure(oldIndex, (ActionListener<BulkByScrollResponse>)delegate2, (Exception)SystemIndexMigrator.logAndThrowExceptionForFailures(bulkByScrollResponse));
                    } else {
                        this.setAliasAndRemoveOldIndex(migrationInfo, (ActionListener<IndicesAliasesResponse>)ActionListener.wrap(aliasesResponse -> {
                            if (aliasesResponse.hasErrors()) {
                                ElasticsearchException e = new ElasticsearchException("Aliases request had errors", new Object[0]);
                                for (ElasticsearchException error : aliasesResponse.getErrors()) {
                                    e.addSuppressed((Throwable)error);
                                }
                                throw e;
                            }
                            logger.info("Successfully migrated old index [{}] to new index [{}] from feature [{}]", (Object)oldIndexName, (Object)migrationInfo.getNextIndexName(), (Object)migrationInfo.getFeatureName());
                            delegate2.onResponse(bulkByScrollResponse);
                        }, e -> {
                            logger.error(() -> Strings.format((String)"An error occurred while changing aliases and removing the old index [%s] from feature [%s]", (Object[])new Object[]{oldIndexName, migrationInfo.getFeatureName()}), (Throwable)e);
                            this.removeReadOnlyBlockOnReindexFailure(oldIndex, (ActionListener<BulkByScrollResponse>)delegate2, (Exception)e);
                        }));
                    }
                }, e -> {
                    logger.error(() -> Strings.format((String)"error occurred while reindexing index [%s] from feature [%s] to destination index [%s]", (Object[])new Object[]{oldIndexName, migrationInfo.getFeatureName(), newIndexName}), (Throwable)e);
                    this.removeReadOnlyBlockOnReindexFailure(oldIndex, (ActionListener<BulkByScrollResponse>)delegate2, (Exception)e);
                }))));
            }));
        }
        catch (Exception ex) {
            logger.error(() -> Strings.format((String)"error occurred while migrating index [%s] from feature [%s] to new index [%s]", (Object[])new Object[]{oldIndexName, migrationInfo.getFeatureName(), newIndexName}), (Throwable)ex);
            this.removeReadOnlyBlockOnReindexFailure(oldIndex, (ActionListener<BulkByScrollResponse>)innerListener, ex);
            innerListener.onFailure(ex);
        }
    }

    private void createIndex(SystemIndexMigrationInfo migrationInfo, ActionListener<CreateIndexResponse> listener) {
        logger.info("creating new system index [{}] from feature [{}]", (Object)migrationInfo.getNextIndexName(), (Object)migrationInfo.getFeatureName());
        CreateIndexRequest createIndexRequest = new CreateIndexRequest(migrationInfo.getNextIndexName());
        Settings.Builder settingsBuilder = Settings.builder();
        if (Objects.nonNull(migrationInfo.getSettings())) {
            settingsBuilder.put(migrationInfo.getSettings());
            settingsBuilder.remove("index.blocks.write");
            settingsBuilder.remove("index.blocks.read");
            settingsBuilder.remove("index.blocks.metadata");
        }
        ((CreateIndexRequest)((CreateIndexRequest)createIndexRequest.cause("migrate-system-index").ackTimeout(TimeValue.ZERO)).masterNodeTimeout(MasterNodeRequest.INFINITE_MASTER_NODE_TIMEOUT)).waitForActiveShards(ActiveShardCount.ALL).mapping(migrationInfo.getMappings()).settings(Objects.requireNonNullElse(settingsBuilder.build(), Settings.EMPTY));
        migrationInfo.createClient((Client)this.baseClient).admin().indices().create(createIndexRequest, listener);
    }

    private void createIndexRetryOnFailure(SystemIndexMigrationInfo migrationInfo, ActionListener<CreateIndexResponse> listener) {
        this.createIndex(migrationInfo, (ActionListener<CreateIndexResponse>)listener.delegateResponse((l, e) -> {
            logger.warn("createIndex failed with \"{}\", retrying after removing index [{}] from previous attempt", (Object)e.getMessage(), (Object)migrationInfo.getNextIndexName());
            this.deleteIndex(migrationInfo, (ActionListener<AcknowledgedResponse>)ActionListener.wrap(cleanupResponse -> this.createIndex(migrationInfo, (ActionListener<CreateIndexResponse>)l.delegateResponse((l3, e3) -> {
                e3.addSuppressed((Throwable)e);
                logger.error("createIndex failed after retrying, aborting system index migration. index: " + migrationInfo.getNextIndexName(), (Throwable)e3);
                l.onFailure(e3);
            })), e2 -> {
                e2.addSuppressed((Throwable)e);
                logger.error("deleteIndex failed, aborting system index migration. index: " + migrationInfo.getNextIndexName(), (Throwable)e2);
                l.onFailure(e2);
            }));
        }));
    }

    private <T> void deleteIndex(SystemIndexMigrationInfo migrationInfo, ActionListener<AcknowledgedResponse> listener) {
        logger.info("removing index [{}] from feature [{}]", (Object)migrationInfo.getNextIndexName(), (Object)migrationInfo.getFeatureName());
        String newIndexName = migrationInfo.getNextIndexName();
        migrationInfo.createClient((Client)this.baseClient).admin().indices().prepareDelete(new String[]{newIndexName}).execute(ActionListener.wrap(ackedResponse -> {
            if (ackedResponse.isAcknowledged()) {
                logger.info("successfully removed index [{}]", (Object)newIndexName);
                listener.onResponse(ackedResponse);
            } else {
                listener.onFailure((Exception)new ElasticsearchException("Failed to acknowledge index deletion for [" + newIndexName + "]", new Object[0]));
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void setAliasAndRemoveOldIndex(SystemIndexMigrationInfo migrationInfo, ActionListener<IndicesAliasesResponse> listener) {
        IndicesAliasesRequestBuilder aliasesRequest = migrationInfo.createClient((Client)this.baseClient).admin().indices().prepareAliases(TimeValue.THIRTY_SECONDS, TimeValue.THIRTY_SECONDS);
        aliasesRequest.removeIndex(migrationInfo.getCurrentIndexName());
        aliasesRequest.addAlias(migrationInfo.getNextIndexName(), migrationInfo.getCurrentIndexName());
        IndexMetadata imd = this.clusterService.state().metadata().getProject(this.projectId).index(migrationInfo.getCurrentIndexName());
        imd.getAliases().values().forEach(aliasToAdd -> aliasesRequest.addAliasAction(IndicesAliasesRequest.AliasActions.add().index(migrationInfo.getNextIndexName()).alias(aliasToAdd.alias()).indexRouting(aliasToAdd.indexRouting()).searchRouting(aliasToAdd.searchRouting()).filter(aliasToAdd.filter() == null ? null : aliasToAdd.filter().string()).writeIndex(null)));
        aliasesRequest.execute(listener);
    }

    private void setWriteBlock(Index index, boolean readOnlyValue, ActionListener<AcknowledgedResponse> listener) {
        if (readOnlyValue) {
            this.baseClient.admin().indices().addBlock((AddIndexBlockRequest)new AddIndexBlockRequest(IndexMetadata.APIBlock.WRITE, new String[]{index.getName()}).masterNodeTimeout(MasterNodeRequest.INFINITE_MASTER_NODE_TIMEOUT), listener.delegateFailureAndWrap((l, response) -> {
                if (!response.isAcknowledged()) {
                    throw new ElasticsearchException("Failed to acknowledge read-only block index request", new Object[0]);
                }
                l.onResponse(response);
            }));
        } else {
            Settings readOnlySettings = Settings.builder().put(IndexMetadata.INDEX_BLOCKS_WRITE_SETTING.getKey(), false).build();
            UpdateSettingsRequest updateSettingsRequest = (UpdateSettingsRequest)((UpdateSettingsRequest)new UpdateSettingsRequest(readOnlySettings, new String[]{index.getName()}).setPreserveExisting(false).masterNodeTimeout(MasterNodeRequest.INFINITE_MASTER_NODE_TIMEOUT)).ackTimeout(TimeValue.ZERO);
            this.baseClient.execute(TransportUpdateSettingsAction.TYPE, (ActionRequest)updateSettingsRequest, listener);
        }
    }

    private void reindex(SystemIndexMigrationInfo migrationInfo, ActionListener<BulkByScrollResponse> listener) {
        ReindexRequest reindexRequest = new ReindexRequest();
        reindexRequest.setSourceIndices(new String[]{migrationInfo.getCurrentIndexName()});
        reindexRequest.setDestIndex(migrationInfo.getNextIndexName());
        reindexRequest.setRefresh(true);
        String migrationScript = migrationInfo.getMigrationScript();
        if (!org.elasticsearch.common.Strings.isNullOrEmpty((String)migrationScript)) {
            reindexRequest.setScript(Script.parse((Object)migrationScript));
        }
        migrationInfo.createClient((Client)this.baseClient).execute((ActionType)ReindexAction.INSTANCE, (ActionRequest)reindexRequest, listener);
    }

    private void migrateDataStream(SystemDataStreamMigrationInfo migrationInfo, Consumer<SystemDataStreamMigrationInfo> completionListener) {
        String dataStreamName = migrationInfo.getDataStreamName();
        logger.info("migrating data stream [{}] from feature [{}]", (Object)dataStreamName, (Object)migrationInfo.getFeatureName());
        ReindexDataStreamAction.ReindexDataStreamRequest reindexRequest = new ReindexDataStreamAction.ReindexDataStreamRequest(ReindexDataStreamAction.Mode.UPGRADE, dataStreamName);
        try {
            migrationInfo.createClient((Client)this.baseClient).execute((ActionType)ReindexDataStreamAction.INSTANCE, (ActionRequest)reindexRequest, ActionListener.wrap(startMigrationResponse -> {
                if (!startMigrationResponse.isAcknowledged()) {
                    logger.error("failed to migrate indices from data stream [{}]", (Object)dataStreamName);
                    throw new ElasticsearchException("reindex system data stream [" + dataStreamName + "] from feature [" + migrationInfo.getFeatureName() + "] response is not acknowledge", new Object[0]);
                }
                this.checkDataStreamMigrationStatus(migrationInfo, completionListener, false);
            }, e -> {
                if (e instanceof ResourceAlreadyExistsException) {
                    logger.debug("data stream [{}] migration is already in progress", (Object)dataStreamName);
                    this.checkDataStreamMigrationStatus(migrationInfo, completionListener, true);
                } else {
                    this.markAsFailed((Exception)e);
                }
            }));
        }
        catch (Exception ex) {
            logger.error(() -> Strings.format((String)"error occurred while migrating data stream [%s] from feature [%s]", (Object[])new Object[]{dataStreamName, migrationInfo.getFeatureName()}), (Throwable)ex);
            this.markAsFailed(ex);
        }
    }

    private void checkDataStreamMigrationStatus(SystemDataStreamMigrationInfo migrationInfo, Consumer<SystemDataStreamMigrationInfo> completionListener, boolean restartMigrationOnError) {
        String dataStreamName = migrationInfo.getDataStreamName();
        GetMigrationReindexStatusAction.Request getStatusRequest = new GetMigrationReindexStatusAction.Request(dataStreamName);
        migrationInfo.createClient((Client)this.baseClient).execute((ActionType)GetMigrationReindexStatusAction.INSTANCE, (ActionRequest)getStatusRequest, ActionListener.wrap(migrationStatusResponse -> {
            ReindexDataStreamEnrichedStatus status = migrationStatusResponse.getEnrichedStatus();
            logger.debug("data stream [{}] reindexing status: pending {} out of {} indices", (Object)dataStreamName, (Object)status.pending(), (Object)status.totalIndicesToBeUpgraded());
            if (!status.complete()) {
                this.threadPool.schedule(() -> this.checkDataStreamMigrationStatus(migrationInfo, completionListener, false), TimeValue.timeValueSeconds((long)1L), (Executor)this.threadPool.generic());
            } else {
                List<Tuple<String, Exception>> errors = status.errors();
                if (errors != null && !errors.isEmpty() || status.exception() != null) {
                    if (restartMigrationOnError) {
                        this.cancelExistingDataStreamMigrationAndRetry(migrationInfo, completionListener);
                    } else {
                        List<Exception> exceptions = status.exception() != null ? Collections.singletonList(status.exception()) : errors.stream().map(Tuple::v2).toList();
                        this.dataStreamMigrationFailed(migrationInfo, exceptions);
                    }
                } else {
                    logger.info("successfully migrated old indices from data stream [{}] from feature [{}] to new indices", (Object)dataStreamName, (Object)migrationInfo.getFeatureName());
                    completionListener.accept(migrationInfo);
                }
            }
        }, ex -> this.cancelExistingDataStreamMigrationAndMarkAsFailed(migrationInfo, (Exception)ex)));
    }

    private void dataStreamMigrationFailed(SystemDataStreamMigrationInfo migrationInfo, Collection<Exception> exceptions) {
        logger.error("error occurred while reindexing data stream [{}] from feature [{}], failures [{}]", (Object)migrationInfo.getDataStreamName(), (Object)migrationInfo.getFeatureName(), exceptions);
        ElasticsearchException ex = new ElasticsearchException("error occurred while reindexing data stream [" + migrationInfo.getDataStreamName() + "]", new Object[0]);
        for (Exception exception : exceptions) {
            ex.addSuppressed((Throwable)exception);
        }
        throw ex;
    }

    private void removeReadOnlyBlockOnReindexFailure(Index index, ActionListener<BulkByScrollResponse> listener, Exception ex) {
        logger.info("removing read only block on [{}] because reindex failed [{}]", (Object)index, (Object)ex);
        this.setWriteBlock(index, false, (ActionListener<AcknowledgedResponse>)ActionListener.wrap(unsetReadOnlyResponse -> listener.onFailure(ex), e1 -> listener.onFailure(ex)));
    }

    private void cancelExistingDataStreamMigrationAndRetry(SystemDataStreamMigrationInfo migrationInfo, Consumer<SystemDataStreamMigrationInfo> completionListener) {
        logger.debug("cancelling migration of data stream [{}] from feature [{}] for retry", (Object)migrationInfo.getDataStreamName(), (Object)migrationInfo.getFeatureName());
        ActionListener listener = ActionListener.wrap(response -> {
            if (!response.isAcknowledged()) {
                String dataStreamName = migrationInfo.getDataStreamName();
                logger.error("failed to cancel migration of data stream [{}] from feature [{}] during retry", (Object)dataStreamName, (Object)migrationInfo.getFeatureName());
                throw new ElasticsearchException("failed to cancel migration of data stream [" + dataStreamName + "] from feature [" + migrationInfo.getFeatureName() + "] response is not acknowledge", new Object[0]);
            }
            this.migrateDataStream(migrationInfo, completionListener);
        }, this::markAsFailed);
        this.cancelDataStreamMigration(migrationInfo, (ActionListener<AcknowledgedResponse>)listener);
    }

    private void cancelExistingDataStreamMigrationAndMarkAsFailed(SystemDataStreamMigrationInfo migrationInfo, Exception exception) {
        logger.info("cancelling migration of data stream [{}] from feature [{}]", (Object)migrationInfo.getDataStreamName(), (Object)migrationInfo.getFeatureName());
        ActionListener listener = ActionListener.wrap(response -> this.markAsFailed(exception), ex -> {
            exception.addSuppressed((Throwable)ex);
            this.markAsFailed(exception);
        });
        this.cancelDataStreamMigration(migrationInfo, (ActionListener<AcknowledgedResponse>)listener);
    }

    private void cancelDataStreamMigration(SystemDataStreamMigrationInfo migrationInfo, ActionListener<AcknowledgedResponse> listener) {
        String dataStreamName = migrationInfo.getDataStreamName();
        CancelReindexDataStreamAction.Request cancelRequest = new CancelReindexDataStreamAction.Request(dataStreamName);
        try {
            migrationInfo.createClient((Client)this.baseClient).execute((ActionType)CancelReindexDataStreamAction.INSTANCE, (ActionRequest)cancelRequest, listener);
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private static ElasticsearchException logAndThrowExceptionForFailures(BulkByScrollResponse bulkByScrollResponse) {
        String bulkFailures = bulkByScrollResponse.getBulkFailures() != null ? org.elasticsearch.common.Strings.collectionToCommaDelimitedString((Iterable)bulkByScrollResponse.getBulkFailures()) : "";
        String searchFailures = bulkByScrollResponse.getSearchFailures() != null ? org.elasticsearch.common.Strings.collectionToCommaDelimitedString((Iterable)bulkByScrollResponse.getSearchFailures()) : "";
        logger.error("error occurred while reindexing, bulk failures [{}], search failures [{}]", (Object)bulkFailures, (Object)searchFailures);
        return new ElasticsearchException("error occurred while reindexing, bulk failures [{}], search failures [{}]", new Object[]{bulkFailures, searchFailures});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markAsFailed(Exception e) {
        SystemResourceMigrationInfo migrationInfo = this.currentMigrationInfo();
        Queue<SystemResourceMigrationInfo> queue = this.migrationQueue;
        synchronized (queue) {
            this.migrationQueue.clear();
        }
        String featureName = Optional.ofNullable(migrationInfo).map(SystemResourceMigrationInfo::getFeatureName).orElse("<unknown feature>");
        String indexName = Optional.ofNullable(migrationInfo).map(SystemResourceMigrationInfo::getCurrentResourceName).orElse("<unknown resource>");
        MigrationResultsUpdateTask.upsert(featureName, this.projectId, SingleFeatureMigrationResult.failure(indexName, e), (ActionListener<ClusterState>)ActionListener.wrap(state -> super.markAsFailed(e), exception -> super.markAsFailed(e))).submit(this.clusterService);
        super.markAsFailed(e);
    }

    private void clearResults(final ActionListener<ClusterState> listener) {
        SystemIndexMigrator.submitUnbatchedTask(this.clusterService, "clear migration results", new ClusterStateUpdateTask(){

            public ClusterState execute(ClusterState currentState) throws Exception {
                ProjectMetadata project = currentState.metadata().getProject(SystemIndexMigrator.this.projectId);
                if (project.custom("system_index_migration") != null) {
                    return ClusterState.builder((ClusterState)currentState).putProjectMetadata(ProjectMetadata.builder((ProjectMetadata)project).removeCustom("system_index_migration")).build();
                }
                return currentState;
            }

            public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
                listener.onResponse((Object)newState);
            }

            public void onFailure(Exception e) {
                logger.error("failed to clear migration results when starting new migration", (Throwable)e);
                listener.onFailure(e);
            }
        });
        logger.debug("submitted update task to clear migration results");
    }

    @SuppressForbidden(reason="legacy usage of unbatched task")
    private static void submitUnbatchedTask(ClusterService clusterService, String source, ClusterStateUpdateTask task) {
        clusterService.submitUnbatchedStateUpdateTask(source, task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SystemResourceMigrationInfo currentMigrationInfo() {
        Queue<SystemResourceMigrationInfo> queue = this.migrationQueue;
        synchronized (queue) {
            return this.migrationQueue.peek();
        }
    }
}

