/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical.join;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockUtils;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeMap;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.util.Holder;
import org.elasticsearch.xpack.esql.expression.NamedExpressions;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.esql.plan.logical.join.Join;
import org.elasticsearch.xpack.esql.plan.logical.join.JoinConfig;
import org.elasticsearch.xpack.esql.plan.logical.join.JoinType;
import org.elasticsearch.xpack.esql.plan.logical.join.JoinTypes;
import org.elasticsearch.xpack.esql.plan.logical.join.StubRelation;
import org.elasticsearch.xpack.esql.plan.logical.local.LocalRelation;

public class InlineJoin
extends Join {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(LogicalPlan.class, "InlineJoin", InlineJoin::readFrom);

    public static LogicalPlan stubSource(UnaryPlan sourcePlan, LogicalPlan target) {
        return sourcePlan.replaceChild(new StubRelation(sourcePlan.source(), StubRelation.computeOutput(sourcePlan, target)));
    }

    public static LogicalPlan inlineData(InlineJoin target, LocalRelation data) {
        if (target.config().leftFields().isEmpty()) {
            List<Attribute> schema = data.output();
            Block[] blocks = (Block[])data.supplier().get();
            ArrayList<Alias> aliases = new ArrayList<Alias>(schema.size());
            for (int i = 0; i < schema.size(); ++i) {
                Attribute attr = schema.get(i);
                aliases.add(new Alias(attr.source(), attr.name(), (Expression)Literal.of((Expression)attr, (Object)BlockUtils.toJavaObject((Block)blocks[i], (int)0)), attr.id()));
            }
            return new Eval(target.source(), target.left(), aliases);
        }
        return target.replaceRight(data);
    }

    @Override
    protected LogicalPlan getRightToSerialize(StreamOutput out) {
        return this.right();
    }

    public static LogicalPlan replaceStub(LogicalPlan stubReplacement, LogicalPlan stubbedPlan) {
        Holder doneReplacing = new Holder((Object)false);
        LogicalPlan result = (LogicalPlan)stubbedPlan.transformUp(UnaryPlan.class, up -> {
            if (up.child() instanceof StubRelation) {
                if (!((Boolean)doneReplacing.get()).booleanValue()) {
                    doneReplacing.set((Object)true);
                    return up.replaceChild(stubReplacement);
                }
                throw new IllegalStateException("Expected to replace a single StubRelation in the plan, but found more than one");
            }
            return up;
        });
        if (!((Boolean)doneReplacing.get()).booleanValue()) {
            throw new IllegalStateException("Expected to replace a single StubRelation in the plan, but none found");
        }
        return result;
    }

    public static LogicalPlanTuple firstSubPlan(LogicalPlan optimizedPlan, Set<LocalRelation> subPlansResults) {
        Holder subPlan = new Holder();
        optimizedPlan.forEachUp(InlineJoin.class, ij -> {
            block2: {
                block5: {
                    block4: {
                        block3: {
                            if (subPlan.get() != null) break block2;
                            if (!ij.right().anyMatch(p -> p instanceof StubRelation)) break block3;
                            LogicalPlan p2 = InlineJoin.replaceStub(ij.left(), ij.right());
                            p2.setOptimized();
                            subPlan.set((Object)new LogicalPlanTuple(p2, ij.right()));
                            break block2;
                        }
                        LogicalPlan patt0$temp = ij.right();
                        if (!(patt0$temp instanceof LocalRelation)) break block4;
                        LocalRelation relation = (LocalRelation)patt0$temp;
                        if (subPlansResults.isEmpty() || !subPlansResults.contains((Object)relation)) break block5;
                    }
                    if (ij.right() instanceof LocalRelation || !ij.right().anyMatch(p -> p instanceof LocalRelation)) break block2;
                }
                LogicalPlan p3 = ij.right();
                p3.setOptimized();
                subPlan.set((Object)new LogicalPlanTuple(p3, ij.right()));
            }
        });
        return (LogicalPlanTuple)subPlan.get();
    }

    public InlineJoin(Source source, LogicalPlan left, LogicalPlan right, JoinConfig config) {
        super(source, left, right, config);
    }

    public InlineJoin(Source source, LogicalPlan left, LogicalPlan right, JoinType type, List<Attribute> leftFields, List<Attribute> rightFields) {
        super(source, left, right, type, leftFields, rightFields, null);
    }

    private static InlineJoin readFrom(StreamInput in) throws IOException {
        PlanStreamInput planInput = (PlanStreamInput)in;
        Source source = Source.readFrom((StreamInput)planInput);
        LogicalPlan left = (LogicalPlan)in.readNamedWriteable(LogicalPlan.class);
        LogicalPlan right = (LogicalPlan)in.readNamedWriteable(LogicalPlan.class);
        JoinConfig config = new JoinConfig(in);
        return new InlineJoin(source, left, right, config);
    }

    @Override
    public String getWriteableName() {
        return InlineJoin.ENTRY.name;
    }

    @Override
    protected NodeInfo<Join> info() {
        JoinConfig config = this.config();
        return NodeInfo.create((Node)this, InlineJoin::new, (Object)((Object)this.left()), (Object)((Object)this.right()), (Object)config.type(), config.leftFields(), config.rightFields());
    }

    @Override
    public Join replaceChildren(LogicalPlan left, LogicalPlan right) {
        return new InlineJoin(this.source(), left, right, this.config());
    }

    @Override
    public List<NamedExpression> computeOutputExpressions(List<? extends NamedExpression> left, List<? extends NamedExpression> right) {
        JoinType joinType = this.config().type();
        if (!JoinTypes.LEFT.equals(joinType)) {
            throw new IllegalArgumentException(joinType.joinName() + " unsupported");
        }
        List<NamedExpression> leftOutputWithoutKeys = left.stream().filter(ne -> !this.config().leftFields().contains(ne.toAttribute())).toList();
        ArrayList<? extends NamedExpression> rightWithAppendedLeftKeys = new ArrayList<NamedExpression>(right);
        rightWithAppendedLeftKeys.removeIf(ne -> this.config().rightFields().contains(ne.toAttribute()));
        AttributeMap leftAttrMap = AttributeMap.mapAll(left, NamedExpression::toAttribute);
        this.config().leftFields().forEach(lk -> rightWithAppendedLeftKeys.add((NamedExpression)leftAttrMap.getOrDefault(lk, lk)));
        List<NamedExpression> output = NamedExpressions.mergeOutputExpressions(rightWithAppendedLeftKeys, leftOutputWithoutKeys);
        return output;
    }

    public record LogicalPlanTuple(LogicalPlan stubReplacedSubPlan, LogicalPlan originalSubPlan) {
    }
}

