/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan;

import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.Foldables;
import org.elasticsearch.xpack.esql.parser.ParsingException;
import org.elasticsearch.xpack.esql.plan.EsqlStatement;
import org.elasticsearch.xpack.esql.plan.QuerySetting;

public class QuerySettings {
    public static final QuerySettingDef<String> PROJECT_ROUTING = new QuerySettingDef<String>("project_routing", DataType.KEYWORD, true, false, true, "A project routing expression, used to define which projects to route the query to. Only supported if Cross-Project Search is enabled.", (value, settings) -> Foldables.stringLiteralValueOf(value, "Unexpected value"), _rcs -> null);
    public static final QuerySettingDef<ZoneId> TIME_ZONE = new QuerySettingDef<ZoneId>("time_zone", DataType.KEYWORD, false, true, true, "The default timezone to be used in the query, by the functions and commands that require it. Defaults to UTC", (value, _rcs) -> {
        String timeZone = Foldables.stringLiteralValueOf(value, "Unexpected value");
        try {
            return ZoneId.of(timeZone);
        }
        catch (Exception exc) {
            throw new IllegalArgumentException("Invalid time zone [" + timeZone + "]");
        }
    }, _rcs -> ZoneOffset.UTC);
    public static final Map<String, QuerySettingDef<?>> SETTINGS_BY_NAME = Stream.of(PROJECT_ROUTING, TIME_ZONE).collect(Collectors.toMap(QuerySettingDef::name, Function.identity()));

    public static void validate(EsqlStatement statement, RemoteClusterService clusterService) {
        for (QuerySetting setting : statement.settings()) {
            QuerySettingDef<?> def = SETTINGS_BY_NAME.get(setting.name());
            if (def == null) {
                throw new ParsingException(setting.source(), "Unknown setting [" + setting.name() + "]", new Object[0]);
            }
            if (setting.value().dataType() != def.type()) {
                throw new ParsingException(setting.source(), "Setting [" + setting.name() + "] must be of type " + String.valueOf(def.type()), new Object[0]);
            }
            String error = def.validator().validate(setting.value(), clusterService);
            if (error == null) continue;
            throw new ParsingException("Error validating setting [" + setting.name() + "]: " + error, new Object[0]);
        }
    }

    public record QuerySettingDef<T>(String name, DataType type, boolean serverlessOnly, boolean preview, boolean snapshotOnly, String description, Validator validator, Parser<T> parser, Function<RemoteClusterService, T> defaultValueSupplier) {
        public QuerySettingDef(String name, DataType type, boolean serverlessOnly, boolean preview, boolean snapshotOnly, String description, Parser<T> parser, Function<RemoteClusterService, T> defaultValueSupplier) {
            this(name, type, serverlessOnly, preview, snapshotOnly, description, (value, rcs) -> {
                try {
                    parser.parse(value, rcs);
                    return null;
                }
                catch (Exception exc) {
                    return exc.getMessage();
                }
            }, parser, defaultValueSupplier);
        }

        public T get(Expression value, RemoteClusterService clusterService) {
            if (value == null) {
                return this.defaultValueSupplier.apply(clusterService);
            }
            return this.parser.parse(value, clusterService);
        }

        @FunctionalInterface
        public static interface Validator {
            @Nullable
            public String validate(Expression var1, RemoteClusterService var2);
        }

        @FunctionalInterface
        public static interface Parser<T> {
            public T parse(Expression var1, RemoteClusterService var2);
        }
    }
}

