/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer;

import java.util.List;
import org.elasticsearch.xpack.esql.capabilities.PostPhysicalOptimizationVerificationAware;
import org.elasticsearch.xpack.esql.common.Failure;
import org.elasticsearch.xpack.esql.common.Failures;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.optimizer.PostOptimizationPhasePlanVerifier;
import org.elasticsearch.xpack.esql.optimizer.rules.PlanConsistencyChecker;
import org.elasticsearch.xpack.esql.plan.logical.Enrich;
import org.elasticsearch.xpack.esql.plan.physical.EnrichExec;
import org.elasticsearch.xpack.esql.plan.physical.FieldExtractExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;

public final class PhysicalVerifier
extends PostOptimizationPhasePlanVerifier<PhysicalPlan> {
    public static final PhysicalVerifier INSTANCE = new PhysicalVerifier();

    private PhysicalVerifier() {
    }

    @Override
    boolean skipVerification(PhysicalPlan optimizedPlan, boolean skipRemoteEnrichVerification) {
        if (skipRemoteEnrichVerification) {
            List enriches = optimizedPlan.collectFirstChildren(EnrichExec.class::isInstance);
            if (!enriches.isEmpty() && ((EnrichExec)enriches.get(0)).mode() == Enrich.Mode.REMOTE) {
                return true;
            }
        }
        return false;
    }

    @Override
    void checkPlanConsistency(PhysicalPlan optimizedPlan, Failures failures, Failures depFailures) {
        optimizedPlan.forEachDown(p -> {
            FieldExtractExec fieldExtractExec;
            Attribute sourceAttribute;
            if (p instanceof FieldExtractExec && (sourceAttribute = (fieldExtractExec = (FieldExtractExec)p).sourceAttribute()) == null) {
                failures.add(Failure.fail(fieldExtractExec, "Need to add field extractor for [{}] but cannot detect source attributes from node [{}]", new Object[]{Expressions.names(fieldExtractExec.attributesToExtract()), fieldExtractExec.child()}));
            }
            PlanConsistencyChecker.checkPlan(p, depFailures);
            if (!failures.hasFailures()) {
                if (p instanceof PostPhysicalOptimizationVerificationAware) {
                    PostPhysicalOptimizationVerificationAware va = (PostPhysicalOptimizationVerificationAware)((Object)p);
                    va.postPhysicalOptimizationVerification(failures);
                }
                p.forEachExpression(ex -> {
                    if (ex instanceof PostPhysicalOptimizationVerificationAware) {
                        PostPhysicalOptimizationVerificationAware va = (PostPhysicalOptimizationVerificationAware)ex;
                        va.postPhysicalOptimizationVerification(failures);
                    }
                });
            }
        });
    }
}

