/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.ip;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.network.CIDRUtils;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.capabilities.TranslationAware;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.querydsl.query.Query;
import org.elasticsearch.xpack.esql.core.querydsl.query.TermsQuery;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.Check;
import org.elasticsearch.xpack.esql.core.util.CollectionUtils;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.EsqlTypeResolutions;
import org.elasticsearch.xpack.esql.expression.Foldables;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.ip.CIDRMatchEvaluator;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.LucenePushdownPredicates;
import org.elasticsearch.xpack.esql.planner.TranslatorHandler;

public class CIDRMatch
extends EsqlScalarFunction
implements TranslationAware.SingleValueTranslationAware {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "CIDRMatch", CIDRMatch::new);
    private final Expression ipField;
    private final List<Expression> matches;

    @FunctionInfo(returnType={"boolean"}, description="Returns true if the provided IP is contained in one of the provided CIDR blocks.", examples={@Example(file="ip", tag="cdirMatchMultipleArgs")})
    public CIDRMatch(Source source, @Param(name="ip", type={"ip"}, description="IP address of type `ip` (both IPv4 and IPv6 are supported).") Expression ipField, @Param(name="blockX", type={"keyword", "text"}, description="CIDR block to test the IP against.") List<Expression> matches) {
        super(source, CollectionUtils.combine(Collections.singletonList(ipField), matches));
        this.ipField = ipField;
        this.matches = matches;
    }

    private CIDRMatch(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class), in.readNamedWriteableCollectionAsList(Expression.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        assert (this.children().size() > 1);
        out.writeNamedWriteable((NamedWriteable)this.children().get(0));
        out.writeNamedWriteableCollection(this.children().subList(1, this.children().size()));
    }

    public String getWriteableName() {
        return CIDRMatch.ENTRY.name;
    }

    public Expression ipField() {
        return this.ipField;
    }

    public List<Expression> matches() {
        return this.matches;
    }

    public boolean foldable() {
        return Expressions.foldable((List)this.children());
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        EvalOperator.ExpressionEvaluator.Factory ipEvaluatorSupplier = toEvaluator.apply(this.ipField);
        return new CIDRMatchEvaluator.Factory(this.source(), ipEvaluatorSupplier, (EvalOperator.ExpressionEvaluator.Factory[])this.matches.stream().map(toEvaluator::apply).toArray(EvalOperator.ExpressionEvaluator.Factory[]::new));
    }

    static boolean process(BytesRef ip, BytesRef[] cidrs) {
        for (BytesRef cidr : cidrs) {
            if (!CIDRUtils.isInRange((byte[])Arrays.copyOfRange(ip.bytes, ip.offset, ip.offset + ip.length), (String)cidr.utf8ToString())) continue;
            return true;
        }
        return false;
    }

    public DataType dataType() {
        return DataType.BOOLEAN;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution resolution = TypeResolutions.isIPAndExact((Expression)this.ipField, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST);
        if (resolution.unresolved()) {
            return resolution;
        }
        int i = 1;
        for (Expression m : this.matches) {
            resolution = EsqlTypeResolutions.isStringAndExact(m, this.sourceText(), TypeResolutions.ParamOrdinal.fromIndex((int)i++));
            if (!resolution.unresolved()) continue;
            return resolution;
        }
        return resolution;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new CIDRMatch(this.source(), newChildren.get(0), newChildren.subList(1, newChildren.size()));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, CIDRMatch::new, (Object)((Expression)this.children().get(0)), this.children().subList(1, this.children().size()));
    }

    @Override
    public TranslationAware.Translatable translatable(LucenePushdownPredicates pushdownPredicates) {
        return pushdownPredicates.isPushableFieldAttribute(this.ipField) && Expressions.foldable(this.matches) ? TranslationAware.Translatable.YES : TranslationAware.Translatable.NO;
    }

    @Override
    public Query asQuery(LucenePushdownPredicates pushdownPredicates, TranslatorHandler handler) {
        FieldAttribute fa = LucenePushdownPredicates.checkIsFieldAttribute(this.ipField);
        Check.isTrue((boolean)Expressions.foldable(this.matches), (String)"Expected foldable matches, but got [{}]", (Object[])new Object[]{this.matches});
        String targetFieldName = handler.nameOf((Expression)fa.exactAttribute());
        LinkedHashSet<Object> set = new LinkedHashSet<Object>(this.matches.stream().map(Foldables::literalValueOf).toList());
        return new TermsQuery(this.source(), targetFieldName, set);
    }

    @Override
    public Expression singleValueField() {
        return this.ipField;
    }
}

