/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.grouping;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.expression.UnresolvedAttribute;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.SurrogateExpression;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.FunctionType;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.grouping.Bucket;
import org.elasticsearch.xpack.esql.expression.function.grouping.GroupingFunction;

public class TBucket
extends GroupingFunction.EvaluatableGroupingFunction
implements SurrogateExpression {
    public static final String NAME = "TBucket";
    private final Expression buckets;
    private final Expression timestamp;

    @FunctionInfo(returnType={"date", "date_nanos"}, description="Creates groups of values - buckets - out of a @timestamp attribute. The size of the buckets must be provided directly.", examples={@Example(description="Provide a bucket size as an argument.", file="tbucket", tag="docsTBucketByOneHourDuration", explanation="::::{note}\nWhen providing the bucket size, it must be a time duration or date period.\nAlso the reference is epoch, which starts at `0001-01-01T00:00:00Z`.\n::::"), @Example(description="Provide a string representation of bucket size as an argument.", file="tbucket", tag="docsTBucketByOneHourDurationAsString", explanation="::::{note}\nWhen providing the bucket size, it can be a string representation of time duration or date period.\nFor example, \"1 hour\". Also the reference is epoch, which starts at `0001-01-01T00:00:00Z`.\n::::")}, type=FunctionType.GROUPING)
    public TBucket(Source source, @Param(name="buckets", type={"date_period", "time_duration"}, description="Desired bucket size.") Expression buckets) {
        this(source, buckets, (Expression)new UnresolvedAttribute(source, "@timestamp"));
    }

    public TBucket(Source source, Expression buckets, Expression timestamp) {
        super(source, List.of(buckets, timestamp));
        this.buckets = buckets;
        this.timestamp = timestamp;
    }

    public void writeTo(StreamOutput out) throws IOException {
        throw new UnsupportedOperationException("not serialized");
    }

    public String getWriteableName() {
        throw new UnsupportedOperationException("not serialized");
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        throw new UnsupportedOperationException("should be rewritten");
    }

    @Override
    public Expression surrogate() {
        return new Bucket(this.source(), this.timestamp, this.buckets, null, null);
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        return TypeResolutions.isType((Expression)this.buckets, DataType::isTemporalAmount, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.DEFAULT, (String[])new String[]{"date_period", "time_duration"}).and(TypeResolutions.isType((Expression)this.timestamp, dt -> dt == DataType.DATETIME || dt == DataType.DATE_NANOS, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND, (String[])new String[]{"date_nanos or datetime"}));
    }

    public DataType dataType() {
        return this.timestamp.dataType();
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new TBucket(this.source(), newChildren.get(0), newChildren.get(1));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, TBucket::new, (Object)this.buckets, (Object)this.timestamp);
    }

    public Expression field() {
        return this.timestamp;
    }

    public Expression buckets() {
        return this.buckets;
    }

    public String toString() {
        return "TBucket{buckets=" + String.valueOf(this.buckets) + "}";
    }
}

