/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.IrateDoubleAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.IrateIntAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.IrateLongAggregatorFunctionSupplier;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.expression.UnresolvedAttribute;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesTo;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesToLifecycle;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.FunctionType;
import org.elasticsearch.xpack.esql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.aggregate.TimeSeriesAggregateFunction;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.planner.ToAggregator;

public class Irate
extends TimeSeriesAggregateFunction
implements OptionalArgument,
ToAggregator {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Irate", Irate::new);
    private final Expression timestamp;

    @FunctionInfo(type=FunctionType.TIME_SERIES_AGGREGATE, returnType={"double"}, description="Calculates the irate of a counter field. irate is the per-second rate of increase between the last two data points (it ignores all but the last two data points in each time period). This function is very similar to rate, but is more responsive to recent changes in the rate of increase.", appliesTo={@FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.PREVIEW, version="9.2.0")}, preview=true, examples={@Example(file="k8s-timeseries-irate", tag="irate")})
    public Irate(Source source, @Param(name="field", type={"counter_long", "counter_integer", "counter_double"}) Expression field) {
        this(source, field, (Expression)new UnresolvedAttribute(source, "@timestamp"));
    }

    public Irate(Source source, @Param(name="field", type={"counter_long", "counter_integer", "counter_double"}) Expression field, Expression timestamp) {
        this(source, field, (Expression)Literal.TRUE, timestamp);
    }

    private Irate(Source source, Expression field, Expression filter, List<Expression> children) {
        this(source, field, filter, children.getFirst());
    }

    private Irate(Source source, Expression field, Expression filter, Expression timestamp) {
        super(source, field, filter, List.of(timestamp));
        this.timestamp = timestamp;
    }

    public Irate(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class), in.readNamedWriteableCollectionAsList(Expression.class));
    }

    public String getWriteableName() {
        return Irate.ENTRY.name;
    }

    protected NodeInfo<Irate> info() {
        return NodeInfo.create((Node)this, Irate::new, (Object)this.field(), (Object)this.timestamp);
    }

    public Irate replaceChildren(List<Expression> newChildren) {
        if (newChildren.size() != 3) {
            assert (false) : "expected 3 children for field, filter, @timestamp; got " + String.valueOf(newChildren);
            throw new IllegalArgumentException("expected 3 children for field, filter, @timestamp; got " + String.valueOf(newChildren));
        }
        return new Irate(this.source(), newChildren.get(0), newChildren.get(1), newChildren.get(2));
    }

    @Override
    public Irate withFilter(Expression filter) {
        return new Irate(this.source(), this.field(), filter, this.timestamp);
    }

    public DataType dataType() {
        return DataType.DOUBLE;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return TypeResolutions.isType((Expression)this.field(), dt -> DataType.isCounter((DataType)dt), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST, (String[])new String[]{"counter_long", "counter_integer", "counter_double"});
    }

    @Override
    public AggregatorFunctionSupplier supplier() {
        DataType type = this.field().dataType();
        return switch (type) {
            case DataType.COUNTER_LONG -> new IrateLongAggregatorFunctionSupplier(false);
            case DataType.COUNTER_INTEGER -> new IrateIntAggregatorFunctionSupplier(false);
            case DataType.COUNTER_DOUBLE -> new IrateDoubleAggregatorFunctionSupplier(false);
            default -> throw EsqlIllegalArgumentException.illegalDataType(type);
        };
    }

    @Override
    public Irate perTimeSeriesAggregation() {
        return this;
    }

    public String toString() {
        return "irate(" + String.valueOf(this.field()) + ")";
    }
}

