/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.action;

import java.io.IOException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;

public class EsqlResolveFieldsResponse
extends ActionResponse {
    private static final TransportVersion RESOLVE_FIELDS_RESPONSE_CREATED_TV = TransportVersion.fromName((String)"esql_resolve_fields_response_created");
    private final FieldCapabilitiesResponse caps;
    private final TransportVersion minTransportVersion;

    public EsqlResolveFieldsResponse(FieldCapabilitiesResponse caps, TransportVersion minTransportVersion) {
        this.caps = caps;
        this.minTransportVersion = minTransportVersion;
    }

    public EsqlResolveFieldsResponse(StreamInput in) throws IOException {
        this.caps = new FieldCapabilitiesResponse(in);
        this.minTransportVersion = in.getTransportVersion().supports(RESOLVE_FIELDS_RESPONSE_CREATED_TV) && in.readBoolean() ? TransportVersion.readVersion((StreamInput)in) : null;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.caps.writeTo(out);
        if (out.getTransportVersion().supports(RESOLVE_FIELDS_RESPONSE_CREATED_TV)) {
            out.writeBoolean(this.minTransportVersion != null);
            if (this.minTransportVersion != null) {
                TransportVersion.writeVersion((TransportVersion)this.minTransportVersion, (StreamOutput)out);
            }
        }
    }

    public FieldCapabilitiesResponse caps() {
        return this.caps;
    }

    @Nullable
    public TransportVersion minTransportVersion() {
        return this.minTransportVersion;
    }
}

