/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.deprecation;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.MasterNodeReadRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.deprecation.DeprecationIssue;

public class DeprecationInfoAction
extends ActionType<Response> {
    public static final DeprecationInfoAction INSTANCE = new DeprecationInfoAction();
    public static final String NAME = "cluster:admin/xpack/deprecation/info";

    private DeprecationInfoAction() {
        super(NAME);
    }

    public static class Request
    extends MasterNodeReadRequest<Request>
    implements IndicesRequest.Replaceable {
        private static final IndicesOptions INDICES_OPTIONS = IndicesOptions.fromOptions((boolean)false, (boolean)true, (boolean)true, (boolean)true, (boolean)true);
        private String[] indices;

        public Request(TimeValue masterNodeTimeout, String ... indices) {
            super(masterNodeTimeout);
            this.indices = indices;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.indices = in.readStringArray();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeStringArray(this.indices);
        }

        public String[] indices() {
            return this.indices;
        }

        public Request indices(String ... indices) {
            this.indices = indices;
            return this;
        }

        public IndicesOptions indicesOptions() {
            return INDICES_OPTIONS;
        }

        public boolean includeDataStreams() {
            return true;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (this.indices == null) {
                validationException = ValidateActions.addValidationError((String)"index/indices is missing", validationException);
            }
            return validationException;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Arrays.equals(this.indices, request.indices);
        }

        public int hashCode() {
            return Objects.hash(Arrays.hashCode(this.indices));
        }
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        static final Set<String> RESERVED_NAMES = Set.of("cluster_settings", "node_settings", "index_settings", "data_streams", "templates", "ilm_policies");
        static final Set<String> RESOURCE_CHECKER_FIELD_NAMES = Set.of("index_settings", "data_streams", "templates", "ilm_policies");
        private final List<DeprecationIssue> clusterSettingsIssues;
        private final List<DeprecationIssue> nodeSettingsIssues;
        private final Map<String, Map<String, List<DeprecationIssue>>> resourceDeprecationIssues;
        private final Map<String, List<DeprecationIssue>> pluginSettingsIssues;

        public Response(StreamInput in) throws IOException {
            HashMap<String, Map> mutableResourceDeprecations;
            this.clusterSettingsIssues = in.readCollectionAsList(DeprecationIssue::new);
            this.nodeSettingsIssues = in.readCollectionAsList(DeprecationIssue::new);
            HashMap<String, Map> hashMap = mutableResourceDeprecations = !in.getTransportVersion().supports(TransportVersions.V_8_18_0) ? new HashMap<String, Map>() : Map.of();
            if (!in.getTransportVersion().supports(TransportVersions.V_8_18_0)) {
                mutableResourceDeprecations.put("index_settings", in.readMapOfLists(DeprecationIssue::new));
            }
            if (in.getTransportVersion().supports(TransportVersions.V_8_17_0) && !in.getTransportVersion().supports(TransportVersions.V_8_18_0)) {
                mutableResourceDeprecations.put("data_streams", in.readMapOfLists(DeprecationIssue::new));
            }
            this.pluginSettingsIssues = in.readMapOfLists(DeprecationIssue::new);
            this.resourceDeprecationIssues = in.getTransportVersion().supports(TransportVersions.V_8_18_0) ? in.readMap(in2 -> in2.readMapOfLists(DeprecationIssue::new)) : Collections.unmodifiableMap(mutableResourceDeprecations);
        }

        public Response(List<DeprecationIssue> clusterSettingsIssues, List<DeprecationIssue> nodeSettingsIssues, Map<String, Map<String, List<DeprecationIssue>>> resourceDeprecationIssues, Map<String, List<DeprecationIssue>> pluginSettingsIssues) {
            this.clusterSettingsIssues = clusterSettingsIssues;
            this.nodeSettingsIssues = nodeSettingsIssues;
            this.resourceDeprecationIssues = resourceDeprecationIssues;
            Set intersection = Sets.intersection(RESERVED_NAMES, pluginSettingsIssues.keySet());
            if (!intersection.isEmpty()) {
                throw new ElasticsearchStatusException("Unable to discover deprecations as plugin deprecation names overlap with reserved names {}", RestStatus.INTERNAL_SERVER_ERROR, new Object[]{intersection});
            }
            this.pluginSettingsIssues = pluginSettingsIssues;
        }

        public List<DeprecationIssue> getClusterSettingsIssues() {
            return this.clusterSettingsIssues;
        }

        public List<DeprecationIssue> getNodeSettingsIssues() {
            return this.nodeSettingsIssues;
        }

        public Map<String, List<DeprecationIssue>> getIndexSettingsIssues() {
            return this.resourceDeprecationIssues.getOrDefault("index_settings", Map.of());
        }

        public Map<String, List<DeprecationIssue>> getPluginSettingsIssues() {
            return this.pluginSettingsIssues;
        }

        public Map<String, List<DeprecationIssue>> getDataStreamDeprecationIssues() {
            return this.resourceDeprecationIssues.getOrDefault("data_streams", Map.of());
        }

        public Map<String, List<DeprecationIssue>> getTemplateDeprecationIssues() {
            return this.resourceDeprecationIssues.getOrDefault("templates", Map.of());
        }

        public Map<String, List<DeprecationIssue>> getIlmPolicyDeprecationIssues() {
            return this.resourceDeprecationIssues.getOrDefault("ilm_policies", Map.of());
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeCollection(this.clusterSettingsIssues);
            out.writeCollection(this.nodeSettingsIssues);
            if (!out.getTransportVersion().supports(TransportVersions.V_8_18_0)) {
                out.writeMap(this.getIndexSettingsIssues(), StreamOutput::writeCollection);
            }
            if (out.getTransportVersion().supports(TransportVersions.V_8_17_0) && !out.getTransportVersion().supports(TransportVersions.V_8_18_0)) {
                out.writeMap(this.getDataStreamDeprecationIssues(), StreamOutput::writeCollection);
            }
            out.writeMap(this.pluginSettingsIssues, StreamOutput::writeCollection);
            if (out.getTransportVersion().supports(TransportVersions.V_8_18_0)) {
                out.writeMap(this.resourceDeprecationIssues, (o, v) -> o.writeMap(v, StreamOutput::writeCollection));
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject().array("cluster_settings", this.clusterSettingsIssues.toArray()).array("node_settings", this.nodeSettingsIssues.toArray()).mapContents(this.resourceDeprecationIssues).mapContents(this.pluginSettingsIssues);
            for (String fieldName : RESOURCE_CHECKER_FIELD_NAMES) {
                if (this.resourceDeprecationIssues.containsKey(fieldName)) continue;
                builder.startObject(fieldName).endObject();
            }
            return builder.endObject();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)((Object)o);
            return Objects.equals(this.clusterSettingsIssues, response.clusterSettingsIssues) && Objects.equals(this.nodeSettingsIssues, response.nodeSettingsIssues) && Objects.equals(this.resourceDeprecationIssues, response.resourceDeprecationIssues) && Objects.equals(this.pluginSettingsIssues, response.pluginSettingsIssues);
        }

        public int hashCode() {
            return Objects.hash(this.clusterSettingsIssues, this.nodeSettingsIssues, this.resourceDeprecationIssues, this.pluginSettingsIssues);
        }
    }
}

