/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Enumerated;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DecodeableControl;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.ldap.sdk.unboundidds.controls.JoinedEntry;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class JoinResultControl
extends Control
implements DecodeableControl {
    @NotNull
    public static final String JOIN_RESULT_OID = "1.3.6.1.4.1.30221.2.5.9";
    private static final byte TYPE_REFERRAL_URLS = -93;
    private static final byte TYPE_JOIN_RESULTS = -92;
    private static final long serialVersionUID = 681831114773253358L;
    @NotNull
    private final List<JoinedEntry> joinResults;
    @NotNull
    private final List<String> referralURLs;
    @NotNull
    private final ResultCode resultCode;
    @Nullable
    private final String diagnosticMessage;
    @Nullable
    private final String matchedDN;

    JoinResultControl() {
        this.resultCode = null;
        this.diagnosticMessage = null;
        this.matchedDN = null;
        this.referralURLs = null;
        this.joinResults = null;
    }

    public JoinResultControl(@Nullable List<JoinedEntry> joinResults) {
        this(ResultCode.SUCCESS, null, null, null, joinResults);
    }

    public JoinResultControl(@NotNull ResultCode resultCode, @Nullable String diagnosticMessage, @Nullable String matchedDN, @Nullable List<String> referralURLs, @Nullable List<JoinedEntry> joinResults) {
        super(JOIN_RESULT_OID, false, JoinResultControl.encodeValue(resultCode, diagnosticMessage, matchedDN, referralURLs, joinResults));
        this.resultCode = resultCode;
        this.diagnosticMessage = diagnosticMessage;
        this.matchedDN = matchedDN;
        this.referralURLs = referralURLs == null ? Collections.emptyList() : Collections.unmodifiableList(referralURLs);
        this.joinResults = joinResults == null ? Collections.emptyList() : Collections.unmodifiableList(joinResults);
    }

    public JoinResultControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        super(oid, isCritical, value);
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JOIN_RESULT_NO_VALUE.get());
        }
        try {
            ASN1Element valueElement = ASN1Element.decode(value.getValue());
            ASN1Element[] elements = ASN1Sequence.decodeAsSequence(valueElement).elements();
            this.resultCode = ResultCode.valueOf(ASN1Enumerated.decodeAsEnumerated(elements[0]).intValue());
            String matchedDNStr = ASN1OctetString.decodeAsOctetString(elements[1]).stringValue();
            this.matchedDN = matchedDNStr.isEmpty() ? null : matchedDNStr;
            String diagnosticMessageStr = ASN1OctetString.decodeAsOctetString(elements[2]).stringValue();
            this.diagnosticMessage = diagnosticMessageStr.isEmpty() ? null : diagnosticMessageStr;
            ArrayList<String> refs = new ArrayList<String>(5);
            ArrayList<JoinedEntry> entries = new ArrayList<JoinedEntry>(20);
            block6: for (int i = 3; i < elements.length; ++i) {
                switch (elements[i].getType()) {
                    case -93: {
                        ASN1Element[] refElements;
                        for (ASN1Element e : refElements = ASN1Sequence.decodeAsSequence(elements[i]).elements()) {
                            refs.add(ASN1OctetString.decodeAsOctetString(e).stringValue());
                        }
                        continue block6;
                    }
                    case -92: {
                        ASN1Element[] entryElements;
                        for (ASN1Element e : entryElements = ASN1Sequence.decodeAsSequence(elements[i]).elements()) {
                            entries.add(JoinedEntry.decode(e));
                        }
                        continue block6;
                    }
                    default: {
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JOIN_RESULT_INVALID_ELEMENT_TYPE.get(StaticUtils.toHex(elements[i].getType())));
                    }
                }
            }
            this.referralURLs = Collections.unmodifiableList(refs);
            this.joinResults = Collections.unmodifiableList(entries);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JOIN_RESULT_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @NotNull
    private static ASN1OctetString encodeValue(@NotNull ResultCode resultCode, @Nullable String diagnosticMessage, @Nullable String matchedDN, @Nullable List<String> referralURLs, @Nullable List<JoinedEntry> joinResults) {
        Validator.ensureNotNull(resultCode);
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(5);
        elements.add(new ASN1Enumerated(resultCode.intValue()));
        if (matchedDN == null) {
            elements.add(new ASN1OctetString());
        } else {
            elements.add(new ASN1OctetString(matchedDN));
        }
        if (diagnosticMessage == null) {
            elements.add(new ASN1OctetString());
        } else {
            elements.add(new ASN1OctetString(diagnosticMessage));
        }
        if (referralURLs != null && !referralURLs.isEmpty()) {
            ArrayList<ASN1OctetString> refElements = new ArrayList<ASN1OctetString>(referralURLs.size());
            for (String s : referralURLs) {
                refElements.add(new ASN1OctetString(s));
            }
            elements.add(new ASN1Sequence(-93, refElements));
        }
        if (joinResults == null || joinResults.isEmpty()) {
            elements.add(new ASN1Sequence(-92));
        } else {
            ArrayList<ASN1Element> entryElements = new ArrayList<ASN1Element>(joinResults.size());
            for (JoinedEntry e : joinResults) {
                entryElements.add(e.encode());
            }
            elements.add(new ASN1Sequence(-92, entryElements));
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    @NotNull
    public ResultCode getResultCode() {
        return this.resultCode;
    }

    @Nullable
    public String getDiagnosticMessage() {
        return this.diagnosticMessage;
    }

    @Nullable
    public String getMatchedDN() {
        return this.matchedDN;
    }

    @NotNull
    public List<String> getReferralURLs() {
        return this.referralURLs;
    }

    @NotNull
    public List<JoinedEntry> getJoinResults() {
        return this.joinResults;
    }

    @Override
    @NotNull
    public JoinResultControl decodeControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        return new JoinResultControl(oid, isCritical, value);
    }

    @Nullable
    public static JoinResultControl get(@NotNull SearchResultEntry entry) throws LDAPException {
        Control c = entry.getControl(JOIN_RESULT_OID);
        if (c == null) {
            return null;
        }
        if (c instanceof JoinResultControl) {
            return (JoinResultControl)c;
        }
        return new JoinResultControl(c.getOID(), c.isCritical(), c.getValue());
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_JOIN_RESULT.get();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("JoinResultControl(resultCode='");
        buffer.append(this.resultCode.getName());
        buffer.append("', diagnosticMessage='");
        if (this.diagnosticMessage != null) {
            buffer.append(this.diagnosticMessage);
        }
        buffer.append("', matchedDN='");
        if (this.matchedDN != null) {
            buffer.append(this.matchedDN);
        }
        buffer.append("', referralURLs={");
        Iterator<String> refIterator = this.referralURLs.iterator();
        while (refIterator.hasNext()) {
            buffer.append(refIterator.next());
            if (!refIterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("}, joinResults={");
        Iterator<JoinedEntry> entryIterator = this.joinResults.iterator();
        while (entryIterator.hasNext()) {
            entryIterator.next().toString(buffer);
            if (!entryIterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("})");
    }
}

