/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.elastic.request;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.message.BasicHeader;
import org.elasticsearch.common.Strings;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.services.elastic.ElasticInferenceServiceUsageContext;
import org.elasticsearch.xpack.inference.services.elastic.densetextembeddings.ElasticInferenceServiceDenseTextEmbeddingsModel;
import org.elasticsearch.xpack.inference.services.elastic.request.ElasticInferenceServiceDenseTextEmbeddingsRequestEntity;
import org.elasticsearch.xpack.inference.services.elastic.request.ElasticInferenceServiceRequest;
import org.elasticsearch.xpack.inference.services.elastic.request.ElasticInferenceServiceRequestMetadata;
import org.elasticsearch.xpack.inference.telemetry.TraceContext;
import org.elasticsearch.xpack.inference.telemetry.TraceContextHandler;

public class ElasticInferenceServiceDenseTextEmbeddingsRequest
extends ElasticInferenceServiceRequest {
    private final URI uri;
    private final ElasticInferenceServiceDenseTextEmbeddingsModel model;
    private final List<String> inputs;
    private final TraceContextHandler traceContextHandler;
    private final InputType inputType;

    public ElasticInferenceServiceDenseTextEmbeddingsRequest(ElasticInferenceServiceDenseTextEmbeddingsModel model, List<String> inputs, TraceContext traceContext, ElasticInferenceServiceRequestMetadata metadata, InputType inputType) {
        super(metadata);
        this.inputs = inputs;
        this.model = Objects.requireNonNull(model);
        this.uri = model.uri();
        this.traceContextHandler = new TraceContextHandler(traceContext);
        this.inputType = inputType;
    }

    @Override
    public HttpRequestBase createHttpRequestBase() {
        HttpPost httpPost = new HttpPost(this.uri);
        ElasticInferenceServiceUsageContext usageContext = ElasticInferenceServiceUsageContext.fromInputType(this.inputType);
        String requestEntity = Strings.toString((ToXContent)new ElasticInferenceServiceDenseTextEmbeddingsRequestEntity(this.inputs, this.model.getServiceSettings().modelId(), usageContext));
        ByteArrayEntity byteEntity = new ByteArrayEntity(requestEntity.getBytes(StandardCharsets.UTF_8));
        httpPost.setEntity((HttpEntity)byteEntity);
        this.traceContextHandler.propagateTraceContext((HttpRequestBase)httpPost);
        httpPost.setHeader((Header)new BasicHeader("Content-Type", XContentType.JSON.mediaType()));
        httpPost.setHeader((Header)new BasicHeader("X-elastic-product-use-case", usageContext.productUseCaseHeaderValue()));
        return httpPost;
    }

    public TraceContext getTraceContext() {
        return this.traceContextHandler.traceContext();
    }

    @Override
    public String getInferenceEntityId() {
        return this.model.getInferenceEntityId();
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public Request truncate() {
        return this;
    }

    @Override
    public boolean[] getTruncationInfo() {
        return null;
    }
}

