/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.elastic;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;
import org.elasticsearch.inference.ChunkInferenceInput;
import org.elasticsearch.inference.ChunkedInference;
import org.elasticsearch.inference.ChunkingSettings;
import org.elasticsearch.inference.EmptySecretSettings;
import org.elasticsearch.inference.EmptyTaskSettings;
import org.elasticsearch.inference.InferenceService;
import org.elasticsearch.inference.InferenceServiceConfiguration;
import org.elasticsearch.inference.InferenceServiceExtension;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.inference.MinimalServiceSettings;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.SecretSettings;
import org.elasticsearch.inference.SettingsConfiguration;
import org.elasticsearch.inference.SimilarityMeasure;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.inference.configuration.SettingsConfigurationFieldType;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.inference.results.ChunkedInferenceEmbedding;
import org.elasticsearch.xpack.core.inference.results.ChunkedInferenceError;
import org.elasticsearch.xpack.core.inference.results.ResultUtils;
import org.elasticsearch.xpack.core.inference.results.SparseEmbeddingResults;
import org.elasticsearch.xpack.core.ml.inference.results.ErrorInferenceResults;
import org.elasticsearch.xpack.inference.chunking.ChunkingSettingsBuilder;
import org.elasticsearch.xpack.inference.chunking.EmbeddingRequestChunker;
import org.elasticsearch.xpack.inference.external.action.ActionUtils;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.SenderExecutableAction;
import org.elasticsearch.xpack.inference.external.http.sender.EmbeddingsInput;
import org.elasticsearch.xpack.inference.external.http.sender.HttpRequestSender;
import org.elasticsearch.xpack.inference.external.http.sender.InferenceInputs;
import org.elasticsearch.xpack.inference.external.http.sender.UnifiedChatInput;
import org.elasticsearch.xpack.inference.registry.ModelRegistry;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.SenderService;
import org.elasticsearch.xpack.inference.services.ServiceComponents;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.elastic.DefaultModelConfig;
import org.elasticsearch.xpack.inference.services.elastic.ElasticInferenceServiceComponents;
import org.elasticsearch.xpack.inference.services.elastic.ElasticInferenceServiceExecutableActionModel;
import org.elasticsearch.xpack.inference.services.elastic.ElasticInferenceServiceModel;
import org.elasticsearch.xpack.inference.services.elastic.ElasticInferenceServiceSettings;
import org.elasticsearch.xpack.inference.services.elastic.ElasticInferenceServiceUnifiedCompletionRequestManager;
import org.elasticsearch.xpack.inference.services.elastic.action.ElasticInferenceServiceActionCreator;
import org.elasticsearch.xpack.inference.services.elastic.authorization.ElasticInferenceServiceAuthorizationHandler;
import org.elasticsearch.xpack.inference.services.elastic.authorization.ElasticInferenceServiceAuthorizationRequestHandler;
import org.elasticsearch.xpack.inference.services.elastic.completion.ElasticInferenceServiceCompletionModel;
import org.elasticsearch.xpack.inference.services.elastic.completion.ElasticInferenceServiceCompletionServiceSettings;
import org.elasticsearch.xpack.inference.services.elastic.densetextembeddings.ElasticInferenceServiceDenseTextEmbeddingsModel;
import org.elasticsearch.xpack.inference.services.elastic.densetextembeddings.ElasticInferenceServiceDenseTextEmbeddingsServiceSettings;
import org.elasticsearch.xpack.inference.services.elastic.rerank.ElasticInferenceServiceRerankModel;
import org.elasticsearch.xpack.inference.services.elastic.rerank.ElasticInferenceServiceRerankServiceSettings;
import org.elasticsearch.xpack.inference.services.elastic.sparseembeddings.ElasticInferenceServiceSparseEmbeddingsModel;
import org.elasticsearch.xpack.inference.services.elastic.sparseembeddings.ElasticInferenceServiceSparseEmbeddingsServiceSettings;
import org.elasticsearch.xpack.inference.telemetry.TraceContext;

public class ElasticInferenceService
extends SenderService {
    public static final String NAME = "elastic";
    public static final String ELASTIC_INFERENCE_SERVICE_IDENTIFIER = "Elastic Inference Service";
    public static final Integer DENSE_TEXT_EMBEDDINGS_DIMENSIONS = 1024;
    public static final Integer SPARSE_TEXT_EMBEDDING_MAX_BATCH_SIZE = 16;
    private static final EnumSet<TaskType> IMPLEMENTED_TASK_TYPES = EnumSet.of(TaskType.SPARSE_EMBEDDING, TaskType.CHAT_COMPLETION, TaskType.RERANK, TaskType.TEXT_EMBEDDING);
    private static final String SERVICE_NAME = "Elastic";
    private static final Integer DENSE_TEXT_EMBEDDINGS_MAX_BATCH_SIZE = 16;
    static final String DEFAULT_CHAT_COMPLETION_MODEL_ID_V1 = "rainbow-sprinkles";
    static final String DEFAULT_CHAT_COMPLETION_ENDPOINT_ID_V1 = ElasticInferenceService.defaultEndpointId("rainbow-sprinkles");
    static final String DEFAULT_ELSER_2_MODEL_ID = "elser_model_2";
    static final String DEFAULT_ELSER_ENDPOINT_ID_V2 = ElasticInferenceService.defaultEndpointId("elser-2");
    static final String DEFAULT_MULTILINGUAL_EMBED_MODEL_ID = "multilingual-embed-v1";
    static final String DEFAULT_MULTILINGUAL_EMBED_ENDPOINT_ID = ElasticInferenceService.defaultEndpointId("multilingual-embed-v1");
    static final String DEFAULT_RERANK_MODEL_ID_V1 = "rerank-v1";
    static final String DEFAULT_RERANK_ENDPOINT_ID_V1 = ElasticInferenceService.defaultEndpointId("rerank-v1");
    private static final EnumSet<TaskType> SUPPORTED_INFERENCE_ACTION_TASK_TYPES = EnumSet.of(TaskType.SPARSE_EMBEDDING, TaskType.RERANK, TaskType.TEXT_EMBEDDING);
    private final ElasticInferenceServiceComponents elasticInferenceServiceComponents;
    private final ElasticInferenceServiceAuthorizationHandler authorizationHandler;

    public static String defaultEndpointId(String modelId) {
        return org.elasticsearch.common.Strings.format((String)".%s-elastic", (Object[])new Object[]{modelId});
    }

    public ElasticInferenceService(HttpRequestSender.Factory factory, ServiceComponents serviceComponents, ElasticInferenceServiceSettings elasticInferenceServiceSettings, ModelRegistry modelRegistry, ElasticInferenceServiceAuthorizationRequestHandler authorizationRequestHandler, InferenceServiceExtension.InferenceServiceFactoryContext context) {
        this(factory, serviceComponents, elasticInferenceServiceSettings, modelRegistry, authorizationRequestHandler, context.clusterService());
    }

    public ElasticInferenceService(HttpRequestSender.Factory factory, ServiceComponents serviceComponents, ElasticInferenceServiceSettings elasticInferenceServiceSettings, ModelRegistry modelRegistry, ElasticInferenceServiceAuthorizationRequestHandler authorizationRequestHandler, ClusterService clusterService) {
        super(factory, serviceComponents, clusterService);
        this.elasticInferenceServiceComponents = new ElasticInferenceServiceComponents(elasticInferenceServiceSettings.getElasticInferenceServiceUrl());
        this.authorizationHandler = new ElasticInferenceServiceAuthorizationHandler(serviceComponents, modelRegistry, authorizationRequestHandler, ElasticInferenceService.initDefaultEndpoints(this.elasticInferenceServiceComponents), IMPLEMENTED_TASK_TYPES, this, this.getSender(), elasticInferenceServiceSettings);
    }

    private static Map<String, DefaultModelConfig> initDefaultEndpoints(ElasticInferenceServiceComponents elasticInferenceServiceComponents) {
        return Map.of(DEFAULT_CHAT_COMPLETION_MODEL_ID_V1, new DefaultModelConfig(new ElasticInferenceServiceCompletionModel(DEFAULT_CHAT_COMPLETION_ENDPOINT_ID_V1, TaskType.CHAT_COMPLETION, NAME, new ElasticInferenceServiceCompletionServiceSettings(DEFAULT_CHAT_COMPLETION_MODEL_ID_V1), (TaskSettings)EmptyTaskSettings.INSTANCE, (SecretSettings)EmptySecretSettings.INSTANCE, elasticInferenceServiceComponents), MinimalServiceSettings.chatCompletion((String)NAME)), DEFAULT_ELSER_2_MODEL_ID, new DefaultModelConfig(new ElasticInferenceServiceSparseEmbeddingsModel(DEFAULT_ELSER_ENDPOINT_ID_V2, TaskType.SPARSE_EMBEDDING, NAME, new ElasticInferenceServiceSparseEmbeddingsServiceSettings(DEFAULT_ELSER_2_MODEL_ID, null), (TaskSettings)EmptyTaskSettings.INSTANCE, (SecretSettings)EmptySecretSettings.INSTANCE, elasticInferenceServiceComponents, ChunkingSettingsBuilder.DEFAULT_SETTINGS), MinimalServiceSettings.sparseEmbedding((String)NAME)), DEFAULT_MULTILINGUAL_EMBED_MODEL_ID, new DefaultModelConfig(new ElasticInferenceServiceDenseTextEmbeddingsModel(DEFAULT_MULTILINGUAL_EMBED_ENDPOINT_ID, TaskType.TEXT_EMBEDDING, NAME, new ElasticInferenceServiceDenseTextEmbeddingsServiceSettings(DEFAULT_MULTILINGUAL_EMBED_MODEL_ID, ElasticInferenceService.defaultDenseTextEmbeddingsSimilarity(), null, null), (TaskSettings)EmptyTaskSettings.INSTANCE, (SecretSettings)EmptySecretSettings.INSTANCE, elasticInferenceServiceComponents, ChunkingSettingsBuilder.DEFAULT_SETTINGS), MinimalServiceSettings.textEmbedding((String)NAME, (int)DENSE_TEXT_EMBEDDINGS_DIMENSIONS, (SimilarityMeasure)ElasticInferenceService.defaultDenseTextEmbeddingsSimilarity(), (DenseVectorFieldMapper.ElementType)DenseVectorFieldMapper.ElementType.FLOAT)), DEFAULT_RERANK_MODEL_ID_V1, new DefaultModelConfig(new ElasticInferenceServiceRerankModel(DEFAULT_RERANK_ENDPOINT_ID_V1, TaskType.RERANK, NAME, new ElasticInferenceServiceRerankServiceSettings(DEFAULT_RERANK_MODEL_ID_V1), (TaskSettings)EmptyTaskSettings.INSTANCE, (SecretSettings)EmptySecretSettings.INSTANCE, elasticInferenceServiceComponents), MinimalServiceSettings.rerank((String)NAME)));
    }

    public void onNodeStarted() {
        this.authorizationHandler.init();
    }

    @Override
    protected void validateRerankParameters(Boolean returnDocuments, Integer topN, ValidationException validationException) {
        if (returnDocuments != null) {
            validationException.addValidationError(Strings.format((String)"Invalid return_documents [%s]. The return_documents option is not supported by this service", (Object[])new Object[]{returnDocuments}));
        }
    }

    public void waitForFirstAuthorizationToComplete(TimeValue waitTime) {
        this.authorizationHandler.waitForAuthorizationToComplete(waitTime);
    }

    public Set<TaskType> supportedStreamingTasks() {
        return EnumSet.of(TaskType.CHAT_COMPLETION);
    }

    public List<InferenceService.DefaultConfigId> defaultConfigIds() {
        return this.authorizationHandler.defaultConfigIds();
    }

    public void defaultConfigs(ActionListener<List<Model>> defaultsListener) {
        this.authorizationHandler.defaultConfigs(defaultsListener);
    }

    @Override
    protected void doUnifiedCompletionInfer(Model model, UnifiedChatInput inputs, TimeValue timeout, ActionListener<InferenceServiceResults> listener) {
        if (!(model instanceof ElasticInferenceServiceCompletionModel)) {
            listener.onFailure((Exception)((Object)ServiceUtils.createInvalidModelException(model)));
            return;
        }
        TraceContext currentTraceInfo = this.getCurrentTraceInfo();
        ElasticInferenceServiceCompletionModel completionModel = (ElasticInferenceServiceCompletionModel)model;
        ElasticInferenceServiceCompletionModel overriddenModel = ElasticInferenceServiceCompletionModel.of(completionModel, inputs.getRequest());
        String errorMessage = ActionUtils.constructFailedToSendRequestMessage(String.format(Locale.ROOT, "%s completions", ELASTIC_INFERENCE_SERVICE_IDENTIFIER));
        ElasticInferenceServiceUnifiedCompletionRequestManager requestManager = ElasticInferenceServiceUnifiedCompletionRequestManager.of(overriddenModel, this.getServiceComponents().threadPool(), currentTraceInfo);
        SenderExecutableAction action = new SenderExecutableAction(this.getSender(), requestManager, errorMessage);
        action.execute(inputs, timeout, listener);
    }

    @Override
    protected void doInfer(Model model, InferenceInputs inputs, Map<String, Object> taskSettings, TimeValue timeout, ActionListener<InferenceServiceResults> listener) {
        if (!SUPPORTED_INFERENCE_ACTION_TASK_TYPES.contains(model.getTaskType())) {
            Object responseString = ServiceUtils.unsupportedTaskTypeForInference(model, SUPPORTED_INFERENCE_ACTION_TASK_TYPES);
            if (model.getTaskType() == TaskType.CHAT_COMPLETION) {
                responseString = (String)responseString + " " + ServiceUtils.useChatCompletionUrlMessage(model);
            }
            listener.onFailure((Exception)((Object)new ElasticsearchStatusException((String)responseString, RestStatus.BAD_REQUEST, new Object[0])));
            return;
        }
        if (!(model instanceof ElasticInferenceServiceExecutableActionModel)) {
            listener.onFailure((Exception)((Object)ServiceUtils.createInvalidModelException(model)));
            return;
        }
        TraceContext currentTraceInfo = this.getCurrentTraceInfo();
        ElasticInferenceServiceExecutableActionModel elasticInferenceServiceModel = (ElasticInferenceServiceExecutableActionModel)model;
        ElasticInferenceServiceActionCreator actionCreator = new ElasticInferenceServiceActionCreator(this.getSender(), this.getServiceComponents(), currentTraceInfo);
        ExecutableAction action = elasticInferenceServiceModel.accept(actionCreator, taskSettings);
        action.execute(inputs, timeout, listener);
    }

    @Override
    protected void validateInputType(InputType inputType, Model model, ValidationException validationException) {
    }

    @Override
    protected void doChunkedInfer(Model model, List<ChunkInferenceInput> inputs, Map<String, Object> taskSettings, InputType inputType, TimeValue timeout, ActionListener<List<ChunkedInference>> listener) {
        if (model instanceof ElasticInferenceServiceDenseTextEmbeddingsModel) {
            ElasticInferenceServiceDenseTextEmbeddingsModel denseTextEmbeddingsModel = (ElasticInferenceServiceDenseTextEmbeddingsModel)model;
            ElasticInferenceServiceActionCreator actionCreator = new ElasticInferenceServiceActionCreator(this.getSender(), this.getServiceComponents(), this.getCurrentTraceInfo());
            List<EmbeddingRequestChunker.BatchRequestAndListener> batchedRequests = new EmbeddingRequestChunker(inputs, DENSE_TEXT_EMBEDDINGS_MAX_BATCH_SIZE, denseTextEmbeddingsModel.getConfigurations().getChunkingSettings()).batchRequestsWithListeners(listener);
            for (EmbeddingRequestChunker.BatchRequestAndListener request : batchedRequests) {
                ExecutableAction action = denseTextEmbeddingsModel.accept(actionCreator, taskSettings);
                action.execute(new EmbeddingsInput(request.batch().inputs(), inputType), timeout, request.listener());
            }
            return;
        }
        if (model instanceof ElasticInferenceServiceSparseEmbeddingsModel) {
            ElasticInferenceServiceSparseEmbeddingsModel sparseTextEmbeddingsModel = (ElasticInferenceServiceSparseEmbeddingsModel)model;
            ElasticInferenceServiceActionCreator actionCreator = new ElasticInferenceServiceActionCreator(this.getSender(), this.getServiceComponents(), this.getCurrentTraceInfo());
            List<EmbeddingRequestChunker.BatchRequestAndListener> batchedRequests = new EmbeddingRequestChunker(inputs, SPARSE_TEXT_EMBEDDING_MAX_BATCH_SIZE, model.getConfigurations().getChunkingSettings()).batchRequestsWithListeners(listener);
            for (EmbeddingRequestChunker.BatchRequestAndListener request : batchedRequests) {
                ExecutableAction action = sparseTextEmbeddingsModel.accept(actionCreator, taskSettings);
                action.execute(new EmbeddingsInput(request.batch().inputs(), inputType), timeout, request.listener());
            }
            return;
        }
        listener.onFailure((Exception)((Object)ServiceUtils.createInvalidModelException(model)));
    }

    public String name() {
        return NAME;
    }

    public void parseRequestConfig(String inferenceEntityId, TaskType taskType, Map<String, Object> config, ActionListener<Model> parsedModelListener) {
        try {
            Map<String, Object> serviceSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(config, "service_settings");
            Map<String, Object> taskSettingsMap = ServiceUtils.removeFromMapOrDefaultEmpty(config, "task_settings");
            ChunkingSettings chunkingSettings = null;
            if (TaskType.SPARSE_EMBEDDING.equals((Object)taskType) || TaskType.TEXT_EMBEDDING.equals((Object)taskType)) {
                chunkingSettings = ChunkingSettingsBuilder.fromMap(ServiceUtils.removeFromMapOrDefaultEmpty(config, "chunking_settings"));
            }
            ElasticInferenceServiceModel model = ElasticInferenceService.createModel(inferenceEntityId, taskType, serviceSettingsMap, taskSettingsMap, chunkingSettings, serviceSettingsMap, this.elasticInferenceServiceComponents, ConfigurationParseContext.REQUEST);
            ServiceUtils.throwIfNotEmptyMap(config, NAME);
            ServiceUtils.throwIfNotEmptyMap(serviceSettingsMap, NAME);
            ServiceUtils.throwIfNotEmptyMap(taskSettingsMap, NAME);
            parsedModelListener.onResponse((Object)model);
        }
        catch (Exception e) {
            parsedModelListener.onFailure(e);
        }
    }

    public InferenceServiceConfiguration getConfiguration() {
        throw new UnsupportedOperationException("The EIS configuration changes depending on authorization, requests should be made directly to EIS instead");
    }

    public EnumSet<TaskType> supportedTaskTypes() {
        return this.authorizationHandler.supportedTaskTypes();
    }

    public boolean hideFromConfigurationApi() {
        throw new UnsupportedOperationException("The EIS configuration changes depending on authorization, requests should be made directly to EIS instead");
    }

    private static ElasticInferenceServiceModel createModel(String inferenceEntityId, TaskType taskType, Map<String, Object> serviceSettings, Map<String, Object> taskSettings, ChunkingSettings chunkingSettings, @Nullable Map<String, Object> secretSettings, ElasticInferenceServiceComponents elasticInferenceServiceComponents, ConfigurationParseContext context) {
        return switch (taskType) {
            case TaskType.SPARSE_EMBEDDING -> new ElasticInferenceServiceSparseEmbeddingsModel(inferenceEntityId, taskType, NAME, serviceSettings, taskSettings, secretSettings, elasticInferenceServiceComponents, context, chunkingSettings);
            case TaskType.CHAT_COMPLETION -> new ElasticInferenceServiceCompletionModel(inferenceEntityId, taskType, NAME, serviceSettings, taskSettings, secretSettings, elasticInferenceServiceComponents, context);
            case TaskType.RERANK -> new ElasticInferenceServiceRerankModel(inferenceEntityId, taskType, NAME, serviceSettings, taskSettings, secretSettings, elasticInferenceServiceComponents, context);
            case TaskType.TEXT_EMBEDDING -> new ElasticInferenceServiceDenseTextEmbeddingsModel(inferenceEntityId, taskType, NAME, serviceSettings, taskSettings, secretSettings, elasticInferenceServiceComponents, context, chunkingSettings);
            default -> throw ServiceUtils.createInvalidTaskTypeException(inferenceEntityId, NAME, taskType, context);
        };
    }

    public Model parsePersistedConfigWithSecrets(String inferenceEntityId, TaskType taskType, Map<String, Object> config, Map<String, Object> secrets) {
        Map<String, Object> serviceSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(config, "service_settings");
        Map<String, Object> taskSettingsMap = ServiceUtils.removeFromMapOrDefaultEmpty(config, "task_settings");
        Map<String, Object> secretSettingsMap = ServiceUtils.removeFromMapOrDefaultEmpty(secrets, "secret_settings");
        ChunkingSettings chunkingSettings = null;
        if (TaskType.SPARSE_EMBEDDING.equals((Object)taskType) || TaskType.TEXT_EMBEDDING.equals((Object)taskType)) {
            chunkingSettings = ChunkingSettingsBuilder.fromMap(ServiceUtils.removeFromMap(config, "chunking_settings"));
        }
        return this.createModelFromPersistent(inferenceEntityId, taskType, serviceSettingsMap, taskSettingsMap, chunkingSettings, secretSettingsMap);
    }

    public Model parsePersistedConfig(String inferenceEntityId, TaskType taskType, Map<String, Object> config) {
        Map<String, Object> serviceSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(config, "service_settings");
        Map<String, Object> taskSettingsMap = ServiceUtils.removeFromMapOrDefaultEmpty(config, "task_settings");
        ChunkingSettings chunkingSettings = null;
        if (TaskType.SPARSE_EMBEDDING.equals((Object)taskType) || TaskType.TEXT_EMBEDDING.equals((Object)taskType)) {
            chunkingSettings = ChunkingSettingsBuilder.fromMap(ServiceUtils.removeFromMap(config, "chunking_settings"));
        }
        return this.createModelFromPersistent(inferenceEntityId, taskType, serviceSettingsMap, taskSettingsMap, chunkingSettings, null);
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_16_0;
    }

    private ElasticInferenceServiceModel createModelFromPersistent(String inferenceEntityId, TaskType taskType, Map<String, Object> serviceSettings, Map<String, Object> taskSettings, ChunkingSettings chunkingSettings, @Nullable Map<String, Object> secretSettings) {
        return ElasticInferenceService.createModel(inferenceEntityId, taskType, serviceSettings, taskSettings, chunkingSettings, secretSettings, this.elasticInferenceServiceComponents, ConfigurationParseContext.PERSISTENT);
    }

    public Model updateModelWithEmbeddingDetails(Model model, int embeddingSize) {
        if (model instanceof ElasticInferenceServiceDenseTextEmbeddingsModel) {
            ElasticInferenceServiceDenseTextEmbeddingsModel embeddingsModel = (ElasticInferenceServiceDenseTextEmbeddingsModel)model;
            ElasticInferenceServiceDenseTextEmbeddingsServiceSettings serviceSettings = embeddingsModel.getServiceSettings();
            String modelId = serviceSettings.modelId();
            SimilarityMeasure similarityFromModel = serviceSettings.similarity();
            SimilarityMeasure similarityToUse = similarityFromModel == null ? ElasticInferenceService.defaultDenseTextEmbeddingsSimilarity() : similarityFromModel;
            Integer maxInputTokens = serviceSettings.maxInputTokens();
            ElasticInferenceServiceDenseTextEmbeddingsServiceSettings updateServiceSettings = new ElasticInferenceServiceDenseTextEmbeddingsServiceSettings(modelId, similarityToUse, embeddingSize, maxInputTokens);
            return new ElasticInferenceServiceDenseTextEmbeddingsModel(embeddingsModel, updateServiceSettings);
        }
        throw ServiceUtils.invalidModelTypeForUpdateModelWithEmbeddingDetails(model.getClass());
    }

    public static SimilarityMeasure defaultDenseTextEmbeddingsSimilarity() {
        return SimilarityMeasure.COSINE;
    }

    private static List<ChunkedInference> translateToChunkedResults(InferenceInputs inputs, InferenceServiceResults inferenceResults) {
        if (inferenceResults instanceof SparseEmbeddingResults) {
            SparseEmbeddingResults sparseEmbeddingResults = (SparseEmbeddingResults)inferenceResults;
            List<String> inputsAsList = inputs.castTo(EmbeddingsInput.class).getInputs();
            return ChunkedInferenceEmbedding.listOf(inputsAsList, (SparseEmbeddingResults)sparseEmbeddingResults);
        }
        if (inferenceResults instanceof ErrorInferenceResults) {
            ErrorInferenceResults error = (ErrorInferenceResults)inferenceResults;
            return List.of(new ChunkedInferenceError(error.getException()));
        }
        String expectedClass = org.elasticsearch.common.Strings.format((String)"%s", (Object[])new Object[]{SparseEmbeddingResults.class.getSimpleName()});
        throw ResultUtils.createInvalidChunkedResultException((String)expectedClass, (String)inferenceResults.getWriteableName());
    }

    private TraceContext getCurrentTraceInfo() {
        ThreadPool threadPool = this.getServiceComponents().threadPool();
        String traceParent = threadPool.getThreadContext().getHeader("traceparent");
        String traceState = threadPool.getThreadContext().getHeader("tracestate");
        return new TraceContext(traceParent, traceState);
    }

    public static InferenceServiceConfiguration createConfiguration(EnumSet<TaskType> enabledTaskTypes) {
        HashMap<String, SettingsConfiguration> configurationMap = new HashMap<String, SettingsConfiguration>();
        configurationMap.put("model_id", new SettingsConfiguration.Builder(EnumSet.of(TaskType.SPARSE_EMBEDDING, TaskType.CHAT_COMPLETION, TaskType.RERANK, TaskType.TEXT_EMBEDDING)).setDescription("The name of the model to use for the inference task.").setLabel("Model ID").setRequired(Boolean.valueOf(true)).setSensitive(Boolean.valueOf(false)).setUpdatable(Boolean.valueOf(false)).setType(SettingsConfigurationFieldType.STRING).build());
        configurationMap.put("max_input_tokens", new SettingsConfiguration.Builder(EnumSet.of(TaskType.SPARSE_EMBEDDING, TaskType.TEXT_EMBEDDING)).setDescription("Allows you to specify the maximum number of tokens per input.").setLabel("Maximum Input Tokens").setRequired(Boolean.valueOf(false)).setSensitive(Boolean.valueOf(false)).setUpdatable(Boolean.valueOf(false)).setType(SettingsConfigurationFieldType.INTEGER).build());
        return new InferenceServiceConfiguration.Builder().setService(NAME).setName(SERVICE_NAME).setTaskTypes(enabledTaskTypes).setConfigurations(configurationMap).build();
    }
}

